/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.povstalec.stellarview.client.render.shader.CelestialShaderInstance;
import net.povstalec.stellarview.client.render.shader.StellarViewVertexFormat;
import org.jetbrains.annotations.Nullable;

public class StellarViewShaders {
    @Nullable
    private static CelestialShaderInstance rendertypeStarShader;
    private static CelestialShaderInstance rendertypeStarTexShader;
    private static CelestialShaderInstance rendertypeDustCloudShader;
    private static CelestialShaderInstance rendertypeStarInstanced;
    private static CelestialShaderInstance rendertypeStarTexInstanced;
    private static CelestialShaderInstance rendertypeDustCloudInstanced;

    public static CelestialShaderInstance starShader() {
        return rendertypeStarShader;
    }

    public static CelestialShaderInstance instancedStarShader() {
        return rendertypeStarInstanced;
    }

    public static CelestialShaderInstance starTexShader() {
        return rendertypeStarTexShader;
    }

    public static CelestialShaderInstance starDustCloudShader() {
        return rendertypeDustCloudShader;
    }

    public static CelestialShaderInstance instancedStarTexShader() {
        return rendertypeStarTexInstanced;
    }

    public static CelestialShaderInstance instancedDustCloudShader() {
        return rendertypeDustCloudInstanced;
    }

    @EventBusSubscriber(modid="stellarview", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ShaderInit {
        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent event) throws IOException {
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_star"), (VertexFormat)StellarViewVertexFormat.STAR_POS_COLOR_LY.get()), shaderInstance -> {
                rendertypeStarShader = (CelestialShaderInstance)((Object)shaderInstance);
            });
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_star_instanced"), DefaultVertexFormat.POSITION), shaderInstance -> {
                rendertypeStarInstanced = (CelestialShaderInstance)((Object)shaderInstance);
            });
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_star_tex"), (VertexFormat)StellarViewVertexFormat.STAR_POS_COLOR_LY_TEX.get()), shaderInstance -> {
                rendertypeStarTexShader = (CelestialShaderInstance)((Object)shaderInstance);
            });
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_star_tex_instanced"), DefaultVertexFormat.POSITION_TEX), shaderInstance -> {
                rendertypeStarTexInstanced = (CelestialShaderInstance)((Object)shaderInstance);
            });
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_dust_cloud"), (VertexFormat)StellarViewVertexFormat.STAR_POS_COLOR_LY_TEX.get()), shaderInstance -> {
                rendertypeDustCloudShader = (CelestialShaderInstance)((Object)shaderInstance);
            });
            event.registerShader((ShaderInstance)new CelestialShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"rendertype_dust_cloud_instanced"), DefaultVertexFormat.POSITION_TEX), shaderInstance -> {
                rendertypeDustCloudInstanced = (CelestialShaderInstance)((Object)shaderInstance);
            });
        }
    }
}

