/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.client.events.StellarViewEvents;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.distinct.Luna;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.BlackHole;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Moon;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Planet;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Star;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.SpaceObjectRenderers;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.StellarViewEffects;
import net.povstalec.stellarview.client.render.ViewCenters;
import net.povstalec.stellarview.client.render.level.StellarViewEndEffects;
import net.povstalec.stellarview.client.render.level.StellarViewNetherEffects;
import net.povstalec.stellarview.client.render.level.StellarViewOverworldEffects;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.DefaultViewCenters;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.client.resourcepack.effects.MeteorEffect;
import net.povstalec.stellarview.common.util.DustCloudInfo;
import net.povstalec.stellarview.common.util.StarInfo;

public class ResourcepackReloadListener {
    public static final ResourceLocation REMOVE = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"remove");
    public static final String PATH = "stellarview";
    public static final String VIEW_CENTERS = "view_centers";
    public static final String CELESTIALS = "celestials";
    public static final String PLANET = "planet";
    public static final String MOON = "moon";
    public static final String STAR = "star";
    public static final String BLACK_HOLE = "black_hole";
    public static final String STAR_FIELD = "star_field";
    public static final String CONSTELLATION = "constellation";
    public static final String NEBULA = "nebula";
    public static final String EFFECTS = "effects";
    public static final String STAR_INFO = "star_info";
    public static final String DUST_CLOUD_INFO = "dust_cloud_info";
    private static final ResourceLocation MILKY_WAY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"star_field/milky_way/milky_way");
    private static final ResourceLocation SOL_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"star/milky_way/sol");
    private static final ResourceLocation LUNA_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"moon/milky_way/sol/earth/luna");
    private static HashMap<ResourceLocation, ViewCenter> viewCenters;
    private static HashMap<ResourceLocation, SpaceObjectRenderer<?>> spaceObjects;
    private static HashMap<ResourceLocation, StarInfo> starTypes;
    private static HashMap<ResourceLocation, DustCloudInfo> dustCloudTypes;

    public static Function<String, IllegalStateException> loggedExceptionProvider(String loggedMessage) {
        return msg -> {
            IllegalStateException e = new IllegalStateException((String)msg);
            StellarView.LOGGER.error("{}", (Object)loggedMessage, (Object)e);
            return e;
        };
    }

    @EventBusSubscriber(modid="stellarview", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        public ReloadListener() {
            super(new GsonBuilder().create(), ResourcepackReloadListener.PATH);
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller filler) {
            if (StellarViewEvents.onReload(jsonMap, manager, filler)) {
                return;
            }
            viewCenters = new HashMap();
            spaceObjects = new HashMap();
            starTypes = new HashMap();
            dustCloudTypes = new HashMap();
            for (Map.Entry<ResourceLocation, JsonElement> jsonEntry : jsonMap.entrySet()) {
                SpaceObjectRenderer renderer;
                ResourceLocation location = jsonEntry.getKey();
                JsonElement element = jsonEntry.getValue();
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.VIEW_CENTERS)) {
                    ReloadListener.addViewCenter(viewCenters, ReloadListener.shortenPath(location, ResourcepackReloadListener.VIEW_CENTERS), element);
                    continue;
                }
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.EFFECTS)) {
                    if (ReloadListener.canShortenPath(location = ReloadListener.shortenPath(location, ResourcepackReloadListener.EFFECTS), ResourcepackReloadListener.STAR_INFO)) {
                        ReloadListener.addStarType(starTypes, ReloadListener.shortenPath(location, ResourcepackReloadListener.STAR_INFO), element);
                        continue;
                    }
                    if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.DUST_CLOUD_INFO)) continue;
                    ReloadListener.addDustCloudType(dustCloudTypes, ReloadListener.shortenPath(location, ResourcepackReloadListener.DUST_CLOUD_INFO), element);
                    continue;
                }
                if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.CELESTIALS)) continue;
                SpaceObject spaceObject = null;
                if (ReloadListener.canShortenPath(location = ReloadListener.shortenPath(location, ResourcepackReloadListener.CELESTIALS), ResourcepackReloadListener.PLANET)) {
                    spaceObject = ReloadListener.makePlanet(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.MOON)) {
                    spaceObject = ReloadListener.makeMoon(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.STAR)) {
                    spaceObject = ReloadListener.makeStar(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.STAR_FIELD)) {
                    spaceObject = ReloadListener.makeStarField(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.CONSTELLATION)) {
                    spaceObject = ReloadListener.makeConstellation(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.BLACK_HOLE)) {
                    spaceObject = ReloadListener.makeBlackHole(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.NEBULA)) {
                    spaceObject = ReloadListener.makeNebula(location, element);
                }
                if (spaceObject == null || ReloadListener.shouldIgnore(spaceObject) || (renderer = SpaceObjectRenderers.constructObjectRenderer(spaceObject)) == null) continue;
                spaceObjects.put(location, renderer);
            }
            if (!StellarViewEvents.onEffectsReload(starTypes, dustCloudTypes)) {
                StellarViewEffects.reset();
                StellarViewEffects.setupEffects(starTypes, dustCloudTypes);
            }
            if (!StellarViewEvents.onSpaceRendererReload(spaceObjects)) {
                SpaceRenderer.clear();
                ReloadListener.setSpaceObjects(spaceObjects);
                SpaceRenderer.setupSynodicOrbits();
            }
            if (!StellarViewEvents.onViewCenterReload(spaceObjects, viewCenters)) {
                ViewCenters.clear();
                ReloadListener.setViewCenters(spaceObjects, viewCenters);
            }
        }

        public static void addViewCenter(HashMap<ResourceLocation, ViewCenter> viewCenters, ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)"view_center");
                ViewCenter viewCenter = StellarViewOverworldEffects.OVERWORLD_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.Overworld.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (StellarViewNetherEffects.NETHER_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.Nether.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (StellarViewEndEffects.END_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.End.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (ViewCenter)ViewCenter.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center"))));
                viewCenters.put(location, viewCenter);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void setViewCenters(HashMap<ResourceLocation, SpaceObjectRenderer<?>> spaceObjects, HashMap<ResourceLocation, ViewCenter> viewCenters) {
            for (Map.Entry<ResourceLocation, ViewCenter> viewCenterEntry : viewCenters.entrySet()) {
                if (!viewCenterEntry.getValue().setViewObjectRenderer(spaceObjects)) continue;
                ViewCenters.addViewCenter(viewCenterEntry.getKey(), viewCenterEntry.getValue());
            }
        }

        public static void addStarType(HashMap<ResourceLocation, StarInfo> starTypes, ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.STAR_INFO);
                StarInfo starInfo = (StarInfo)StarInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star Info"));
                starTypes.put(location, starInfo);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void addDustCloudType(HashMap<ResourceLocation, DustCloudInfo> dustCloudTypes, ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.DUST_CLOUD_INFO);
                DustCloudInfo dustCloudInfo = (DustCloudInfo)DustCloudInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Dust Cloud Info"));
                dustCloudTypes.put(location, dustCloudInfo);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void addMeteorType(HashMap<ResourceLocation, MeteorEffect.MeteorType> meteorTypes, ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)"meteor_type");
                MeteorEffect.MeteorType meteorType = (MeteorEffect.MeteorType)MeteorEffect.MeteorType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Meteor Type"));
                meteorTypes.put(location, meteorType);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static boolean shouldIgnore(SpaceObject spaceObject) {
            if (spaceObject.getParentLocation() != null) {
                return REMOVE.equals((Object)spaceObject.getParentLocation());
            }
            return false;
        }

        public static Star makeStar(ResourceLocation location, JsonElement element) {
            try {
                if (SOL_LOCATION.equals((Object)location)) {
                    JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.STAR);
                    Sol sol = (Sol)Sol.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Sol"));
                    SpaceRenderer.addSol(sol);
                    return sol;
                }
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.STAR);
                Star star = (Star)Star.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star"));
                return star;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static BlackHole makeBlackHole(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.BLACK_HOLE);
                BlackHole blackHole = (BlackHole)BlackHole.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Black Hole"));
                return blackHole;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Planet makePlanet(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.PLANET);
                Planet planet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Planet"));
                return planet;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Moon makeMoon(ResourceLocation location, JsonElement element) {
            try {
                if (LUNA_LOCATION.equals((Object)location)) {
                    JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.MOON);
                    Luna luna = (Luna)Luna.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Luna"));
                    return luna;
                }
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.MOON);
                Moon moon = (Moon)Moon.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Moon"));
                return moon;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static StarField makeStarField(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.STAR_FIELD);
                StarField starField = (StarField)StarField.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star Field"));
                return starField;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Constellation makeConstellation(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.CONSTELLATION);
                Constellation constellation = (Constellation)Constellation.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Constellation"));
                return constellation;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Nebula makeNebula(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)ResourcepackReloadListener.NEBULA);
                Nebula nebula = (Nebula)Nebula.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Nebula"));
                return nebula;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static void setSpaceObjects(HashMap<ResourceLocation, SpaceObjectRenderer<?>> spaceObjects) {
            for (Map.Entry<ResourceLocation, SpaceObjectRenderer<?>> spaceObjectEntry : spaceObjects.entrySet()) {
                SpaceObjectRenderer<?> spaceObject = spaceObjectEntry.getValue();
                Object obj = spaceObject.renderedObject();
                if (obj instanceof Sol) {
                    Sol sol = (Sol)obj;
                    SpaceRenderer.addSol(sol);
                }
                if (((SpaceObject)spaceObject.renderedObject()).getParentLocation() != null) {
                    for (Map.Entry<ResourceLocation, SpaceObjectRenderer<?>> parentEntry : spaceObjects.entrySet()) {
                        if (!parentEntry.getKey().equals((Object)((SpaceObject)spaceObject.renderedObject()).getParentLocation())) continue;
                        parentEntry.getValue().addChild(spaceObject);
                        break;
                    }
                    if (!((SpaceObject)spaceObject.renderedObject()).getParent().isEmpty()) continue;
                    StellarView.LOGGER.error("Failed to find parent for " + spaceObject.toString());
                    continue;
                }
                SpaceRenderer.addSpaceObjectRenderer(spaceObjectEntry.getValue());
            }
            for (Map.Entry<ResourceLocation, SpaceObjectRenderer<?>> spaceObjectEntry : spaceObjects.entrySet()) {
                spaceObjectEntry.getValue().setupSpaceObject(spaceObjectEntry.getKey(), null);
            }
        }

        @SubscribeEvent
        public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ReloadListener());
        }

        private static boolean canShortenPath(ResourceLocation location, String shortenBy) {
            return location.getPath().startsWith(shortenBy + "/") && location.getPath().length() > shortenBy.length();
        }

        private static ResourceLocation shortenPath(ResourceLocation location, String shortenBy) {
            return location.withPath(location.getPath().substring(shortenBy.length() + 1));
        }
    }
}

