/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;
import net.povstalec.stellarview.common.util.UV;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class MeteorEffect {
    public static final UV.Quad UV = new UV.Quad(false);
    public static final float DEFAULT_DISTANCE = 100.0f;
    public static final SphericalCoords SPHERICAL_START = new SphericalCoords(100.0, 0.0, 0.0);
    protected final ArrayList<MeteorType> meteorTypes;
    protected int totalWeight = 0;
    protected double rarity;

    public MeteorEffect(List<MeteorType> meteorTypes, double rarity) {
        this.meteorTypes = new ArrayList<MeteorType>(meteorTypes);
        this.rarity = rarity;
        for (MeteorType meteorType : meteorTypes) {
            this.totalWeight += meteorType.getWeight();
        }
    }

    public List<MeteorType> getMeteorTypes() {
        return this.meteorTypes;
    }

    public boolean canRender(ViewCenter viewCenter) {
        return this.getRarity(viewCenter) > 0.0 && this.meteorTypes.size() > 0;
    }

    public abstract double getRarity(ViewCenter var1);

    public double getRarity() {
        return this.rarity;
    }

    protected boolean shouldAppear(ViewCenter viewCenter, long seed) {
        Random random = new Random(seed);
        return random.nextDouble() <= this.getRarity(viewCenter);
    }

    protected MeteorType getRandomMeteorType(long seed) {
        int i;
        Random random = new Random(seed);
        int weight = random.nextInt(0, this.totalWeight);
        for (i = 0; i < this.meteorTypes.size() - 1 && (weight -= this.meteorTypes.get(i).getWeight()) > 0; ++i) {
        }
        return this.meteorTypes.get(i);
    }

    public Color.FloatRGBA rgba(ViewCenter viewCenter, ClientLevel level, Camera camera, long ticks, float partialTicks) {
        float brightness = LightEffects.getStarBrightness(viewCenter, level, camera, partialTicks) / 2.0f;
        return new Color.FloatRGBA(1.0f, 1.0f, 1.0f, brightness *= LightEffects.rainDimming(level, partialTicks));
    }

    public abstract void render(ViewCenter var1, ClientLevel var2, Camera var3, float var4, Matrix4f var5, Tesselator var6);

    public void render(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks, Matrix4f modelViewMatrix, Tesselator tesselator, float xRotation, float yRotation, float zRotation, MeteorType meteorType, float mulSize, float addRotation) {
        Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
        transformedModelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(yRotation));
        transformedModelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees(zRotation));
        transformedModelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRotation));
        meteorType.render(tesselator, transformedModelView, SPHERICAL_START, this.rgba(viewCenter, level, camera, viewCenter.ticks(), partialTicks), viewCenter.ticks(), mulSize, addRotation);
    }

    public static class MeteorType {
        private final ArrayList<TextureLayer> textureLayers;
        private final int weight;
        public static final Codec<MeteorType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(MeteorType::getTextureLayers), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(MeteorType::getWeight)).apply((Applicative)instance, MeteorType::new));

        public MeteorType(List<TextureLayer> textureLayers, int weight) {
            this.textureLayers = new ArrayList<TextureLayer>(textureLayers);
            this.weight = weight;
        }

        public ArrayList<TextureLayer> getTextureLayers() {
            return this.textureLayers;
        }

        public int getWeight() {
            return this.weight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void renderTextureLayer(TextureLayer textureLayer, Tesselator tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, Color.FloatRGBA rgba, long ticks, float mulSize, float addRotation) {
            if (rgba.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
                return;
            }
            float size = (float)textureLayer.mulSize(mulSize);
            if ((double)size < textureLayer.minSize()) {
                if (!textureLayer.clampAtMinSize()) return;
                size = (float)textureLayer.minSize();
            } else if ((double)size > textureLayer.maxSize()) {
                if (!textureLayer.clampAtMaxSize()) return;
                size = (float)textureLayer.maxSize();
            }
            float rotation = (float)textureLayer.rotation();
            Vector3f corner00 = StellarCoordinates.placeOnSphere(-size, -size, sphericalCoords, rotation);
            Vector3f corner10 = StellarCoordinates.placeOnSphere(size, -size, sphericalCoords, rotation);
            Vector3f corner11 = StellarCoordinates.placeOnSphere(size, size, sphericalCoords, rotation);
            Vector3f corner01 = StellarCoordinates.placeOnSphere(-size, size, sphericalCoords, rotation);
            if (textureLayer.shoulBlend()) {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            RenderSystem.setShaderColor((float)(rgba.red() * textureLayer.rgba().red()), (float)(rgba.green() * textureLayer.rgba().green()), (float)(rgba.blue() * textureLayer.rgba().blue()), (float)(rgba.alpha() * textureLayer.rgba().alpha()));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLayer.texture());
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(lastMatrix, corner00.x, corner00.y, corner00.z).setUv(textureLayer.uv().topRight().u(ticks), textureLayer.uv().topRight().v(ticks));
            bufferbuilder.addVertex(lastMatrix, corner10.x, corner10.y, corner10.z).setUv(textureLayer.uv().bottomRight().u(ticks), textureLayer.uv().bottomRight().v(ticks));
            bufferbuilder.addVertex(lastMatrix, corner11.x, corner11.y, corner11.z).setUv(textureLayer.uv().bottomLeft().u(ticks), textureLayer.uv().bottomLeft().v(ticks));
            bufferbuilder.addVertex(lastMatrix, corner01.x, corner01.y, corner01.z).setUv(textureLayer.uv().topLeft().u(ticks), textureLayer.uv().topLeft().v(ticks));
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.defaultBlendFunc();
        }

        public final void render(Tesselator tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, Color.FloatRGBA rgba, long ticks, float mulSize, float addRotation) {
            for (TextureLayer textureLayer : this.textureLayers) {
                this.renderTextureLayer(textureLayer, tesselator, lastMatrix, sphericalCoords, rgba, ticks, mulSize, addRotation);
            }
        }
    }

    public static class MeteorShower
    extends MeteorEffect {
        protected static final int TICKS = 1000;
        protected static final float MAX_SIZE = 1.0f;
        protected static final int DURATION = 20;
        public static final Codec<MeteorShower> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MeteorType.CODEC.listOf().fieldOf("meteor_types").forGetter(MeteorEffect::getMeteorTypes), (App)Codec.DOUBLE.fieldOf("probability").forGetter(MeteorEffect::getRarity)).apply((Applicative)instance, MeteorShower::new));

        public MeteorShower(List<MeteorType> meteorTypes, double rarity) {
            super(meteorTypes, rarity);
        }

        public MeteorShower() {
            this(new ArrayList<MeteorType>(), 0.0);
        }

        @Override
        public double getRarity(ViewCenter viewCenter) {
            if (!viewCenter.overrideMeteorEffects()) {
                return this.rarity;
            }
            return viewCenter.overrideMeteorShowerRarity();
        }

        @Override
        public final void render(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks, Matrix4f modelViewMatrix, Tesselator tesselator) {
            if (!this.canRender(viewCenter)) {
                return;
            }
            long dailySeed = viewCenter.ticks() / (viewCenter.getRotationPeriod() == 0L ? 24000L : viewCenter.getRotationPeriod());
            if (this.shouldAppear(viewCenter, dailySeed)) {
                double position = viewCenter.ticks() % 20L;
                long meteorRandomizer = viewCenter.ticks() / 20L;
                Random random = new Random(meteorRandomizer);
                float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * Mth.lerp((double)partialTicks, (double)(position - 1.0), (double)position));
                float yRotation = random.nextInt(0, 360);
                float zRotation = random.nextInt(-70, 70);
                MeteorType meteorType = this.getRandomMeteorType(dailySeed);
                float rotation = (float)(Math.PI * position / 4.0);
                float size = (float)Math.sin(Math.PI * position / 20.0);
                this.render(viewCenter, level, camera, partialTicks, modelViewMatrix, tesselator, xRotation, yRotation, zRotation, meteorType, size, rotation);
            }
        }
    }

    public static class ShootingStar
    extends MeteorEffect {
        protected static final int TICKS = 1000;
        protected static final float MAX_SIZE = 1.0f;
        protected static final int DURATION = 20;
        public static final Codec<ShootingStar> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MeteorType.CODEC.listOf().fieldOf("meteor_types").forGetter(MeteorEffect::getMeteorTypes), (App)Codec.DOUBLE.fieldOf("probability").forGetter(MeteorEffect::getRarity)).apply((Applicative)instance, ShootingStar::new));

        public ShootingStar(List<MeteorType> meteorTypes, double rarity) {
            super(meteorTypes, rarity);
        }

        public ShootingStar() {
            this(new ArrayList<MeteorType>(), 0.0);
        }

        @Override
        public double getRarity(ViewCenter viewCenter) {
            if (!viewCenter.overrideMeteorEffects()) {
                return this.rarity;
            }
            return viewCenter.overrideShootingStarRarity();
        }

        @Override
        public final void render(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks, Matrix4f modelViewMatrix, Tesselator tesselator) {
            if (!this.canRender(viewCenter)) {
                return;
            }
            long tickSeed = viewCenter.ticks() / 1000L;
            int specificTime = (int)(viewCenter.ticks() % 1000L);
            Random randomizer = new Random(tickSeed);
            int randomStart = randomizer.nextInt(0, 980);
            if (this.shouldAppear(viewCenter, tickSeed) && specificTime >= randomStart && specificTime < randomStart + 20) {
                double position = viewCenter.ticks() % 20L;
                long shootingStarRandomizer = viewCenter.ticks() / 20L;
                Random random = new Random(shootingStarRandomizer);
                float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * Mth.lerp((double)partialTicks, (double)(position - 1.0), (double)position));
                float yRotation = random.nextInt(0, 360);
                float zRotation = random.nextInt(-70, 70);
                MeteorType meteorType = this.getRandomMeteorType(tickSeed);
                float rotation = (float)(Math.PI * position / 4.0);
                float size = (float)Math.sin(Math.PI * position / 20.0);
                this.render(viewCenter, level, camera, partialTicks, modelViewMatrix, tesselator, xRotation, yRotation, zRotation, meteorType, size, rotation);
            }
        }
    }
}

