/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.screens.config;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.common.config.StellarViewConfigValue;

public class ConfigList
extends ObjectSelectionList<ConfigEntry> {
    public ConfigList(Minecraft minecraft, int screenWidth, int listHeight, int headerHeight, int itemHeight) {
        super(minecraft, screenWidth, listHeight, headerHeight, itemHeight);
    }

    public void add(ConfigEntry entry) {
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public int getRowWidth() {
        return super.getRowWidth() + 45;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 35;
    }

    public static class SliderConfigEntry
    extends ConfigEntry {
        protected AbstractWidget sliderButton;
        protected StellarViewConfigValue.IntValue value;
        protected int multiplier;

        public SliderConfigEntry(Component component1, Component component2, int screenWidth, StellarViewConfigValue.IntValue value, int multiplier) {
            this.value = value;
            this.multiplier = multiplier;
            this.sliderButton = new ExtendedSlider(0, 0, 200, 20, component1, component2, (double)(value.getMin() * multiplier), (double)(value.getMax() * multiplier), (double)(value.get() * multiplier), (double)multiplier, 1, true);
        }

        public SliderConfigEntry(Component component1, Component component2, int screenWidth, StellarViewConfigValue.IntValue value) {
            this(component1, component2, screenWidth, value, 1);
        }

        @Override
        protected void reset() {
            this.value.set(this.value.getDefault());
            ((ExtendedSlider)this.sliderButton).setValue((double)this.value.get() * (double)this.multiplier);
            super.reset();
        }

        protected void onChanged() {
            this.value.set((int)((ExtendedSlider)this.sliderButton).getValue() / this.multiplier);
            this.update();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int key) {
            if (this.sliderButton.isMouseOver(mouseX, mouseY)) {
                ((ExtendedSlider)this.sliderButton).mouseClicked(mouseX, mouseY, key);
            }
            this.onChanged();
            return super.mouseClicked(mouseX, mouseY, key);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int key, double dragX, double dragY) {
            if (this.sliderButton.isMouseOver(mouseX, mouseY)) {
                ((ExtendedSlider)this.sliderButton).mouseDragged(mouseX, mouseY, key, dragX, dragY);
            }
            return super.mouseDragged(mouseX, mouseY, key, dragX, dragY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int key) {
            if (this.sliderButton.isMouseOver(mouseX, mouseY)) {
                ((ExtendedSlider)this.sliderButton).mouseReleased(mouseX, mouseY, key);
            }
            this.onChanged();
            return super.mouseReleased(mouseX, mouseY, key);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            if (this.sliderButton.isMouseOver(mouseX, mouseY)) {
                ((ExtendedSlider)this.sliderButton).mouseMoved(mouseX, mouseY);
            }
            super.mouseMoved(mouseX, mouseY);
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float partialTick) {
            this.sliderButton.setX(k);
            this.sliderButton.setY(j);
            this.sliderButton.render(graphics, n, o, partialTick);
            super.render(graphics, i, j, k, l, m, n, o, bl, partialTick);
        }
    }

    public static class BooleanConfigEntry
    extends ConfigEntry {
        protected AbstractWidget cycleButton;
        StellarViewConfigValue.BooleanValue value;

        public BooleanConfigEntry(Component component, int screenWidth, StellarViewConfigValue.BooleanValue value) {
            this.value = value;
            this.cycleButton = CycleButton.booleanBuilder((Component)Component.translatable((String)"gui.stellarview.true").withStyle(ChatFormatting.GREEN), (Component)Component.translatable((String)"gui.stellarview.false").withStyle(ChatFormatting.RED)).withInitialValue((Object)value.get()).create(0, 0, 200, 20, component, (cycleButton, isTrue) -> {
                value.set((boolean)isTrue);
                this.cycleButton.playDownSound(Minecraft.getInstance().getSoundManager());
            });
        }

        @Override
        protected void reset() {
            this.value.set(this.value.getDefault());
            ((CycleButton)this.cycleButton).setValue((Object)this.value.get());
            super.reset();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int key) {
            if (this.cycleButton.isMouseOver(mouseX, mouseY)) {
                ((AbstractButton)this.cycleButton).onPress();
            }
            this.update();
            return super.mouseClicked(mouseX, mouseY, key);
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float partialTick) {
            this.cycleButton.setX(k);
            this.cycleButton.setY(j);
            this.cycleButton.render(graphics, n, o, partialTick);
            super.render(graphics, i, j, k, l, m, n, o, bl, partialTick);
        }
    }

    public static abstract class ConfigEntry
    extends ObjectSelectionList.Entry<ConfigEntry> {
        protected final AbstractWidget resetToDefault;
        protected final Component reset = Component.translatable((String)"gui.stellarview.reset");

        public ConfigEntry() {
            this.resetToDefault = Button.builder((Component)this.reset, button -> this.reset()).bounds(0, 0, 50, 20).build();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int key) {
            if (this.resetToDefault.isMouseOver(mouseX, mouseY)) {
                ((AbstractButton)this.resetToDefault).onPress();
            }
            return super.mouseClicked(mouseX, mouseY, key);
        }

        protected void reset() {
            this.resetToDefault.playDownSound(Minecraft.getInstance().getSoundManager());
            this.update();
        }

        protected void update() {
            SpaceRenderer.updateSpaceObjects();
        }

        public Component getNarration() {
            return this.reset;
        }

        public void render(GuiGraphics graphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float partialTick) {
            this.resetToDefault.setX(k + 210);
            this.resetToDefault.setY(j);
            this.resetToDefault.render(graphics, n, o, partialTick);
        }
    }
}

