/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.shader.StellarViewShaders;
import net.povstalec.stellarview.client.render.shader.StellarViewVertexFormat;
import net.povstalec.stellarview.client.util.CelestialBuffer;
import net.povstalec.stellarview.client.util.CelestialInstancedBuffer;
import net.povstalec.stellarview.client.util.StarData;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.DustCloudInfo;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.joml.Matrix4f;

public abstract class DustCloudData {
    public static final float DEFAULT_DISTANCE = 100.0f;
    public static final float MAX_SIZE = 50.0f;
    public static final float MAX_ALPHA = 0.025f;
    public static final int HEIGHT_OFFSET = 0;
    public static final int WIDTH_OFFSET = 4;
    public static final int STAR_SIZE_OFFSET = 8;
    public static final int DISTANCE_OFFSET = 12;
    public static final int INSTANCE_SIZE = 10;
    private LOD lod1;

    public void reset() {
        if (this.lod1 != null) {
            this.lod1.reset();
        }
    }

    public void renderDustClouds(Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference, boolean isStatic) {
        if (!isStatic && GeneralConfig.instancing.get() && CelestialInstancedBuffer.INSTANCING_PREREQUISITES) {
            if (this.lod1 == null) {
                this.lod1 = this.newDustClouds();
            }
            this.lod1.renderInstancedDustCloudBuffer(pose, projectionMatrix, difference);
        } else {
            if (this.lod1 == null) {
                this.lod1 = this.newDustClouds();
            }
            this.lod1.renderDustCloudBuffer(pose, projectionMatrix, difference, isStatic);
        }
    }

    protected abstract LOD newDustClouds();

    public static class LOD {
        @Nullable
        protected CelestialBuffer dustCloudBuffer;
        @Nullable
        protected CelestialInstancedBuffer instancedDustCloudBuffer;
        private double[][] dustCloudCoords;
        private double[] dustCloudSizes;
        private short[][] dustCloudRGBA;
        private double[] dustCloudRotations;
        private int dustClouds;

        public LOD(int dustClouds) {
            this.dustCloudCoords = new double[dustClouds][3];
            this.dustCloudSizes = new double[dustClouds];
            this.dustCloudRotations = new double[dustClouds];
            this.dustCloudRGBA = new short[dustClouds][4];
            this.dustClouds = 0;
        }

        public void reset() {
            if (this.dustCloudBuffer != null) {
                this.dustCloudBuffer.close();
                this.dustCloudBuffer = null;
            }
            if (this.instancedDustCloudBuffer != null) {
                this.instancedDustCloudBuffer.close();
                this.instancedDustCloudBuffer = null;
            }
        }

        public void newDustCloud(DustCloudInfo.DustCloudType dustCloudType, Random random, double x, double y, double z, double sizeMultiplier) {
            this.dustCloudCoords[this.dustClouds][0] = x;
            this.dustCloudCoords[this.dustClouds][1] = y;
            this.dustCloudCoords[this.dustClouds][2] = z;
            Color.IntRGB rgb = dustCloudType.getRGB();
            this.dustCloudSizes[this.dustClouds] = (double)dustCloudType.randomSize(random) * sizeMultiplier;
            short alpha = dustCloudType.randomBrightness(random);
            this.dustCloudRGBA[this.dustClouds] = new short[]{(short)rgb.red(), (short)rgb.green(), (short)rgb.blue(), alpha};
            this.dustCloudRotations[this.dustClouds] = random.nextDouble() * Math.PI * 2.0;
            ++this.dustClouds;
        }

        public void createDustCloud(BufferBuilder builder, int i) {
            double sinRandom = Math.sin(this.dustCloudRotations[i]);
            double cosRandom = Math.cos(this.dustCloudRotations[i]);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (j & 2) - 1;
                double bLocation = (j + 1 & 2) - 1;
                double height = aLocation * cosRandom - bLocation * sinRandom;
                double width = bLocation * cosRandom + aLocation * sinRandom;
                builder.addVertex((float)this.dustCloudCoords[i][0], (float)this.dustCloudCoords[i][1], (float)this.dustCloudCoords[i][2]).setColor((int)((byte)this.dustCloudRGBA[i][0]), (int)((byte)this.dustCloudRGBA[i][1]), (int)((byte)this.dustCloudRGBA[i][2]), (int)((byte)this.dustCloudRGBA[i][3]));
                StarData.addStarHeightWidthSizeDistance(builder, (float)height, (float)width, (float)this.dustCloudSizes[i], 1.0E7f);
                builder.setUv((float)(aLocation + 1.0) / 2.0f, (float)(bLocation + 1.0) / 2.0f);
            }
        }

        public float[] getInstancedDustClouds() {
            float[] instances = new float[this.dustClouds * 10];
            for (int i = 0; i < this.dustClouds; ++i) {
                instances[10 * i] = (float)this.dustCloudCoords[i][0];
                instances[10 * i + 1] = (float)this.dustCloudCoords[i][1];
                instances[10 * i + 2] = (float)this.dustCloudCoords[i][2];
                instances[10 * i + 3] = (float)this.dustCloudRGBA[i][0] / 255.0f;
                instances[10 * i + 4] = (float)this.dustCloudRGBA[i][1] / 255.0f;
                instances[10 * i + 5] = (float)this.dustCloudRGBA[i][2] / 255.0f;
                instances[10 * i + 6] = (float)this.dustCloudRGBA[i][3] / 255.0f;
                instances[10 * i + 7] = (float)this.dustCloudRotations[i];
                instances[10 * i + 8] = (float)this.dustCloudSizes[i] * 4.0f;
                instances[10 * i + 9] = 1.0E7f;
            }
            return instances;
        }

        public MeshData getDustCloudBuffer(Tesselator tesselator) {
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, (VertexFormat)StellarViewVertexFormat.STAR_POS_COLOR_LY_TEX.get());
            for (int i = 0; i < this.dustClouds; ++i) {
                this.createDustCloud(bufferBuilder, i);
            }
            return bufferBuilder.build();
        }

        public void renderDustCloudBuffer(Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference, boolean isStatic) {
            if (this.dustClouds == 0) {
                return;
            }
            if (this.dustCloudBuffer == null) {
                if (!SpaceRenderer.loadNewDustClouds()) {
                    return;
                }
                this.dustCloudBuffer = new CelestialBuffer();
                Tesselator tesselator = Tesselator.getInstance();
                RenderSystem.setShader(GameRenderer::getPositionShader);
                MeshData mesh = isStatic ? this.getStaticDustCloudBuffer(tesselator, difference) : this.getDustCloudBuffer(tesselator);
                this.dustCloudBuffer.bind();
                this.dustCloudBuffer.upload(mesh);
                if (isStatic) {
                    this.dustCloudBuffer.drawWithShader(pose, projectionMatrix, GameRenderer.getPositionTexColorShader());
                } else {
                    this.dustCloudBuffer.drawWithShader(pose, projectionMatrix, difference, StellarViewShaders.starDustCloudShader());
                }
                CelestialBuffer.unbind();
                SpaceRenderer.loadedDustClouds(this.dustClouds);
            } else {
                this.dustCloudBuffer.bind();
                if (isStatic) {
                    this.dustCloudBuffer.drawWithShader(pose, projectionMatrix, GameRenderer.getPositionTexColorShader());
                } else {
                    this.dustCloudBuffer.drawWithShader(pose, projectionMatrix, difference, StellarViewShaders.starDustCloudShader());
                }
                CelestialBuffer.unbind();
            }
        }

        private void renderInstancedDustCloudBuffer(Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference) {
            if (this.dustClouds == 0) {
                return;
            }
            if (this.instancedDustCloudBuffer == null) {
                if (!SpaceRenderer.loadNewStars()) {
                    return;
                }
                this.instancedDustCloudBuffer = new CelestialInstancedBuffer();
                this.instancedDustCloudBuffer.upload(this.getInstancedDustClouds(), true);
                SpaceRenderer.loadedStars(this.dustClouds);
            }
            this.instancedDustCloudBuffer.bind();
            this.instancedDustCloudBuffer.drawWithShader(pose, projectionMatrix, difference, StellarViewShaders.instancedDustCloudShader(), this.dustClouds);
            CelestialInstancedBuffer.unbind();
        }

        public MeshData getStaticDustCloudBuffer(Tesselator tesselator, SpaceCoords difference) {
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            for (int i = 0; i < this.dustClouds; ++i) {
                this.createStaticDustCloud(bufferBuilder, i, difference);
            }
            return bufferBuilder.build();
        }

        double clampDustCloud(double size, double distance) {
            double minSize = size * (double)0.04f;
            if ((size = 100000.0 * size / distance) > 50.0) {
                return 50.0;
            }
            return size < minSize ? minSize : size;
        }

        double clampAlpha(double alpha, double distance) {
            double minAlpha = alpha * (double)0.005f;
            if ((alpha = 100000.0 * alpha / distance) < minAlpha) {
                return minAlpha;
            }
            return alpha > (double)0.025f ? (double)0.025f : alpha;
        }

        private void createStaticDustCloud(BufferBuilder builder, int i, SpaceCoords difference) {
            double x = this.dustCloudCoords[i][0] - difference.x().toLy();
            double y = this.dustCloudCoords[i][1] - difference.y().toLy();
            double z = this.dustCloudCoords[i][2] - difference.z().toLy();
            double distance = Math.sqrt(x * x + y * y + z * z);
            short alpha = this.dustCloudRGBA[i][3];
            alpha = (short)(255.0 * this.clampAlpha((double)alpha / 255.0, distance));
            double starSize = this.clampDustCloud(this.dustCloudSizes[i] * 4.0, distance);
            distance = 1.0 / distance;
            double starX = (x *= distance) * 100.0;
            double starY = (y *= distance) * 100.0;
            double starZ = (z *= distance) * 100.0;
            double sphericalTheta = Math.atan2(x, z);
            double sinTheta = Math.sin(sphericalTheta);
            double cosTheta = Math.cos(sphericalTheta);
            double xzLength = Math.sqrt(x * x + z * z);
            double sphericalPhi = Math.atan2(xzLength, y);
            double sinPhi = Math.sin(sphericalPhi);
            double cosPhi = Math.cos(sphericalPhi);
            double sinRandom = Math.sin(this.dustCloudRotations[i]);
            double cosRandom = Math.cos(this.dustCloudRotations[i]);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (j & 2) - 1;
                double bLocation = (j + 1 & 2) - 1;
                double height = (aLocation * cosRandom - bLocation * sinRandom) * starSize;
                double width = (bLocation * cosRandom + aLocation * sinRandom) * starSize;
                double heightProjectionY = height * sinPhi;
                double heightProjectionXZ = -height * cosPhi;
                double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
                double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
                builder.addVertex((float)(starX + projectedX), (float)(starY + heightProjectionY), (float)(starZ + projectedZ)).setUv((float)(aLocation + 1.0) / 2.0f, (float)(bLocation + 1.0) / 2.0f).setColor((int)((byte)this.dustCloudRGBA[i][0]), (int)((byte)this.dustCloudRGBA[i][1]), (int)((byte)this.dustCloudRGBA[i][2]), (int)alpha);
            }
        }
    }
}

