/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.SphericalCoords;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class SpaceCoords
implements INBTSerializable<CompoundTag> {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final double KM_PER_LY = 9.4607304725812E12;
    public static final double MAX_KM_VALUE = 4.7303652362906E12;
    public static final double LIGHT_SPEED = 299792.458;
    public static final SpaceCoords NULL_COORDS = new SpaceCoords();
    public static final Codec<SpaceCoords> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceDistance.CODEC.fieldOf(X).forGetter(SpaceCoords::x), (App)SpaceDistance.CODEC.fieldOf(Y).forGetter(SpaceCoords::y), (App)SpaceDistance.CODEC.fieldOf(Z).forGetter(SpaceCoords::z)).apply((Applicative)instance, SpaceCoords::new));
    private SpaceDistance x;
    private SpaceDistance y;
    private SpaceDistance z;

    public SpaceCoords(SpaceDistance x, SpaceDistance y, SpaceDistance z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SpaceCoords(long lyX, long lyY, long lyZ, double kmX, double kmY, double kmZ) {
        this(new SpaceDistance(lyX, kmX), new SpaceDistance(lyY, kmY), new SpaceDistance(lyZ, kmZ));
    }

    public SpaceCoords(long x, long y, long z) {
        this(x, y, z, 0.0, 0.0, 0.0);
    }

    public SpaceCoords(double x, double y, double z) {
        this(0L, 0L, 0L, x, y, z);
    }

    public SpaceCoords(Vector3f vector) {
        this(0L, 0L, 0L, vector.x, vector.y, vector.z);
    }

    public SpaceCoords() {
        this(0L, 0L, 0L, 0.0, 0.0, 0.0);
    }

    public long lyDistanceSquared() {
        return this.x.ly * this.x.ly + this.y.ly * this.y.ly + this.z.ly * this.z.ly;
    }

    public double distanceSquared(SpaceCoords other) {
        double xDistance = this.x.sub(other.x).toKm();
        double yDistance = this.y.sub(other.y).toKm();
        double zDistance = this.z.sub(other.z).toKm();
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public double distance(SpaceCoords other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public double distanceToCenterSquared() {
        return this.distanceSquared(NULL_COORDS);
    }

    public double distanceToCenter() {
        return this.distance(NULL_COORDS);
    }

    public static Quaterniond getQuaterniond(ClientLevel level, ViewCenter viewCenter, float partialTicks) {
        Quaterniond q = new Quaterniond();
        if (!GeneralConfig.disable_view_center_rotation.get()) {
            viewCenter.getObjectAxisRotation().quaterniond().invert(q);
        }
        return q;
    }

    public static Quaternionf getQuaternionf(ClientLevel level, ViewCenter viewCenter, float partialTicks) {
        Quaternionf q = new Quaternionf();
        if (!GeneralConfig.disable_view_center_rotation.get()) {
            viewCenter.getObjectAxisRotation().quaternionf().invert(q);
        }
        return q;
    }

    public SphericalCoords skyPosition(ClientLevel level, ViewCenter viewCenter, float radius, float partialTicks, boolean adjustForRotation) {
        SpaceCoords viewCenterCoords = viewCenter.getCoords();
        Vector3d positionVector = new Vector3d(this.x.sub(viewCenterCoords.x).toKm(), this.y.sub(viewCenterCoords.y).toKm(), this.z.sub(viewCenterCoords.z).toKm());
        if (adjustForRotation) {
            Quaterniond q = SpaceCoords.getQuaterniond(level, viewCenter, partialTicks);
            q.transform(positionVector);
        }
        return new SphericalCoords(positionVector, (double)radius);
    }

    public SphericalCoords skyPosition(ClientLevel level, ViewCenter viewCenter, float partialTicks, boolean adjustForRotation) {
        SpaceCoords viewCenterCoords = viewCenter.getCoords();
        Vector3d positionVector = new Vector3d(this.x.sub(viewCenterCoords.x).toKm(), this.y.sub(viewCenterCoords.y).toKm(), this.z.sub(viewCenterCoords.z).toKm());
        if (adjustForRotation) {
            Quaterniond q = SpaceCoords.getQuaterniond(level, viewCenter, partialTicks);
            q.transform(positionVector);
        }
        return new SphericalCoords(positionVector);
    }

    public SpaceCoords add(SpaceCoords other) {
        return new SpaceCoords(this.x.add(other.x), this.y.add(other.y), this.z.add(other.z));
    }

    public SpaceCoords add(long x, long y, long z) {
        return new SpaceCoords(this.x.add(x), this.y.add(y), this.z.add(z));
    }

    public SpaceCoords add(Vector3f vector) {
        return new SpaceCoords(this.x.add(vector.x), this.y.add(vector.y), this.z.add(vector.z));
    }

    public SpaceCoords sub(SpaceCoords other) {
        return new SpaceCoords(this.x.sub(other.x), this.y.sub(other.y), this.z.sub(other.z));
    }

    public SpaceCoords sub(Vector3f vector) {
        return new SpaceCoords(this.x.sub(vector.x), this.y.sub(vector.y), this.z.sub(vector.z));
    }

    public SpaceDistance x() {
        return this.x;
    }

    public SpaceDistance y() {
        return this.y;
    }

    public SpaceDistance z() {
        return this.z;
    }

    public SpaceCoords copy() {
        return new SpaceCoords(this.x.copy(), this.y.copy(), this.z.copy());
    }

    public String toString() {
        return "( x: " + this.x.toString() + ", y: " + this.y.toString() + ", z: " + this.z.toString() + " )";
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put(X, (Tag)this.x.serializeNBT(provider));
        tag.put(Y, (Tag)this.y.serializeNBT(provider));
        tag.put(Z, (Tag)this.z.serializeNBT(provider));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.x.deserializeNBT(provider, tag.getCompound(X));
        this.y.deserializeNBT(provider, tag.getCompound(Y));
        this.z.deserializeNBT(provider, tag.getCompound(Z));
    }

    public static class SpaceDistance
    implements INBTSerializable<CompoundTag> {
        public static final String LY = "ly";
        public static final String KM = "km";
        protected long ly;
        protected double km;
        public static final Codec<SpaceDistance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf(LY, (Object)0L).forGetter(SpaceDistance::ly), (App)Codec.DOUBLE.optionalFieldOf(KM, (Object)0.0).forGetter(SpaceDistance::km)).apply((Applicative)instance, SpaceDistance::new));

        public SpaceDistance(long lightYears, double kilometers) {
            this.ly = lightYears;
            this.km = kilometers;
            this.handleKmOverflow();
        }

        public SpaceDistance(long lightYears) {
            this(lightYears, 0.0);
        }

        public SpaceDistance() {
            this(0L, 0.0);
        }

        public SpaceDistance(double kilometers) {
            this(0L, kilometers);
        }

        protected void handleKmOverflow() {
            if (this.km >= 9.4607304725812E12 || this.km <= -9.4607304725812E12) {
                long additionalLightYears = SpaceDistance.kmToLy(this.km);
                double subKm = this.km - SpaceDistance.lyToKm(additionalLightYears);
                this.ly += additionalLightYears;
                this.km -= subKm;
            }
        }

        public long ly() {
            return this.ly;
        }

        public double km() {
            return this.km;
        }

        public static long kmToLy(double km) {
            return (long)(km / 9.4607304725812E12);
        }

        public static double lyToKm(long ly) {
            return 9.4607304725812E12 * (double)ly;
        }

        public double toKm() {
            return this.km + SpaceDistance.lyToKm(this.ly);
        }

        public double toLy() {
            return this.ly + SpaceDistance.kmToLy(this.km);
        }

        public SpaceDistance add(SpaceDistance other) {
            return new SpaceDistance(this.ly + other.ly, this.km + other.km);
        }

        public SpaceDistance add(double value) {
            return new SpaceDistance(this.ly, this.km + value);
        }

        public SpaceDistance add(long value) {
            return new SpaceDistance(this.ly + value, this.km);
        }

        public SpaceDistance sub(SpaceDistance other) {
            return new SpaceDistance(this.ly - other.ly, this.km - other.km);
        }

        public SpaceDistance sub(double value) {
            return new SpaceDistance(this.ly, this.km - value);
        }

        public SpaceDistance sub(long value) {
            return new SpaceDistance(this.ly - value, this.km);
        }

        public SpaceDistance mul(double value, boolean roundDown) {
            double result = (double)this.ly * value;
            long ly = (long)result;
            return new SpaceDistance(ly, roundDown ? 0.0 : result - (double)ly);
        }

        public SpaceDistance copy() {
            return new SpaceDistance(this.ly, this.km);
        }

        public String toString() {
            return "[ly: " + this.ly + ", km: " + this.km + "]";
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putLong(LY, this.ly);
            tag.putDouble(KM, this.km);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.ly = tag.getLong(LY);
            this.km = tag.getDouble(KM);
        }
    }
}

