/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.shader.CelestialShaderInstance;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class CelestialBuffer
implements AutoCloseable {
    private int vertexBufferId;
    private int indexBufferId;
    private int arrayObjectId;
    @Nullable
    private VertexFormat format;
    @Nullable
    private RenderSystem.AutoStorageIndexBuffer sequentialIndices;
    private VertexFormat.IndexType indexType;
    private int indexCount;
    private VertexFormat.Mode mode;

    public CelestialBuffer() {
        RenderSystem.m_187554_();
        this.vertexBufferId = GlStateManager.m_84537_();
        this.indexBufferId = GlStateManager.m_84537_();
        this.arrayObjectId = GlStateManager.m_157089_();
    }

    public void upload(BufferBuilder.RenderedBuffer buffer) {
        if (!this.isInvalid()) {
            RenderSystem.m_187554_();
            try {
                BufferBuilder.DrawState bufferbuilder$drawstate = buffer.m_231198_();
                this.format = this.uploadVertexBuffer(bufferbuilder$drawstate, buffer.m_231196_());
                this.sequentialIndices = this.uploadIndexBuffer(bufferbuilder$drawstate, buffer.m_231197_());
                this.indexCount = bufferbuilder$drawstate.f_166797_();
                this.indexType = bufferbuilder$drawstate.f_166798_();
                this.mode = bufferbuilder$drawstate.f_85735_();
            }
            finally {
                buffer.m_231200_();
            }
        }
    }

    private VertexFormat uploadVertexBuffer(BufferBuilder.DrawState drawState, ByteBuffer vertexBuffer) {
        boolean formatEquals = false;
        if (!drawState.f_85733_().equals((Object)this.format)) {
            if (this.format != null) {
                this.format.m_86024_();
            }
            GlStateManager.m_84480_((int)34962, (int)this.vertexBufferId);
            drawState.f_85733_().m_166912_();
            formatEquals = true;
        }
        if (!drawState.f_166799_()) {
            if (!formatEquals) {
                GlStateManager.m_84480_((int)34962, (int)this.vertexBufferId);
            }
            RenderSystem.m_69525_((int)34962, (ByteBuffer)vertexBuffer, (int)35044);
        }
        return drawState.f_85733_();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer uploadIndexBuffer(BufferBuilder.DrawState drawState, ByteBuffer indexBuffer) {
        if (!drawState.f_166800_()) {
            GlStateManager.m_84480_((int)34963, (int)this.indexBufferId);
            RenderSystem.m_69525_((int)34963, (ByteBuffer)indexBuffer, (int)35044);
            return null;
        }
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.m_221941_((VertexFormat.Mode)drawState.f_85735_());
        if (rendersystem$autostorageindexbuffer != this.sequentialIndices || !rendersystem$autostorageindexbuffer.m_221944_(drawState.f_166797_())) {
            rendersystem$autostorageindexbuffer.m_221946_(drawState.f_166797_());
        }
        return rendersystem$autostorageindexbuffer;
    }

    public void bind() {
        BufferUploader.m_231208_();
        GlStateManager.m_157068_((int)this.arrayObjectId);
    }

    public static void unbind() {
        BufferUploader.m_231208_();
        GlStateManager.m_157068_((int)0);
    }

    public void draw() {
        RenderSystem.m_157186_((int)this.mode.f_166946_, (int)this.indexCount, (int)this.getIndexType().f_166923_);
    }

    private VertexFormat.IndexType getIndexType() {
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = this.sequentialIndices;
        return rendersystem$autostorageindexbuffer != null ? rendersystem$autostorageindexbuffer.m_157483_() : this.indexType;
    }

    public void drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, ShaderInstance shaderInstance) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this._drawWithShader(new Matrix4f((Matrix4fc)modelViewMatrix), new Matrix4f((Matrix4fc)projectionMatrix), shaderInstance));
        } else {
            this._drawWithShader(modelViewMatrix, projectionMatrix, shaderInstance);
        }
    }

    public void drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, SpaceCoords relativeSpacePos, CelestialShaderInstance shaderInstance) {
        Vector3f relativeVectorLy = new Vector3f((float)relativeSpacePos.x().ly(), (float)relativeSpacePos.y().ly(), (float)relativeSpacePos.z().ly());
        Vector3f relativeVectorKm = new Vector3f((float)relativeSpacePos.x().km(), (float)relativeSpacePos.y().km(), (float)relativeSpacePos.z().km());
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this._drawWithShader(new Matrix4f((Matrix4fc)modelViewMatrix), new Matrix4f((Matrix4fc)projectionMatrix), relativeVectorLy, relativeVectorKm, shaderInstance));
        } else {
            this._drawWithShader(modelViewMatrix, projectionMatrix, relativeVectorLy, relativeVectorKm, shaderInstance);
        }
    }

    private void _drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, ShaderInstance shaderInstance) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.m_157203_((int)i);
            shaderInstance.m_173350_("Sampler" + i, (Object)j);
        }
        if (shaderInstance.f_173308_ != null) {
            shaderInstance.f_173308_.m_5679_(modelViewMatrix);
        }
        if (shaderInstance.f_173309_ != null) {
            shaderInstance.f_173309_.m_5679_(projectionMatrix);
        }
        if (shaderInstance.f_200956_ != null) {
            shaderInstance.f_200956_.m_200759_(RenderSystem.m_253191_());
        }
        if (shaderInstance.f_173312_ != null) {
            shaderInstance.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shaderInstance.f_173315_ != null) {
            shaderInstance.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shaderInstance.f_173316_ != null) {
            shaderInstance.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shaderInstance.f_173317_ != null) {
            shaderInstance.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shaderInstance.f_202432_ != null) {
            shaderInstance.f_202432_.m_142617_(RenderSystem.m_202041_().m_202324_());
        }
        if (shaderInstance.f_173310_ != null) {
            shaderInstance.f_173310_.m_5679_(RenderSystem.m_252744_());
        }
        if (shaderInstance.f_173319_ != null) {
            shaderInstance.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shaderInstance.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shaderInstance.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (shaderInstance.f_173318_ != null && (this.mode == VertexFormat.Mode.LINES || this.mode == VertexFormat.Mode.LINE_STRIP)) {
            shaderInstance.f_173318_.m_5985_(RenderSystem.m_157202_());
        }
        RenderSystem.m_157461_((ShaderInstance)shaderInstance);
        shaderInstance.m_173363_();
        this.draw();
        shaderInstance.m_173362_();
    }

    private void _drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Vector3f relativeSpaceLy, Vector3f relativeSpaceKm, CelestialShaderInstance shaderInstance) {
        if (shaderInstance.RELATIVE_SPACE_LY != null) {
            shaderInstance.RELATIVE_SPACE_LY.m_142276_(relativeSpaceLy);
        }
        if (shaderInstance.RELATIVE_SPACE_KM != null) {
            shaderInstance.RELATIVE_SPACE_KM.m_142276_(relativeSpaceKm);
        }
        if (shaderInstance.LENSING_MAT != null) {
            shaderInstance.LENSING_MAT.m_200759_(SpaceRenderer.lensingMatrix);
        }
        if (shaderInstance.LENSING_MAT_INV != null) {
            shaderInstance.LENSING_MAT_INV.m_200759_(SpaceRenderer.lensingMatrixInv);
        }
        if (shaderInstance.LENSING_INTENSITY != null) {
            shaderInstance.LENSING_INTENSITY.m_5985_(SpaceRenderer.lensingIntensity);
        }
        this._drawWithShader(modelViewMatrix, projectionMatrix, shaderInstance);
    }

    @Override
    public void close() {
        if (this.vertexBufferId >= 0) {
            RenderSystem.m_69529_((int)this.vertexBufferId);
            this.vertexBufferId = -1;
        }
        if (this.indexBufferId >= 0) {
            RenderSystem.m_69529_((int)this.indexBufferId);
            this.indexBufferId = -1;
        }
        if (this.arrayObjectId >= 0) {
            RenderSystem.m_157213_((int)this.arrayObjectId);
            this.arrayObjectId = -1;
        }
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    public boolean isInvalid() {
        return this.arrayObjectId == -1;
    }
}

