/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.stellarview.common.util.Color;

public class DustCloudInfo
implements INBTSerializable<CompoundTag> {
    public static final String DUST_CLOUD_TYPES = "dust_cloud_types";
    public static final String TOTAL_WEIGHT = "total_weight";
    private ArrayList<DustCloudType> dustCloudTypes;
    private int totalWeight = 0;
    public static final DustCloudType WHITE_DUST_CLOUD = new DustCloudType(new Color.IntRGB(107, 107, 107), 2.0f, 7.0f, 255, 255, 1);
    public static final List<DustCloudType> DEFAULT_DUST_CLOUDS = Arrays.asList(WHITE_DUST_CLOUD);
    public static final DustCloudInfo DEFAULT_DUST_CLOUD_INFO = new DustCloudInfo(DEFAULT_DUST_CLOUDS);
    public static final Codec<DustCloudInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DustCloudType.CODEC.listOf().fieldOf(DUST_CLOUD_TYPES).forGetter(dustCloudInfo -> dustCloudInfo.dustCloudTypes)).apply((Applicative)instance, DustCloudInfo::new));

    public DustCloudInfo() {
    }

    public DustCloudInfo(List<DustCloudType> dustCloudTypes, int totalWeight) {
        this.dustCloudTypes = new ArrayList<DustCloudType>(dustCloudTypes);
        this.totalWeight = totalWeight;
    }

    public DustCloudInfo(List<DustCloudType> dustCloudTypes) {
        this.dustCloudTypes = new ArrayList<DustCloudType>(dustCloudTypes);
        for (DustCloudType dustCloudType : dustCloudTypes) {
            this.totalWeight += dustCloudType.getWeight();
        }
    }

    public DustCloudType getRandomDustCloudType(Random random) {
        int i;
        if (this.dustCloudTypes.isEmpty()) {
            return WHITE_DUST_CLOUD;
        }
        int weight = random.nextInt(0, this.totalWeight + 1);
        for (i = 0; i < this.dustCloudTypes.size() - 1 && (weight -= this.dustCloudTypes.get(i).getWeight()) > 0; ++i) {
        }
        return this.dustCloudTypes.get(i);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag dustCloudTypesTag = new CompoundTag();
        for (int i = 0; i < this.dustCloudTypes.size(); ++i) {
            dustCloudTypesTag.m_128365_("dust_cloud_type_" + i, (Tag)this.dustCloudTypes.get(i).serializeNBT());
        }
        tag.m_128365_(DUST_CLOUD_TYPES, (Tag)dustCloudTypesTag);
        tag.m_128405_(TOTAL_WEIGHT, this.totalWeight);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.dustCloudTypes = new ArrayList();
        CompoundTag dustCloudTypesTag = tag.m_128469_(DUST_CLOUD_TYPES);
        for (int i = 0; i < dustCloudTypesTag.m_128440_(); ++i) {
            DustCloudType dustCloudType = new DustCloudType();
            dustCloudType.deserializeNBT(dustCloudTypesTag.m_128469_("dust_cloud_type_" + i));
            this.dustCloudTypes.add(dustCloudType);
        }
        this.totalWeight = tag.m_128451_(TOTAL_WEIGHT);
    }

    public static class DustCloudType
    implements INBTSerializable<CompoundTag> {
        public static final String RGB = "rgb";
        public static final String MAX_SIZE = "max_size";
        public static final String MIN_SIZE = "min_size";
        public static final String MAX_BRIGHTNESS = "max_brightness";
        public static final String MIN_BRIGHTNESS = "min_brightness";
        public static final String WEIGHT = "weight";
        private Color.IntRGB rgb;
        private float minSize;
        private float maxSize;
        private short minBrightness;
        private short maxBrightness;
        public int weight;
        public static final Codec<DustCloudType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Color.IntRGB.CODEC.fieldOf(RGB).forGetter(DustCloudType::getRGB), (App)Codec.FLOAT.fieldOf(MIN_SIZE).forGetter(dustCloudType -> Float.valueOf(dustCloudType.minSize)), (App)Codec.FLOAT.fieldOf(MAX_SIZE).forGetter(dustCloudType -> Float.valueOf(dustCloudType.maxSize)), (App)Codec.SHORT.fieldOf(MIN_BRIGHTNESS).forGetter(dustCloudType -> dustCloudType.minBrightness), (App)Codec.SHORT.fieldOf(MAX_BRIGHTNESS).forGetter(dustCloudType -> dustCloudType.maxBrightness), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(WEIGHT).forGetter(DustCloudType::getWeight)).apply((Applicative)instance, DustCloudType::new));

        public DustCloudType() {
        }

        public DustCloudType(Color.IntRGB rgb, float minSize, float maxSize, short minBrightness, short maxBrightness, int weight) {
            this.rgb = rgb;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minBrightness = minBrightness;
            this.maxBrightness = maxBrightness;
            this.weight = weight;
        }

        public Color.IntRGB getRGB() {
            return this.rgb;
        }

        public int getWeight() {
            return this.weight;
        }

        public float randomSize(Random random) {
            if (this.minSize == this.maxSize) {
                return this.maxSize;
            }
            return random.nextFloat(this.minSize, this.maxSize);
        }

        public short randomBrightness(Random random) {
            if (this.minBrightness == this.maxBrightness) {
                return this.maxBrightness;
            }
            return (short)random.nextInt(this.minBrightness, this.maxBrightness + 1);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(RGB, (Tag)this.rgb.serializeNBT());
            tag.m_128350_(MIN_SIZE, this.minSize);
            tag.m_128350_(MAX_SIZE, this.maxSize);
            tag.m_128376_(MIN_BRIGHTNESS, this.minBrightness);
            tag.m_128376_(MAX_BRIGHTNESS, this.maxBrightness);
            tag.m_128405_(WEIGHT, this.weight);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.rgb = new Color.IntRGB();
            this.rgb.deserializeNBT(tag.m_128469_(RGB));
            this.minSize = tag.m_128457_(MIN_SIZE);
            this.maxSize = tag.m_128457_(MAX_SIZE);
            this.minBrightness = tag.m_128448_(MIN_BRIGHTNESS);
            this.maxBrightness = tag.m_128448_(MAX_BRIGHTNESS);
            this.weight = tag.m_128451_(WEIGHT);
        }
    }
}

