/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.povstalec.stellarview.api.common.space_objects.GravityLense;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public class SupernovaLeftover
extends GravityLense {
    public static final Codec<SupernovaLeftover> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)OrbitingObject.OrbitInfo.CODEC.optionalFieldOf("orbit_info").forGetter(leftover -> Optional.ofNullable(leftover.orbitInfo())), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_STAR_HANDLER).forGetter(TexturedObject::getFadeOutHandler), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("min_star_size", (Object)Float.valueOf(0.08f)).forGetter(StarLike::getMinStarSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("max_star_alpha", (Object)Float.valueOf(1.0f)).forGetter(StarLike::getMaxStarAlpha), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("min_star_alpha", (Object)Float.valueOf(0.1f)).forGetter(StarLike::getMinStarAlpha), (App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).optionalFieldOf("lensing_intensity", (Object)Float.valueOf(2.0f)).forGetter(GravityLense::getLensingIntensity), (App)Codec.DOUBLE.optionalFieldOf("max_lensing_distance", (Object)1.0E10).forGetter(GravityLense::getMaxLensingDistance)).apply((Applicative)instance, SupernovaLeftover::new));

    public SupernovaLeftover() {
    }

    public SupernovaLeftover(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitingObject.OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, float minStarSize, float maxStarAlpha, float minStarAlpha, float lensingIntensity, double maxLensingDistance) {
        super(parent, coords, axisRotation, orbitInfo, textureLayers, fadeOutHandler, minStarSize, maxStarAlpha, minStarAlpha, lensingIntensity, maxLensingDistance);
    }
}

