/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level.misc;

import com.mojang.math.Vector3f;

public class StellarCoordinates {
    public static double sphericalR(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double sphericalTheta(double x, double y, double z) {
        return Math.atan2(x, z);
    }

    public static double sphericalPhi(double x, double y, double z) {
        double xzLength = Math.sqrt(x * x + z * z);
        return Math.atan2(xzLength, y);
    }

    public static Vector3f cartesianToSpherical(Vector3f cartesianCoordinates) {
        float x = cartesianCoordinates.m_122239_();
        float y = cartesianCoordinates.m_122260_();
        float z = cartesianCoordinates.m_122269_();
        return new Vector3f((float)StellarCoordinates.sphericalR(x, y, z), (float)StellarCoordinates.sphericalTheta(x, y, z), (float)StellarCoordinates.sphericalPhi(x, y, z));
    }

    public static double cartesianX(double r, double theta, double phi) {
        return r * Math.sin(phi) * Math.sin(theta);
    }

    public static double cartesianY(double r, double theta, double phi) {
        return r * Math.cos(phi);
    }

    public static double cartesianZ(double r, double theta, double phi) {
        return r * Math.sin(phi) * Math.cos(theta);
    }

    public static Vector3f sphericalToCartesian(Vector3f sphericalCoordinates) {
        float r = sphericalCoordinates.m_122239_();
        float theta = sphericalCoordinates.m_122260_();
        float phi = sphericalCoordinates.m_122269_();
        return new Vector3f((float)StellarCoordinates.cartesianX(r, theta, phi), (float)StellarCoordinates.cartesianY(r, theta, phi), (float)StellarCoordinates.cartesianZ(r, theta, phi));
    }

    public static double[] moveSpherical(double offsetX, double offsetY, double r, double theta, double phi) {
        double x = StellarCoordinates.cartesianX(r, theta, phi);
        double y = StellarCoordinates.cartesianY(r, theta, phi);
        double z = StellarCoordinates.cartesianZ(r, theta, phi);
        return new double[]{x += -offsetY * Math.cos(phi) * Math.sin(theta) - offsetX * Math.cos(theta), y += offsetY * Math.sin(phi), z += -offsetY * Math.cos(phi) * Math.cos(theta) + offsetX * Math.sin(theta)};
    }

    public static float[] placeOnSphere(float offsetX, float offsetY, float r, double theta, double phi, double rotation) {
        double x = StellarCoordinates.cartesianX(r, theta, phi);
        double y = StellarCoordinates.cartesianY(r, theta, phi);
        double z = StellarCoordinates.cartesianZ(r, theta, phi);
        double polarR = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        double polarPhi = Math.atan2(offsetY, offsetX);
        double polarX = polarR * Math.cos(polarPhi += rotation);
        double polarY = polarR * Math.sin(polarPhi);
        return new float[]{(float)(x += -polarY * Math.cos(phi) * Math.sin(theta) - polarX * Math.cos(theta)), (float)(y += polarY * Math.sin(phi)), (float)(z += -polarY * Math.cos(phi) * Math.cos(theta) + polarX * Math.sin(theta))};
    }

    public static double spiralR(double r, double phi, double beta) {
        return r * (phi + beta);
    }

    public static double elipticalR(double a, double b, double phi) {
        return a * b / Math.sqrt(b * Math.pow(Math.cos(phi), 2.0) + a * Math.pow(Math.sin(phi), 2.0));
    }

    public static Vector3f addVectors(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.m_122239_() + vector2.m_122239_(), vector1.m_122260_() + vector2.m_122260_(), vector1.m_122269_() + vector2.m_122269_());
    }

    public static Vector3f subtractVectors(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.m_122239_() - vector2.m_122239_(), vector1.m_122260_() - vector2.m_122260_(), vector1.m_122269_() - vector2.m_122269_());
    }

    public static Vector3f relativeVector(Vector3f vector1, Vector3f vector2) {
        return StellarCoordinates.subtractVectors(vector1, vector2);
    }

    public static Vector3f absoluteVector(Vector3f vector1, Vector3f vector2) {
        return StellarCoordinates.addVectors(vector1, vector2);
    }

    public static float lengthSquared(Vector3f vector) {
        return Math.fma(vector.m_122239_(), vector.m_122239_(), Math.fma(vector.m_122260_(), vector.m_122260_(), vector.m_122269_() * vector.m_122269_()));
    }
}

