/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.space_objects.OrbitingObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;

public abstract class StarLikeRenderer<T extends StarLike>
extends OrbitingObjectRenderer<T> {
    public StarLikeRenderer(T starLike) {
        super(starLike);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, ClientLevel level, Camera camera, BufferBuilder bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        double lyDistance = distance / 9.4607304725812E12;
        Color.FloatRGBA starRGBA = ((StarLike)this.renderedObject).starRGBA(lyDistance);
        if (starRGBA.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        StarLike cfr_ignored_0 = (StarLike)this.renderedObject;
        float size = (float)textureLayer.mulSize(StarLike.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
            size = ((StarLike)this.renderedObject).starSize(size, lyDistance);
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        StarLikeRenderer.renderOnSphere(textureLayer.rgba(), starRGBA, textureLayer.texture(), textureLayer.uv(), level, camera, bufferbuilder, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.dayBrightness(viewCenter, size, ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation(), textureLayer.shoulBlend());
    }
}

