/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects.resourcepack;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.space_objects.TexturedObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;

public class NebulaRenderer<T extends Nebula>
extends TexturedObjectRenderer<T> {
    public NebulaRenderer(T nebula) {
        super(nebula);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, ClientLevel level, Camera camera, BufferBuilder bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        double lyDistance = distance / 9.4607304725812E12;
        Color.FloatRGBA nebulaRGBA = ((Nebula)this.renderedObject).nebulaRGBA(lyDistance);
        if (nebulaRGBA.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        Nebula cfr_ignored_0 = (Nebula)this.renderedObject;
        float size = (float)textureLayer.mulSize(Nebula.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
            size = ((Nebula)this.renderedObject).nebulaSize(size, lyDistance);
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        NebulaRenderer.renderOnSphere(textureLayer.rgba(), nebulaRGBA, textureLayer.texture(), textureLayer.uv(), level, camera, bufferbuilder, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.nebulaBrightness(viewCenter, size, ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation(), textureLayer.shoulBlend());
    }
}

