/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects.resourcepack;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.render.StellarViewEffects;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.ConstellationRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.client.util.DustCloudData;
import net.povstalec.stellarview.client.util.StarData;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.DustCloudInfo;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.StarInfo;
import net.povstalec.stellarview.common.util.StellarCoordinates;

public class StarFieldRenderer<T extends StarField>
extends SpaceObjectRenderer<T> {
    protected boolean hasTexture = GeneralConfig.textured_stars.get();
    @Nullable
    protected StarInfo starInfo;
    protected StarData starData;
    protected int lod1stars = 0;
    protected int lod2stars = 0;
    protected int lod3stars = 0;
    protected int totalLOD1stars;
    protected int totalLOD2stars;
    protected int totalLOD3stars;
    protected int[] armLod1stars;
    protected int[] armLod2stars;
    @Nullable
    protected DustCloudInfo dustCloudInfo;
    @Nullable
    protected DustCloudInfo[] armDustCloudInfo;
    protected DustCloudData dustCloudData;
    protected int totalDustClouds;
    protected ArrayList<Constellation.StarDefinition> lod1definedStars;
    protected ArrayList<Constellation.StarDefinition> lod2definedStars;
    protected ArrayList<Constellation.StarDefinition> lod3definedStars;

    public StarFieldRenderer(T starField) {
        super(starField);
        this.totalDustClouds = ((StarField)starField).getDustClouds();
        this.armDustCloudInfo = new DustCloudInfo[((StarField)this.renderedObject).getSpiralArms().size()];
        this.armLod1stars = new int[((StarField)this.renderedObject).getSpiralArms().size()];
        this.armLod2stars = new int[((StarField)this.renderedObject).getSpiralArms().size()];
        this.lod1definedStars = new ArrayList();
        this.lod2definedStars = new ArrayList();
        this.lod3definedStars = new ArrayList();
    }

    @Override
    public void addChildRaw(SpaceObjectRenderer<?> child) {
        super.addChildRaw(child);
        if (child instanceof ConstellationRenderer) {
            ConstellationRenderer constellation = (ConstellationRenderer)child;
            this.addConstellation((Constellation)constellation.renderedObject());
        }
    }

    @Override
    public void addChild(SpaceObjectRenderer<?> child) {
        super.addChild(child);
        if (child instanceof ConstellationRenderer) {
            ConstellationRenderer constellation = (ConstellationRenderer)child;
            this.addConstellation((Constellation)constellation.renderedObject());
        }
    }

    public void addConstellation(Constellation constellation) {
        constellation.relativeStars();
        this.lod1definedStars.addAll(constellation.lod1stars());
        this.lod2definedStars.addAll(constellation.lod2stars());
        this.lod3definedStars.addAll(constellation.lod3stars());
    }

    protected void setupLOD(StarInfo starInfo) {
        this.lod1stars = (int)((float)((StarField)this.renderedObject).getStars() * ((float)starInfo.lod1Weight() / (float)starInfo.totalWeight()));
        this.lod2stars = (int)((float)((StarField)this.renderedObject).getStars() * ((float)starInfo.lod2Weight() / (float)starInfo.totalWeight()));
        this.lod3stars = ((StarField)this.renderedObject).getStars() - this.lod1stars - this.lod2stars;
        this.lod1stars += this.lod1definedStars.size();
        this.lod2stars += this.lod2definedStars.size();
        this.lod3stars += this.lod3definedStars.size();
        this.totalLOD1stars = this.lod1stars;
        this.totalLOD2stars = this.lod2stars;
        this.totalLOD3stars = this.lod3stars;
        int i = 0;
        for (StarField.SpiralArm arm : ((StarField)this.renderedObject).getSpiralArms()) {
            this.armLod1stars[i] = (int)((float)arm.armStars() * ((float)starInfo.lod1Weight() / (float)starInfo.totalWeight()));
            this.armLod2stars[i] = (int)((float)arm.armStars() * ((float)starInfo.lod2Weight() / (float)starInfo.totalWeight()));
            this.totalLOD1stars += this.armLod1stars[i];
            this.totalLOD2stars += this.armLod2stars[i];
            this.totalLOD3stars += arm.armStars() - this.armLod1stars[i] - this.armLod2stars[i];
            this.totalDustClouds += arm.armDustClouds();
            ++i;
        }
    }

    public boolean requiresReset() {
        return this.hasTexture != GeneralConfig.textured_stars.get();
    }

    public void reset() {
        if (this.starData != null) {
            this.starData.reset();
        }
        if (this.dustCloudData != null) {
            this.dustCloudData.reset();
        }
    }

    public void setStarInfo(StarInfo starInfo) {
        this.starInfo = starInfo;
    }

    public void setupStarInfo() {
        if (((StarField)this.renderedObject()).getStarInfo() != null && StellarViewEffects.hasStarInfo(((StarField)this.renderedObject()).getStarInfo())) {
            this.setStarInfo(StellarViewEffects.getStarInfo(((StarField)this.renderedObject()).getStarInfo()));
        }
    }

    public StarInfo getStarInfo() {
        if (this.starInfo == null) {
            return StarInfo.DEFAULT_STAR_INFO;
        }
        return this.starInfo;
    }

    public void setDustCloudInfo(DustCloudInfo dustCloudInfo) {
        this.dustCloudInfo = dustCloudInfo;
    }

    public void setupDustCloudInfo() {
        if (((StarField)this.renderedObject()).getDustCloudInfo() != null && StellarViewEffects.hasDustCloudInfo(((StarField)this.renderedObject()).getDustCloudInfo())) {
            this.setDustCloudInfo(StellarViewEffects.getDustCloudInfo(((StarField)this.renderedObject()).getDustCloudInfo()));
        }
        for (int i = 0; i < this.armDustCloudInfo.length; ++i) {
            ResourceLocation location = ((StarField)this.renderedObject).getSpiralArms().get(i).dustCloudInfo();
            if (location == null || !StellarViewEffects.hasDustCloudInfo(location)) continue;
            this.setArmDustCloudInfo(StellarViewEffects.getDustCloudInfo(location), i);
        }
    }

    public DustCloudInfo getDustCloudInfo() {
        if (this.dustCloudInfo == null) {
            return DustCloudInfo.DEFAULT_DUST_CLOUD_INFO;
        }
        return this.dustCloudInfo;
    }

    public void setArmDustCloudInfo(DustCloudInfo dustCloudInfo, int armIndex) {
        if (armIndex < 0 || armIndex >= this.armDustCloudInfo.length) {
            return;
        }
        this.armDustCloudInfo[armIndex] = dustCloudInfo;
    }

    public DustCloudInfo getArmDustCloudInfo(int armIndex) {
        if (armIndex < 0 || armIndex >= this.armDustCloudInfo.length) {
            return null;
        }
        if (this.armDustCloudInfo[armIndex] == null) {
            return this.getDustCloudInfo();
        }
        return this.armDustCloudInfo[armIndex];
    }

    @Override
    public void setupSpaceObject(ResourceLocation id, @Nullable SpaceObjectRenderer<?> parent) {
        super.setupSpaceObject(id, parent);
        this.setupStarInfo();
        this.setupLOD(this.getStarInfo());
        this.setupDustCloudInfo();
    }

    protected void generateStars(StarData.LOD lod, StarField.LevelOfDetail levelOfDetail, Random random, ArrayList<Constellation.StarDefinition> definedStars) {
        int stars = switch (levelOfDetail) {
            case StarField.LevelOfDetail.LOD1 -> this.lod1stars;
            case StarField.LevelOfDetail.LOD2 -> this.lod2stars;
            default -> this.lod3stars;
        };
        for (Constellation.StarDefinition star : definedStars) {
            lod.newStar(star, this.spaceCoords());
        }
        block9: for (int i = definedStars.size(); i < stars; ++i) {
            double distance = ((StarField)this.renderedObject).clumpStarsInCenter() ? random.nextDouble() : Math.cbrt(Math.abs(random.nextDouble()));
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            Vector3d cartesian = new SphericalCoords(distance * (double)((StarField)this.renderedObject).getDiameter(), theta, phi).toCartesianD();
            cartesian.f_86214_ *= ((StarField)this.renderedObject).starStretch().xStretch();
            cartesian.f_86215_ *= ((StarField)this.renderedObject).starStretch().yStretch();
            cartesian.f_86216_ *= ((StarField)this.renderedObject).starStretch().zStretch();
            ((StarField)this.renderedObject).getAxisRotation().quaterniond().transform(cartesian);
            switch (levelOfDetail) {
                case LOD1: {
                    lod.newStar(this.getStarInfo().randomLOD1StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                    continue block9;
                }
                case LOD2: {
                    lod.newStar(this.getStarInfo().randomLOD2StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                    continue block9;
                }
                default: {
                    lod.newStar(this.getStarInfo().randomLOD3StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                }
            }
        }
    }

    protected void generateArmStars(StarData.LOD lod, StarField.LevelOfDetail levelOfDetail, AxisRotation axisRotation, StarInfo starInfo, Random random, double sizeMultiplier, boolean hasTexture, StarField.SpiralArm arm, int armIndex) {
        int stars = switch (levelOfDetail) {
            case StarField.LevelOfDetail.LOD1 -> this.armLod1stars[armIndex];
            case StarField.LevelOfDetail.LOD2 -> this.armLod2stars[armIndex];
            default -> arm.armStars() - this.armLod1stars[armIndex] - this.armLod2stars[armIndex];
        };
        block8: for (int i = 0; i < stars; ++i) {
            double progress = (double)i / (double)stars;
            double phi = arm.armLength() * Math.PI * progress - arm.armRotation();
            double r = StellarCoordinates.spiralR(5.0, phi, arm.armRotation());
            double distance = arm.clumpStarsInCenter() ? random.nextDouble() : Math.cbrt(random.nextDouble());
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double sphericalphi = Math.acos(2.0 * random.nextDouble() - 1.0);
            Vector3d cartesian = new SphericalCoords(distance * arm.armThickness(), theta, sphericalphi).toCartesianD();
            double x = r * Math.cos(phi) + cartesian.f_86214_ * arm.armThickness() / (progress * 1.5);
            double z = r * Math.sin(phi) + cartesian.f_86216_ * arm.armThickness() / (progress * 1.5);
            double y = cartesian.f_86215_ * arm.armThickness() / (progress * 1.5);
            cartesian.f_86214_ = x * sizeMultiplier;
            cartesian.f_86215_ = y * sizeMultiplier;
            cartesian.f_86216_ = z * sizeMultiplier;
            axisRotation.quaterniond().transform(cartesian);
            switch (levelOfDetail) {
                case LOD1: {
                    lod.newStar(starInfo.randomLOD1StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                    continue block8;
                }
                case LOD2: {
                    lod.newStar(starInfo.randomLOD2StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                    continue block8;
                }
                default: {
                    lod.newStar(starInfo.randomLOD3StarType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_);
                }
            }
        }
    }

    protected void setStars() {
        final double sizeMultiplier = (double)((StarField)this.renderedObject).getDiameter() / 30.0;
        this.starData = new StarData(){

            @Override
            protected StarData.LOD newStars(StarField.LevelOfDetail levelOfDetail) {
                int stars;
                Random random;
                ArrayList<Constellation.StarDefinition> definedStars = switch (levelOfDetail) {
                    case StarField.LevelOfDetail.LOD1 -> {
                        random = new Random(((StarField)StarFieldRenderer.this.renderedObject).getSeed());
                        stars = StarFieldRenderer.this.totalLOD1stars;
                        yield StarFieldRenderer.this.lod1definedStars;
                    }
                    case StarField.LevelOfDetail.LOD2 -> {
                        random = new Random(((StarField)StarFieldRenderer.this.renderedObject).getSeed() + 1L);
                        stars = StarFieldRenderer.this.totalLOD2stars;
                        yield StarFieldRenderer.this.lod2definedStars;
                    }
                    default -> {
                        random = new Random(((StarField)StarFieldRenderer.this.renderedObject).getSeed() + 2L);
                        stars = StarFieldRenderer.this.totalLOD3stars;
                        yield StarFieldRenderer.this.lod3definedStars;
                    }
                };
                StarData.LOD lod = new StarData.LOD(stars);
                StarFieldRenderer.this.generateStars(lod, levelOfDetail, random, definedStars);
                int i = 0;
                for (StarField.SpiralArm arm : ((StarField)StarFieldRenderer.this.renderedObject).getSpiralArms()) {
                    StarFieldRenderer.this.generateArmStars(lod, levelOfDetail, ((StarField)StarFieldRenderer.this.renderedObject).getAxisRotation(), StarFieldRenderer.this.getStarInfo(), random, sizeMultiplier, StarFieldRenderer.this.hasTexture, arm, i);
                    ++i;
                }
                return lod;
            }
        };
    }

    protected void generateDustClouds(DustCloudData.LOD lod, Random random) {
        for (int i = 0; i < ((StarField)this.renderedObject).getDustClouds(); ++i) {
            double distance = ((StarField)this.renderedObject).clumpDustCloudsInCenter() ? random.nextDouble() : Math.cbrt(random.nextDouble());
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            Vector3d cartesian = new SphericalCoords(distance * (double)((StarField)this.renderedObject).getDiameter(), theta, phi).toCartesianD();
            cartesian.f_86214_ *= ((StarField)this.renderedObject).dustCloudStretch().xStretch();
            cartesian.f_86215_ *= ((StarField)this.renderedObject).dustCloudStretch().yStretch();
            cartesian.f_86216_ *= ((StarField)this.renderedObject).dustCloudStretch().zStretch();
            ((StarField)this.renderedObject).getAxisRotation().quaterniond().transform(cartesian);
            lod.newDustCloud(this.getDustCloudInfo().getRandomDustCloudType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_, 1.0);
        }
    }

    protected void generateArmDustClouds(DustCloudData.LOD lod, AxisRotation axisRotation, DustCloudInfo dustCloudInfo, Random random, double sizeMultiplier, StarField.SpiralArm arm, int armIndex) {
        for (int i = 0; i < arm.armDustClouds(); ++i) {
            double progress = (double)i / (double)arm.armDustClouds();
            double phi = arm.armLength() * Math.PI * progress - arm.armRotation();
            double r = StellarCoordinates.spiralR(5.0, phi, arm.armRotation());
            progress += 1.0;
            double distance = arm.clumpDustCloudsInCenter() ? random.nextDouble() : Math.cbrt(random.nextDouble());
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double sphericalphi = Math.acos(2.0 * random.nextDouble() - 1.0);
            Vector3d cartesian = new SphericalCoords(distance * arm.armThickness(), theta, sphericalphi).toCartesianD();
            double x = r * Math.cos(phi);
            double z = r * Math.sin(phi);
            double y = 0.0;
            cartesian.f_86214_ = x * sizeMultiplier;
            cartesian.f_86215_ = y * sizeMultiplier;
            cartesian.f_86216_ = z * sizeMultiplier;
            axisRotation.quaterniond().transform(cartesian);
            lod.newDustCloud(this.getArmDustCloudInfo(armIndex) == null ? dustCloudInfo.getRandomDustCloudType(random) : this.getArmDustCloudInfo(armIndex).getRandomDustCloudType(random), random, cartesian.f_86214_, cartesian.f_86215_, cartesian.f_86216_, 1.0 / progress + 0.2);
        }
    }

    protected void setDustClouds() {
        final double sizeMultiplier = (double)((StarField)this.renderedObject).getDiameter() / 30.0;
        this.dustCloudData = new DustCloudData(){

            @Override
            protected DustCloudData.LOD newDustClouds() {
                Random random = new Random(((StarField)StarFieldRenderer.this.renderedObject).getSeed());
                DustCloudData.LOD lod = new DustCloudData.LOD(StarFieldRenderer.this.totalDustClouds);
                StarFieldRenderer.this.generateDustClouds(lod, random);
                for (int i = 0; i < ((StarField)StarFieldRenderer.this.renderedObject).getSpiralArms().size(); ++i) {
                    StarFieldRenderer.this.generateArmDustClouds(lod, ((StarField)StarFieldRenderer.this.renderedObject).getAxisRotation(), StarFieldRenderer.this.getDustCloudInfo(), random, sizeMultiplier, ((StarField)StarFieldRenderer.this.renderedObject).getSpiralArm(i), i);
                }
                return lod;
            }
        };
    }

    @Override
    public void render(ViewCenter viewCenter, ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, BufferBuilder bufferbuilder, Vector3f parentVector, AxisRotation parentRotation) {
        SpaceCoords difference = viewCenter.getCoords().sub(this.spaceCoords());
        if (this.starData == null) {
            this.setStars();
        } else if (this.requiresReset()) {
            this.hasTexture = GeneralConfig.textured_stars.get();
            this.starData.reset();
        }
        if (!GeneralConfig.disable_stars.get() && viewCenter.starBrightness() > 0.0f) {
            stack.m_85836_();
            if (this.hasTexture) {
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)viewCenter.starBrightness());
            if (this.hasTexture) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)((StarField)this.renderedObject()).getStarTexture());
            }
            FogRenderer.m_109017_();
            Quaternion q = SpaceCoords.getQuaternionf(level, viewCenter, partialTicks);
            stack.m_85845_(q);
            this.starData.renderStars(StarField.LevelOfDetail.fromDistance(difference), stack.m_85850_().m_85861_(), projectionMatrix, difference, viewCenter.isStatic(), this.hasTexture);
            setupFog.run();
            stack.m_85849_();
        }
        for (SpaceObjectRenderer child : this.children) {
            child.render(viewCenter, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder, parentVector, new AxisRotation(0.0, 0.0, 0.0));
        }
    }

    public void renderDustClouds(ViewCenter viewCenter, ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog, float brightness) {
        SpaceCoords difference = viewCenter.getCoords().sub(this.spaceCoords());
        if (StarField.LevelOfDetail.fromDistance(difference) == StarField.LevelOfDetail.LOD1) {
            return;
        }
        if (this.dustCloudData == null) {
            this.setDustClouds();
        } else if (this.requiresReset()) {
            this.dustCloudData.reset();
        }
        if (brightness > 0.0f) {
            stack.m_85836_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            RenderSystem.m_157456_((int)0, (ResourceLocation)((StarField)this.renderedObject).getDustCloudTexture());
            FogRenderer.m_109017_();
            Quaternion q = SpaceCoords.getQuaternionf(level, viewCenter, partialTicks);
            stack.m_85845_(q);
            this.dustCloudData.renderDustClouds(stack.m_85850_().m_85861_(), projectionMatrix, difference, viewCenter.isStatic());
            setupFog.run();
            stack.m_85849_();
        }
    }
}

