/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quaternion;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.stellarview.common.util.Quaterniond;

public class AxisRotation
implements INBTSerializable<CompoundTag> {
    public static final String X_AXIS = "x_axis";
    public static final String Y_AXIS = "y_axis";
    public static final String Z_AXIS = "z_axis";
    private boolean inDegrees;
    private double xAxis;
    private double yAxis;
    private double zAxis;
    private Quaterniond quaterniond;
    private Quaternion quaternionf;
    public static final Codec<AxisRotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("in_degrees", (Object)true).forGetter(axisRotation -> axisRotation.inDegrees), (App)Codec.DOUBLE.fieldOf(X_AXIS).forGetter(AxisRotation::xAxis), (App)Codec.DOUBLE.fieldOf(Y_AXIS).forGetter(AxisRotation::yAxis), (App)Codec.DOUBLE.fieldOf(Z_AXIS).forGetter(AxisRotation::zAxis)).apply((Applicative)instance, AxisRotation::new));

    public AxisRotation(boolean inDegrees, double xAxis, double yAxis, double zAxis) {
        this.inDegrees = inDegrees;
        if (inDegrees) {
            this.xAxis = Math.toRadians(xAxis);
            this.yAxis = Math.toRadians(yAxis);
            this.zAxis = Math.toRadians(zAxis);
        } else {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }
        this.setupQuaternions();
    }

    private void setupQuaternions() {
        Quaternion quaternionfZ;
        Quaterniond quaterniondX = new Quaterniond().rotationX(this.xAxis);
        Quaterniond quaterniondY = new Quaterniond().rotationY(this.yAxis);
        Quaterniond quaterniondZ = new Quaterniond().rotationZ(this.zAxis);
        this.quaterniond = quaterniondX.mul(quaterniondZ.mul(quaterniondY));
        Quaternion quaternionfX = AxisRotation.rotationX(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), (float)this.xAxis);
        Quaternion quaternionfY = AxisRotation.rotationY(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), (float)this.yAxis);
        Quaternion quatf = quaternionfZ = AxisRotation.rotationZ(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), (float)this.zAxis);
        quatf.m_80148_(quaternionfY);
        quaternionfX.m_80148_(quatf);
        this.quaternionf = quaternionfX;
    }

    public static AxisRotation fromTag(CompoundTag tag) {
        return new AxisRotation(false, tag.m_128459_(X_AXIS), tag.m_128459_(Y_AXIS), tag.m_128459_(Z_AXIS));
    }

    public AxisRotation(double xAxis, double yAxis, double zAxis) {
        this(true, xAxis, yAxis, zAxis);
    }

    public AxisRotation() {
        this(false, 0.0, 0.0, 0.0);
    }

    public double xAxis() {
        return this.xAxis;
    }

    public double yAxis() {
        return this.yAxis;
    }

    public double zAxis() {
        return this.zAxis;
    }

    public Quaternion quaternionf() {
        return this.quaternionf;
    }

    public Quaterniond quaterniond() {
        return this.quaterniond;
    }

    public AxisRotation add(AxisRotation other) {
        return new AxisRotation(false, this.xAxis + other.xAxis, this.yAxis + other.yAxis, this.zAxis + other.zAxis);
    }

    public AxisRotation add(double xRot, double yRot, double zRot) {
        return new AxisRotation(false, this.xAxis + xRot, this.yAxis + yRot, this.zAxis + zRot);
    }

    public AxisRotation sub(AxisRotation other) {
        return new AxisRotation(false, this.xAxis - other.xAxis, this.yAxis - other.yAxis, this.zAxis - other.zAxis);
    }

    public AxisRotation copy() {
        return new AxisRotation(false, this.xAxis, this.yAxis, this.zAxis);
    }

    public String toString() {
        return "( xAxis: " + Math.toDegrees(this.xAxis) + "\u00b0, yAxis: " + Math.toDegrees(this.yAxis) + "\u00b0, zAxis: " + Math.toDegrees(this.zAxis) + "\u00b0 )";
    }

    private static Quaternion rotationX(Quaternion quaternion, double angle) {
        float sin = (float)Math.sin(angle * 0.5);
        float cos = (float)Quaterniond.cosFromSin(sin, angle * 0.5);
        quaternion.m_80143_(sin, quaternion.m_80150_(), quaternion.m_80153_(), cos);
        return quaternion;
    }

    private static Quaternion rotationY(Quaternion quaternion, double angle) {
        float sin = (float)Math.sin(angle * 0.5);
        float cos = (float)Quaterniond.cosFromSin(sin, angle * 0.5);
        quaternion.m_80143_(quaternion.m_80140_(), sin, quaternion.m_80153_(), cos);
        return quaternion;
    }

    private static Quaternion rotationZ(Quaternion quaternion, double angle) {
        float sin = (float)Math.sin(angle * 0.5);
        float cos = (float)Quaterniond.cosFromSin(sin, angle * 0.5);
        quaternion.m_80143_(quaternion.m_80140_(), quaternion.m_80150_(), sin, cos);
        return quaternion;
    }

    public static Quaternion invertQuaternion(Quaternion quaternion, Quaternion destination) {
        float normalized = 1.0f / AxisRotation.lengthSquared(quaternion);
        float x = quaternion.m_80140_();
        float y = quaternion.m_80150_();
        float z = quaternion.m_80153_();
        float w = quaternion.m_80156_();
        destination.m_80143_(-x * normalized, -y * normalized, -z * normalized, w * normalized);
        return destination;
    }

    private static float lengthSquared(Quaternion quaternion) {
        return Math.fma(quaternion.m_80140_(), quaternion.m_80140_(), Math.fma(quaternion.m_80150_(), quaternion.m_80150_(), Math.fma(quaternion.m_80153_(), quaternion.m_80153_(), quaternion.m_80156_() * quaternion.m_80156_())));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(X_AXIS, this.xAxis);
        tag.m_128347_(Y_AXIS, this.yAxis);
        tag.m_128347_(Z_AXIS, this.zAxis);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.inDegrees = false;
        this.xAxis = tag.m_128459_(X_AXIS);
        this.yAxis = tag.m_128459_(Y_AXIS);
        this.zAxis = tag.m_128459_(Z_AXIS);
        this.setupQuaternions();
    }
}

