/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Mat4f {
    private static final NumberFormat FORMAT = new DecimalFormat("0.###E0");
    float m00 = 1.0f;
    float m01;
    float m02;
    float m03;
    float m10;
    float m11 = 1.0f;
    float m12;
    float m13;
    float m20;
    float m21;
    float m22 = 1.0f;
    float m23;
    float m30;
    float m31;
    float m32;
    float m33 = 1.0f;

    public Mat4f scale(float x, float y, float z) {
        this.m00 *= x;
        this.m01 *= x;
        this.m02 *= x;
        this.m03 *= x;
        this.m10 *= y;
        this.m11 *= y;
        this.m12 *= y;
        this.m13 *= y;
        this.m20 *= z;
        this.m21 *= z;
        this.m22 *= z;
        this.m23 *= z;
        return this;
    }

    public Mat4f translate(Vector3f vec) {
        float m30 = this.m30;
        float m31 = this.m31;
        float m32 = this.m32;
        float m33 = this.m33;
        this.m30 = Math.fma(this.m00, vec.m_122239_(), Math.fma(this.m10, vec.m_122260_(), Math.fma(this.m20, vec.m_122269_(), m30)));
        this.m31 = Math.fma(this.m01, vec.m_122239_(), Math.fma(this.m11, vec.m_122260_(), Math.fma(this.m21, vec.m_122269_(), m31)));
        this.m32 = Math.fma(this.m02, vec.m_122239_(), Math.fma(this.m12, vec.m_122260_(), Math.fma(this.m22, vec.m_122269_(), m32)));
        this.m33 = Math.fma(this.m03, vec.m_122239_(), Math.fma(this.m13, vec.m_122260_(), Math.fma(this.m23, vec.m_122269_(), m33)));
        return this;
    }

    public Mat4f rotate(Quaternion quat) {
        float m00 = this.m00;
        float m01 = this.m01;
        float m02 = this.m02;
        float m03 = this.m03;
        float m10 = this.m10;
        float m11 = this.m11;
        float m12 = this.m12;
        float m13 = this.m13;
        float m20 = this.m20;
        float m21 = this.m21;
        float m22 = this.m22;
        float m23 = this.m23;
        float w2 = quat.m_80156_() * quat.m_80156_();
        float x2 = quat.m_80140_() * quat.m_80140_();
        float y2 = quat.m_80150_() * quat.m_80150_();
        float z2 = quat.m_80153_() * quat.m_80153_();
        float zw = quat.m_80153_() * quat.m_80156_();
        float dzw = zw + zw;
        float xy = quat.m_80140_() * quat.m_80150_();
        float dxy = xy + xy;
        float xz = quat.m_80140_() * quat.m_80153_();
        float dxz = xz + xz;
        float yw = quat.m_80150_() * quat.m_80156_();
        float dyw = yw + yw;
        float yz = quat.m_80150_() * quat.m_80153_();
        float dyz = yz + yz;
        float xw = quat.m_80140_() * quat.m_80156_();
        float dxw = xw + xw;
        float rm00 = w2 + x2 - z2 - y2;
        float rm01 = dxy + dzw;
        float rm02 = dxz - dyw;
        float rm10 = -dzw + dxy;
        float rm11 = y2 - z2 + w2 - x2;
        float rm12 = dyz + dxw;
        float rm20 = dyw + dxz;
        float rm21 = dyz - dxw;
        float rm22 = z2 - y2 - x2 + w2;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m03 = nm03;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m13 = nm13;
        this.m20 = m00 * rm20 + m10 * rm21 + m20 * rm22;
        this.m21 = m01 * rm20 + m11 * rm21 + m21 * rm22;
        this.m22 = m02 * rm20 + m12 * rm21 + m22 * rm22;
        this.m23 = m03 * rm20 + m13 * rm21 + m23 * rm22;
        return this;
    }

    public Mat4f mul(Mat4f right) {
        float nm00 = Math.fma(this.m00, right.m00, Math.fma(this.m10, right.m01, Math.fma(this.m20, right.m02, this.m30 * right.m03)));
        float nm01 = Math.fma(this.m01, right.m00, Math.fma(this.m11, right.m01, Math.fma(this.m21, right.m02, this.m31 * right.m03)));
        float nm02 = Math.fma(this.m02, right.m00, Math.fma(this.m12, right.m01, Math.fma(this.m22, right.m02, this.m32 * right.m03)));
        float nm03 = Math.fma(this.m03, right.m00, Math.fma(this.m13, right.m01, Math.fma(this.m23, right.m02, this.m33 * right.m03)));
        float nm10 = Math.fma(this.m00, right.m10, Math.fma(this.m10, right.m11, Math.fma(this.m20, right.m12, this.m30 * right.m13)));
        float nm11 = Math.fma(this.m01, right.m10, Math.fma(this.m11, right.m11, Math.fma(this.m21, right.m12, this.m31 * right.m13)));
        float nm12 = Math.fma(this.m02, right.m10, Math.fma(this.m12, right.m11, Math.fma(this.m22, right.m12, this.m32 * right.m13)));
        float nm13 = Math.fma(this.m03, right.m10, Math.fma(this.m13, right.m11, Math.fma(this.m23, right.m12, this.m33 * right.m13)));
        float nm20 = Math.fma(this.m00, right.m20, Math.fma(this.m10, right.m21, Math.fma(this.m20, right.m22, this.m30 * right.m23)));
        float nm21 = Math.fma(this.m01, right.m20, Math.fma(this.m11, right.m21, Math.fma(this.m21, right.m22, this.m31 * right.m23)));
        float nm22 = Math.fma(this.m02, right.m20, Math.fma(this.m12, right.m21, Math.fma(this.m22, right.m22, this.m32 * right.m23)));
        float nm23 = Math.fma(this.m03, right.m20, Math.fma(this.m13, right.m21, Math.fma(this.m23, right.m22, this.m33 * right.m23)));
        float nm30 = Math.fma(this.m00, right.m30, Math.fma(this.m10, right.m31, Math.fma(this.m20, right.m32, this.m30 * right.m33)));
        float nm31 = Math.fma(this.m01, right.m30, Math.fma(this.m11, right.m31, Math.fma(this.m21, right.m32, this.m31 * right.m33)));
        float nm32 = Math.fma(this.m02, right.m30, Math.fma(this.m12, right.m31, Math.fma(this.m22, right.m32, this.m32 * right.m33)));
        float nm33 = Math.fma(this.m03, right.m30, Math.fma(this.m13, right.m31, Math.fma(this.m23, right.m32, this.m33 * right.m33)));
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m03 = nm03;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m13 = nm13;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m22 = nm22;
        this.m23 = nm23;
        this.m30 = nm30;
        this.m31 = nm31;
        this.m32 = nm32;
        this.m33 = nm33;
        return this;
    }

    public Vector3f mulProject(Vector3f vec) {
        float x = vec.m_122239_();
        float y = vec.m_122260_();
        float z = vec.m_122269_();
        float invW = 1.0f / Math.fma(this.m03, x, Math.fma(this.m13, y, Math.fma(this.m23, z, this.m33)));
        vec.m_122245_(Math.fma(this.m00, x, Math.fma(this.m10, y, Math.fma(this.m20, z, this.m30))) * invW, Math.fma(this.m01, x, Math.fma(this.m11, y, Math.fma(this.m21, z, this.m31))) * invW, Math.fma(this.m02, x, Math.fma(this.m12, y, Math.fma(this.m22, z, this.m32))) * invW);
        return vec;
    }

    public Matrix4f toMatrix4f() {
        float[] values = new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
        return new Matrix4f(values);
    }

    public String toString() {
        return FORMAT.format(this.m00) + " " + FORMAT.format(this.m10) + " " + FORMAT.format(this.m20) + " " + FORMAT.format(this.m30) + "\n" + FORMAT.format(this.m01) + " " + FORMAT.format(this.m11) + " " + FORMAT.format(this.m21) + " " + FORMAT.format(this.m31) + "\n" + FORMAT.format(this.m02) + " " + FORMAT.format(this.m12) + " " + FORMAT.format(this.m22) + " " + FORMAT.format(this.m32) + "\n" + FORMAT.format(this.m03) + " " + FORMAT.format(this.m13) + " " + FORMAT.format(this.m23) + " " + FORMAT.format(this.m33) + "\n";
    }
}

