/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;

public class Quaterniond {
    private static final double PI_HALF = 1.5707963267948966;
    private static final double PI_2 = Math.PI * 2;
    public double x;
    public double y;
    public double z;
    public double w = 1.0;

    public Quaterniond rotationX(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        this.x = sin;
        this.w = cos;
        return this;
    }

    public Quaterniond rotationY(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        this.y = sin;
        this.w = cos;
        return this;
    }

    public Quaterniond rotationZ(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        this.z = sin;
        this.w = cos;
        return this;
    }

    public Vector3d transform(Vector3d vec) {
        double xx = this.x * this.x;
        double yy = this.y * this.y;
        double zz = this.z * this.z;
        double ww = this.w * this.w;
        double xy = this.x * this.y;
        double xz = this.x * this.z;
        double yz = this.y * this.z;
        double xw = this.x * this.w;
        double zw = this.z * this.w;
        double yw = this.y * this.w;
        double k = 1.0 / (xx + yy + zz + ww);
        double x = vec.f_86214_;
        double y = vec.f_86215_;
        double z = vec.f_86216_;
        vec.f_86214_ = Math.fma((xx - yy - zz + ww) * k, x, Math.fma(2.0 * (xy - zw) * k, y, 2.0 * (xz + yw) * k * z));
        vec.f_86215_ = Math.fma(2.0 * (xy + zw) * k, x, Math.fma((yy - xx - zz + ww) * k, y, 2.0 * (yz - xw) * k * z));
        vec.f_86216_ = Math.fma(2.0 * (xz - yw) * k, x, Math.fma(2.0 * (yz + xw) * k, y, (zz - xx - yy + ww) * k * z));
        return vec;
    }

    public Vector3f transform(Vector3f vec) {
        double xx = this.x * this.x;
        double yy = this.y * this.y;
        double zz = this.z * this.z;
        double ww = this.w * this.w;
        double xy = this.x * this.y;
        double xz = this.x * this.z;
        double yz = this.y * this.z;
        double xw = this.x * this.w;
        double zw = this.z * this.w;
        double yw = this.y * this.w;
        double k = 1.0 / (xx + yy + zz + ww);
        double x = vec.m_122239_();
        double y = vec.m_122260_();
        double z = vec.m_122269_();
        vec.setX((float)Math.fma((xx - yy - zz + ww) * k, x, Math.fma(2.0 * (xy - zw) * k, y, 2.0 * (xz + yw) * k * z)));
        vec.setY((float)Math.fma(2.0 * (xy + zw) * k, x, Math.fma((yy - xx - zz + ww) * k, y, 2.0 * (yz - xw) * k * z)));
        vec.setZ((float)Math.fma(2.0 * (xz - yw) * k, x, Math.fma(2.0 * (yz + xw) * k, y, (zz - xx - yy + ww) * k * z)));
        return vec;
    }

    public Quaterniond rotateX(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = w * sin + x * cos;
        this.y = y * cos + z * sin;
        this.z = z * cos - y * sin;
        this.w = w * cos - x * sin;
        return this;
    }

    public Quaterniond rotateY(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = x * cos - z * sin;
        this.y = w * sin + y * cos;
        this.z = x * sin + z * cos;
        this.w = w * cos - y * sin;
        return this;
    }

    public Quaterniond rotateZ(double angle) {
        double sin = Math.sin(angle * 0.5);
        double cos = Quaterniond.cosFromSin(sin, angle * 0.5);
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = x * cos + y * sin;
        this.y = y * cos - x * sin;
        this.z = w * sin + z * cos;
        this.w = w * cos - z * sin;
        return this;
    }

    public Quaterniond mul(Quaterniond other) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = Math.fma(w, other.x, Math.fma(x, other.w, Math.fma(y, other.z, -z * other.y)));
        this.y = Math.fma(w, other.y, Math.fma(-x, other.z, Math.fma(y, other.w, z * other.x)));
        this.z = Math.fma(w, other.z, Math.fma(x, other.y, Math.fma(-y, other.x, z * other.w)));
        this.w = Math.fma(w, other.w, Math.fma(-x, other.x, Math.fma(-y, other.y, -z * other.z)));
        return this;
    }

    public Quaterniond invert(Quaterniond destination) {
        double normalized = 1.0 / this.lengthSquared();
        destination.x = -this.x * normalized;
        destination.y = -this.y * normalized;
        destination.z = -this.z * normalized;
        destination.w = this.w * normalized;
        return destination;
    }

    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static double cosFromSin(double sin, double angle) {
        double cos = Math.sqrt(1.0 - sin * sin);
        double a = angle + 1.5707963267948966;
        double b = a - (double)((int)(a / (Math.PI * 2))) * (Math.PI * 2);
        if (b < 0.0) {
            b = Math.PI * 2 + b;
        }
        if (b >= Math.PI) {
            return -cos;
        }
        return cos;
    }
}

