/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.compatibility.enhancedcelestials;

import com.mojang.math.Vector3f;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.api.client.ColorSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.client.ECWorldRenderer;
import corgitaco.enhancedcelestials.core.EnhancedCelestialsContext;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.DimensionType;
import net.povstalec.stellarview.client.render.level.util.StellarViewLightmapEffects;
import net.povstalec.stellarview.common.util.Color;

public class EnhancedCelestialsCompatibility {
    public static final float getMoonSize(ClientLevel level, float defaultSize) {
        return ECWorldRenderer.getMoonSize((float)defaultSize);
    }

    public static final Color.FloatRGBA getMoonColor(ClientLevel level, float partialTicks) {
        EnhancedCelestialsContext enhancedCelestialsContext;
        EnhancedCelestialsWorldData enhancedCelestialsWorldData = (EnhancedCelestialsWorldData)level;
        if (enhancedCelestialsWorldData != null && (enhancedCelestialsContext = enhancedCelestialsWorldData.getLunarContext()) != null) {
            LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
            ColorSettings lastColorSettings = ((LunarEvent)lunarForecast.getMostRecentEvent().m_203334_()).getClientSettings().colorSettings();
            ColorSettings currentColorSettings = ((LunarEvent)lunarForecast.getCurrentEvent(level.m_46722_(1.0f) < 1.0f).m_203334_()).getClientSettings().colorSettings();
            Vector3f lastGLColor = lastColorSettings.getGLMoonColor();
            Vector3f currentGLColor = currentColorSettings.getGLMoonColor();
            float blend = lunarForecast.getBlend();
            float r = Mth.m_144920_((float)lastGLColor.m_122239_(), (float)currentGLColor.m_122239_(), (float)blend);
            float g = Mth.m_144920_((float)lastGLColor.m_122260_(), (float)currentGLColor.m_122260_(), (float)blend);
            float b = Mth.m_144920_((float)lastGLColor.m_122269_(), (float)currentGLColor.m_122269_(), (float)blend);
            return new Color.FloatRGBA(r > 1.0f ? 1.0f : r, g > 1.0f ? 1.0f : g, b > 1.0f ? 1.0f : b);
        }
        return new Color.FloatRGBA(1, 1, 1);
    }

    public static final void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        float darkMultiplier = StellarViewLightmapEffects.getSkyDarken(level, 1.0f);
        boolean darkerWorld = true;
        if (darkerWorld) {
            EnhancedCelestialsContext enhancedCelestialsContext;
            float trueSkyDarken = level.m_104819_() > 0 ? 1.0f : darkMultiplier * 0.95f + 0.05f;
            Vector3f skyVector = new Vector3f(trueSkyDarken, trueSkyDarken, 1.0f);
            skyVector.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            EnhancedCelestialsWorldData enhancedCelestialsWorldData = (EnhancedCelestialsWorldData)level;
            if (enhancedCelestialsWorldData != null && (enhancedCelestialsContext = enhancedCelestialsWorldData.getLunarContext()) != null) {
                LunarForecast lunarForecast = enhancedCelestialsContext.getLunarForecast();
                LunarEvent lastEvent = (LunarEvent)lunarForecast.getMostRecentEvent().m_203334_();
                LunarEvent currentEvent = (LunarEvent)lunarForecast.getCurrentEvent(level.m_46722_(1.0f) < 1.0f).m_203334_();
                ColorSettings colorSettings = currentEvent.getClientSettings().colorSettings();
                ColorSettings lastColorSettings = lastEvent.getClientSettings().colorSettings();
                Vector3f glSkyLightColor = lastColorSettings.getGLSkyLightColor();
                Vector3f targetColor = new Vector3f(glSkyLightColor.m_122239_(), glSkyLightColor.m_122260_(), glSkyLightColor.m_122269_());
                skyDarken = (level.m_104805_(1.0f) - 0.2f) / 0.8f;
                float eventBlend = lunarForecast.getBlend() - skyDarken;
                targetColor.m_122255_(colorSettings.getGLSkyLightColor(), eventBlend);
                float skyBlend = 1.0f - skyDarken - level.m_46722_(partialTicks);
                skyVector.m_122255_(targetColor, skyBlend);
            }
            Vector3f lightColor = new Vector3f();
            float naturalLight = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelY) * trueSkyDarken;
            float artificialLight = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelX) * skyLight;
            float f10 = artificialLight * ((artificialLight * 0.6f + 0.4f) * 0.6f + 0.4f);
            float f11 = artificialLight * (artificialLight * artificialLight * 0.6f + 0.4f);
            lightColor.m_122245_(artificialLight, f10, f11);
            if (level.m_104583_().m_108884_()) {
                lightColor.m_122255_(new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                StellarViewLightmapEffects.clampColor(lightColor);
            } else {
                Minecraft minecraft = Minecraft.m_91087_();
                Vector3f vector3f2 = new Vector3f(skyVector.m_122239_(), skyVector.m_122260_(), skyVector.m_122269_());
                vector3f2.m_122261_(naturalLight);
                lightColor.m_122253_(vector3f2);
                lightColor.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (minecraft.f_91063_.m_109131_(partialTicks) > 0.0f) {
                    float f12 = minecraft.f_91063_.m_109131_(partialTicks);
                    Vector3f vector3f3 = new Vector3f(lightColor.m_122239_(), lightColor.m_122260_(), lightColor.m_122269_());
                    vector3f3.m_122263_(0.7f, 0.6f, 0.6f);
                    lightColor.m_122255_(vector3f3, f12);
                }
            }
            float[] set = new float[]{lightColor.m_122239_(), lightColor.m_122260_(), lightColor.m_122269_()};
            colors.set(set);
        }
    }
}

