/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.happy_ghasts_boost.mixin;

import common.com.cursee.happy_ghasts_boost.api.common.entity.IHappyGhastBoostDataHolder;
import common.com.cursee.happy_ghasts_boost.impl.common.config.EarlyLoadConfig;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HappyGhast.class})
public class HappyGhastMixin
implements IHappyGhastBoostDataHolder {
    @Unique
    private boolean happy_ghasts_boost$boosted = false;
    @Unique
    private int happy_ghasts_boost$forwardFlightDuration = 0;
    @Unique
    private float happy_ghasts_boost$oldYDegrees = 0.0f;

    @Unique
    private static boolean happy_ghasts_boost$withinFivePercentMargin(double a, double b) {
        double c = Math.abs(a - b) / a;
        return c <= 0.05;
    }

    @Unique
    private static boolean happy_ghasts_boost$checkThreshold(double xDelta, double zDelta) {
        float checkedValue = Mth.sqrt((float)((float)Mth.square((double)xDelta))) + Mth.sqrt((float)((float)Mth.square((double)zDelta)));
        return (double)checkedValue > 0.1;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void happy_ghasts_boost$tick(CallbackInfo ci) {
        HappyGhast ghast = (HappyGhast)this;
        if (ghast.getControllingPassenger() == null) {
            return;
        }
        Vec3 movement = ghast.getDeltaMovement();
        Vec3 forward = ghast.getForward();
        Vec3 movementNormal = movement.normalize();
        Vec3 forwardNormal = forward.normalize();
        boolean movingForward = HappyGhastMixin.happy_ghasts_boost$withinFivePercentMargin(movementNormal.x, forwardNormal.x) && HappyGhastMixin.happy_ghasts_boost$withinFivePercentMargin(movementNormal.z, forwardNormal.z);
        boolean velocityCheck = HappyGhastMixin.happy_ghasts_boost$checkThreshold(movement.x, movement.z);
        if (movingForward && velocityCheck) {
            boolean readyToBoost;
            boolean turnedTooFar;
            float currentYDegrees = ghast.getVisualRotationYInDegrees();
            boolean bl = turnedTooFar = !HappyGhastMixin.happy_ghasts_boost$withinFivePercentMargin(currentYDegrees, this.happy_ghasts_boost$oldYDegrees);
            if (turnedTooFar) {
                this.happy_ghasts_boost$resetTrackedValues();
            }
            boolean bl2 = readyToBoost = this.happy_ghasts_boost$forwardFlightDuration / 20 >= EarlyLoadConfig.secondsUntilBoost;
            if (readyToBoost) {
                this.happy_ghasts_boost$boosted = true;
            }
            ++this.happy_ghasts_boost$forwardFlightDuration;
        } else if (!movingForward || !velocityCheck) {
            this.happy_ghasts_boost$resetTrackedValues();
        }
        this.happy_ghasts_boost$oldYDegrees = ghast.getVisualRotationYInDegrees();
    }

    @Unique
    private void happy_ghasts_boost$resetTrackedValues() {
        this.happy_ghasts_boost$forwardFlightDuration = 0;
        this.happy_ghasts_boost$boosted = false;
    }

    @Override
    public boolean happy_ghasts_boost$isBoosted() {
        return this.happy_ghasts_boost$boosted;
    }

    @Override
    public int happy_ghasts_boost$getForwardFlightDuration() {
        return this.happy_ghasts_boost$forwardFlightDuration;
    }
}

