/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.happy_ghasts_boost.mixin;

import neoforge.com.cursee.happy_ghasts_boost.api.common.entity.IHappyGhastBoostDataHolder;
import neoforge.com.cursee.happy_ghasts_boost.impl.common.config.EarlyLoadConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"getAttributeValue"}, cancellable=true)
    private void happy_ghasts_boost$getAttributeValue(Holder<Attribute> attribute, CallbackInfoReturnable<Double> cir) {
        HappyGhast ghast;
        block11: {
            block10: {
                LivingEntity living = (LivingEntity)this;
                if (!(living instanceof HappyGhast)) break block10;
                ghast = (HappyGhast)living;
                if (attribute.equals((Object)Attributes.FLYING_SPEED)) break block11;
            }
            return;
        }
        IHappyGhastBoostDataHolder dataHolder = (IHappyGhastBoostDataHolder)ghast;
        MobEffectInstance effect = ghast.getEffect(MobEffects.SPEED);
        boolean boosted = dataHolder.happy_ghasts_boost$isBoosted();
        if (dataHolder.happy_ghasts_boost$getForwardFlightDuration() > 0 || effect != null) {
            if (boosted) {
                Vec3 pos = ghast.position();
                ghast.level().addParticle((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y, pos.z, 0.1, 0.1, 0.1);
            }
            if (effect == null) {
                double percentage = Math.min(1.0, (double)dataHolder.happy_ghasts_boost$getForwardFlightDuration() / ((double)EarlyLoadConfig.secondsUntilBoost * 20.0));
                double calculated = 0.05 * (double)EarlyLoadConfig.forwardMultiplier * percentage;
                cir.setReturnValue((Object)Math.max(0.05, calculated));
            } else {
                float potionForwardMod;
                float f = potionForwardMod = boosted ? 0.025f : 0.0f;
                if (effect.getAmplifier() == 0) {
                    cir.setReturnValue((Object)(0.05 * (double)EarlyLoadConfig.potionMultiplier + (double)potionForwardMod));
                } else if (effect.getAmplifier() == 1) {
                    cir.setReturnValue((Object)(0.05 * (double)EarlyLoadConfig.potionMultiplierTwo + (double)potionForwardMod));
                }
            }
        }
    }
}

