/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius;

import com.mojang.logging.LogUtils;
import net.felisgamerus.regius.Config;
import net.felisgamerus.regius.block.ModBlocks;
import net.felisgamerus.regius.entity.ModEntities;
import net.felisgamerus.regius.entity.client.BallPythonRenderer;
import net.felisgamerus.regius.item.ModCreativeModeTabs;
import net.felisgamerus.regius.item.ModItems;
import net.felisgamerus.regius.util.ModItemProperties;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="regius")
public class Regius {
    public static final String MOD_ID = "regius";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Regius(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SPHAGNUM_MOSS.get()), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DRIED_SPHAGNUM_MOSS.get()), (RenderType)RenderType.cutoutMipped());
        Regius.registerCompostables();
    }

    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SPHAGNUM_MOSS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.DRIED_SPHAGNUM_MOSS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SPHAGNUM_MOSS_BLOCK.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.DRIED_SPHAGNUM_MOSS_BLOCK.get()), 0.85f);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="regius", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.addCustomItemProperties();
            EntityRenderers.register(ModEntities.BALL_PYTHON.get(), BallPythonRenderer::new);
        }
    }
}

