/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class DriedSphagnumBase
extends Block {
    private final BlockState lushPlant;

    public DriedSphagnumBase(Block lushPlant, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.lushPlant = lushPlant.defaultBlockState();
    }

    public void onLand(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        if (DriedSphagnumBase.shouldSolidify((BlockGetter)pLevel, pPos, pState, pReplaceableState.getFluidState())) {
            pLevel.setBlock(pPos, this.lushPlant, 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate;
        BlockPos blockpos;
        Level blockgetter = pContext.getLevel();
        return DriedSphagnumBase.shouldSolidify((BlockGetter)blockgetter, blockpos = pContext.getClickedPos(), blockstate = blockgetter.getBlockState(blockpos)) ? this.lushPlant : super.getStateForPlacement(pContext);
    }

    private static boolean shouldSolidify(BlockGetter pLevel, BlockPos pPos, BlockState pState, FluidState fluidState) {
        return pState.canBeHydrated(pLevel, pPos, fluidState, pPos) || DriedSphagnumBase.touchesLiquid(pLevel, pPos, pState);
    }

    private static boolean shouldSolidify(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return DriedSphagnumBase.shouldSolidify(pLevel, pPos, pState, pLevel.getFluidState(pPos));
    }

    private static boolean touchesLiquid(BlockGetter pLevel, BlockPos pPos, BlockState state) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = pLevel.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(pLevel, pPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, direction);
            blockstate = pLevel.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!state.canBeHydrated(pLevel, pPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos) || blockstate.isFaceSturdy(pLevel, pPos, direction.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState pState) {
        return pState.getFluidState().is(FluidTags.WATER);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return DriedSphagnumBase.touchesLiquid((BlockGetter)pLevel, pCurrentPos, pState) ? this.lushPlant : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }
}

