/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class HollowLog
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    private Block strippedLog;
    private boolean isStripped = true;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape OUTSIDE = Shapes.block();
    private static final VoxelShape X_INSIDE = HollowLog.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape Z_INSIDE = HollowLog.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape Y_INSIDE = HollowLog.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape X_AXIS = Shapes.join((VoxelShape)OUTSIDE, (VoxelShape)X_INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape Z_AXIS = Shapes.join((VoxelShape)OUTSIDE, (VoxelShape)Z_INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape Y_AXIS = Shapes.join((VoxelShape)OUTSIDE, (VoxelShape)Y_INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);

    public HollowLog(BlockBehaviour.Properties properties, Boolean pIsStripped, Block pStrippedLog) {
        super(properties);
        this.strippedLog = pStrippedLog;
        this.isStripped = pIsStripped;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
    }

    public VoxelShape getShape(BlockState p_51470_, BlockGetter p_51471_, BlockPos p_51472_, CollisionContext p_51473_) {
        switch ((Direction.Axis)p_51470_.getValue((Property)AXIS)) {
            default: {
                return X_AXIS;
            }
            case Z: {
                return Z_AXIS;
            }
            case Y: 
        }
        return Y_AXIS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_51454_) {
        FluidState fluidstate = p_51454_.getLevel().getFluidState(p_51454_.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(p_51454_).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState updateShape(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.scheduleTick(p_51465_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_51464_));
        }
        return super.updateShape(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51468_) {
        p_51468_.add(new Property[]{WATERLOGGED}).add(new Property[]{AXIS});
    }

    public FluidState getFluidState(BlockState p_51475_) {
        return (Boolean)p_51475_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51475_);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (context.getItemInHand().getItem() instanceof AxeItem && !this.isStripped) {
            return (BlockState)((BlockState)this.strippedLog.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }
}

