/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.entity.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.function.Predicate;
import net.felisgamerus.regius.Config;
import net.felisgamerus.regius.entity.ModEntities;
import net.felisgamerus.regius.entity.custom.BallPythonEntityPart;
import net.felisgamerus.regius.entity.custom.DryBucketable;
import net.felisgamerus.regius.entity.custom.genetics.LocusMap;
import net.felisgamerus.regius.item.ModItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BallPythonEntity
extends Animal
implements GeoEntity,
DryBucketable {
    LocusMap ballPythonGenes = new LocusMap();
    static ArrayList<String> MORPH_REFERENCE = LocusMap.getLociArray();
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.ballpython.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.ballpython.walk");
    protected static final RawAnimation BALL = RawAnimation.begin().thenLoop("animation.ballpython.ball");
    protected static final RawAnimation TONGUE = RawAnimation.begin().thenPlay("animation.ballpython.tongue");
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(BallPythonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> GENOTYPE = SynchedEntityData.defineId(BallPythonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> PHENOTYPE = SynchedEntityData.defineId(BallPythonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final BallPythonEntityPart[] ballPythonParts;
    public final int MULTIPART_COUNT = 2;
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public boolean isPushedByFluid() {
        return false;
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new AmphibiousPathNavigation((Mob)this, pLevel);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public float getAgeScale() {
        return 1.0f;
    }

    public BallPythonEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 1.0f, false);
        this.ballPythonParts = new BallPythonEntityPart[this.MULTIPART_COUNT];
        for (int i = 0; i < this.MULTIPART_COUNT; ++i) {
            this.ballPythonParts[i] = new BallPythonEntityPart(this, this.getBbWidth(), this.getBbHeight());
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData) {
        Random notNormalSeed = new Random();
        int MORPH_CHANCE_ON_SPAWN = Config.morphChanceOnSpawn;
        if (notNormalSeed.nextInt(MORPH_CHANCE_ON_SPAWN) == 0) {
            Random morphSeed = new Random();
            String morph = MORPH_REFERENCE.get(morphSeed.nextInt(MORPH_REFERENCE.size()));
            this.setGenotype(morph);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(GENOTYPE, (Object)"normal");
        builder.define(PHENOTYPE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean("FromBucket", this.fromBucket());
        compoundTag.putString("Genotype", this.getGenotype());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setFromBucket(compoundTag.getBoolean("FromBucket"));
        String genotype = compoundTag.contains("Genotype") ? compoundTag.getString("Genotype") : "normal";
        this.setGenotype(genotype);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean pFromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)pFromBucket);
    }

    public void setGenotype(String genotype) {
        this.setGenes(BallPythonEntity.createGenesFromGenotype(genotype));
        if (!BallPythonEntity.getGenotypeString(this.ballPythonGenes).equals("normal")) {
            this.entityData.set(GENOTYPE, (Object)genotype);
        } else {
            this.entityData.set(GENOTYPE, (Object)"normal");
        }
    }

    public String getGenotype() {
        return (String)this.entityData.get(GENOTYPE);
    }

    private <E extends BallPythonEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALK);
            event.getController().setAnimationSpeed(0.75);
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <E extends BallPythonEntity> PlayState tonguePredicate(AnimationState<E> event) {
        if (this.random.nextInt(1000) < this.ambientSoundTime && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(TONGUE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main_controller", 5, this::predicate));
        AnimationController tongueController = new AnimationController((GeoAnimatable)this, "tongue_controller", 0, this::tonguePredicate);
        controllers.add(tongueController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.151).add(Attributes.FOLLOW_RANGE, 5.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 4.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreedGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, 10, true, true, (Predicate)null));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, 10, true, true, (Predicate)null));
    }

    public void travel(Vec3 pTravelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(pTravelVector);
        }
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, compoundTag -> {
            compoundTag.putInt("Age", this.getAge());
            compoundTag.putString("Genotype", this.getGenotype());
        });
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("Genotype")) {
            this.setGenotype(tag.getString("Genotype"));
        }
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.BALL_PYTHON_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return DryBucketable.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.ballPythonParts;
    }

    public boolean attackEntityPartFrom(BallPythonEntityPart ballPythonPart, DamageSource source, float amount) {
        return this.hurt(source, amount);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return super.hurt(pSource, pAmount);
    }

    private void setPartPosition(BallPythonEntityPart part, double offsetX, double offsetY, double offsetZ) {
        part.setPos(this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ);
    }

    public void aiStep() {
        if (!this.isNoAi()) {
            if (!this.isSleeping()) {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.getYRot();
                        this.ringBuffer[i][1] = this.getY();
                    }
                }
                ++this.ringBufferIndex;
                if (this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.getYRot();
                this.ringBuffer[this.ringBufferIndex][1] = this.getY();
                Vector3d[] multipartVectorArray = new Vector3d[this.ballPythonParts.length];
                for (int j = 0; j < this.ballPythonParts.length; ++j) {
                    this.ballPythonParts[j].collideWithNearbyEntities();
                    multipartVectorArray[j] = new Vector3d(this.ballPythonParts[j].getX(), this.ballPythonParts[j].getY(), this.ballPythonParts[j].getZ());
                }
                float f15 = (float)(this.getMovementOffsets(5)[1] - this.getMovementOffsets(10)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = Mth.cos((float)f15);
                float yaw = this.getYRot() * ((float)Math.PI / 180);
                float f3 = Mth.sin((float)yaw);
                float f18 = Mth.cos((float)yaw);
                for (int k = 0; k < this.MULTIPART_COUNT; ++k) {
                    BallPythonEntityPart ball_python_part = this.ballPythonParts[k];
                    float f7 = yaw;
                    float f20 = Mth.sin((float)f7);
                    float f21 = Mth.cos((float)f7);
                    float f23 = ((float)k + 1.0f) * -1.0f;
                    this.setPartPosition(ball_python_part, -(f3 * 0.0f + f20 * f23) * f16, 0.0, (f18 * 0.0f + f21 * f23) * f16);
                    this.ballPythonParts[k].xo = multipartVectorArray[k].x;
                    this.ballPythonParts[k].yo = multipartVectorArray[k].y;
                    this.ballPythonParts[k].zo = multipartVectorArray[k].z;
                    this.ballPythonParts[k].xOld = multipartVectorArray[k].x;
                    this.ballPythonParts[k].yOld = multipartVectorArray[k].y;
                    this.ballPythonParts[k].zOld = multipartVectorArray[k].z;
                }
            } else {
                for (int k = 0; k < this.MULTIPART_COUNT; ++k) {
                    BallPythonEntityPart ball_python_part = this.ballPythonParts[k];
                    this.setPartPosition(ball_python_part, 0.0, 0.0, 0.0);
                    this.ballPythonParts[k].xo = this.getX();
                    this.ballPythonParts[k].yo = this.getY();
                    this.ballPythonParts[k].zo = this.getZ();
                    this.ballPythonParts[k].xOld = this.getX();
                    this.ballPythonParts[k].yOld = this.getY();
                    this.ballPythonParts[k].zOld = this.getZ();
                }
            }
        }
        super.aiStep();
    }

    public double[] getMovementOffsets(int p_70974_1_) {
        double d0;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] offsetDoubleArray = new double[3];
        offsetDoubleArray[0] = d0 = this.ringBuffer[i][0];
        offsetDoubleArray[1] = d0 = this.ringBuffer[i][1];
        return offsetDoubleArray;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.RABBIT);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        BallPythonEntity babySnake = (BallPythonEntity)ModEntities.BALL_PYTHON.get().create((Level)level);
        if (babySnake != null && otherParent instanceof BallPythonEntity) {
            BallPythonEntity parent1 = (BallPythonEntity)otherParent;
            LocusMap babyGenes = BallPythonEntity.getBabyGenes(this, parent1);
            babySnake.setGenes(babyGenes);
            babySnake.setGenotype(BallPythonEntity.getGenotypeString(babyGenes));
        }
        return babySnake;
    }

    public static LocusMap getBabyGenes(BallPythonEntity parent0, BallPythonEntity parent1) {
        String locusName;
        int i;
        LocusMap babyGenes = new LocusMap();
        LocusMap parent0Genes = BallPythonEntity.createGenesFromGenotype(parent0.getGenotype());
        LocusMap parent1Genes = BallPythonEntity.createGenesFromGenotype(parent1.getGenotype());
        for (i = 0; i < MORPH_REFERENCE.size(); ++i) {
            locusName = MORPH_REFERENCE.get(i);
            if (parent0.random.nextBoolean()) {
                babyGenes.genes.get(locusName).setAllele0(parent0Genes.genes.get(locusName).getAllele0());
                continue;
            }
            babyGenes.genes.get(locusName).setAllele0(parent0Genes.genes.get(locusName).getAllele1());
        }
        for (i = 0; i < MORPH_REFERENCE.size(); ++i) {
            locusName = MORPH_REFERENCE.get(i);
            if (parent0.random.nextBoolean()) {
                babyGenes.genes.get(locusName).setAllele1(parent1Genes.genes.get(locusName).getAllele0());
                continue;
            }
            babyGenes.genes.get(locusName).setAllele1(parent1Genes.genes.get(locusName).getAllele1());
        }
        return babyGenes;
    }

    public void setGenes(LocusMap givenLocusMap) {
        this.ballPythonGenes = givenLocusMap;
    }

    public static String convertGenotypeToPhenotype(String genotype) {
        Object phenotype = "normal";
        ArrayList<String> morphList = new ArrayList<String>(Arrays.asList(genotype.split("_")));
        for (int i = 0; i < morphList.size(); ++i) {
            String morphNoSuper;
            String morph = morphList.get(i);
            if (morph.endsWith("-het")) {
                morph = null;
            } else if (morph.endsWith("-super") && LocusMap.checkType(morphNoSuper = morph.substring(0, morph.length() - 6), "dominant").booleanValue()) {
                morph = morphNoSuper;
            }
            if (morph == null) continue;
            phenotype = ((String)phenotype).equals("normal") ? morph : (String)phenotype + "_" + morph;
        }
        return phenotype;
    }

    public static String getGenotypeString(LocusMap genes) {
        int i;
        ArrayList<Object> allMorphs = new ArrayList<Object>();
        Object genotype = "normal";
        block9: for (i = 0; i < MORPH_REFERENCE.size(); ++i) {
            Object locusName = MORPH_REFERENCE.get(i);
            int allele0Value = genes.getAllele0((String)locusName);
            int allele1Value = genes.getAllele1((String)locusName);
            boolean notNormal = false;
            boolean isCodominantHeterozygous = false;
            boolean isHomozygous = false;
            if (allele0Value != allele1Value || allele0Value != 0) {
                notNormal = true;
            }
            if (allele0Value == 1 ^ allele1Value == 1) {
                isCodominantHeterozygous = true;
            }
            if (allele0Value == 1 && allele1Value == 1) {
                isHomozygous = true;
            }
            if (!notNormal) continue;
            switch (LocusMap.getLocusType((String)locusName)) {
                case "dominant": 
                case "incompleteDominant": {
                    if (isCodominantHeterozygous) {
                        allMorphs.add(locusName);
                        continue block9;
                    }
                    if (!isHomozygous) continue block9;
                    locusName = (String)locusName + "-super";
                    allMorphs.add(locusName);
                    continue block9;
                }
                case "recessive": {
                    if (isCodominantHeterozygous) {
                        locusName = (String)locusName + "-het";
                        allMorphs.add(locusName);
                        continue block9;
                    }
                    if (!isHomozygous) continue block9;
                    allMorphs.add(locusName);
                }
            }
        }
        Collections.sort(allMorphs);
        for (i = 0; i < allMorphs.size(); ++i) {
            String morph = (String)allMorphs.get(i);
            genotype = i == 0 ? morph : (String)genotype + "_" + morph;
        }
        return genotype;
    }

    public static LocusMap createGenesFromGenotype(String genotype) {
        LocusMap createdGenes = new LocusMap();
        ArrayList<String> morphList = new ArrayList<String>(Arrays.asList(genotype.split("_")));
        Collections.sort(morphList);
        for (int i = 0; i < morphList.size(); ++i) {
            Boolean isHomozygous = false;
            String morph = morphList.get(i);
            if (morph.equals("normal")) break;
            if (morph == null) continue;
            if (morph.endsWith("-het")) {
                morph = morph.substring(0, morph.length() - 4);
            } else if (morph.endsWith("-super")) {
                morph = morph.substring(0, morph.length() - 6);
                isHomozygous = true;
            } else if (LocusMap.checkType(morph, "recessive").booleanValue()) {
                isHomozygous = true;
            }
            createdGenes.genes.get(morph).setAllele0(1);
            if (!isHomozygous.booleanValue()) continue;
            createdGenes.genes.get(morph).setAllele1(1);
        }
        return createdGenes;
    }

    public record GenotypeRecord(String genotype) {
        public static final Codec<GenotypeRecord> CODEC = Codec.STRING.xmap(GenotypeRecord::new, GenotypeRecord::getGenotype);

        public String getGenotype() {
            return this.genotype;
        }

        public String getPhenotype(String genotype) {
            String phenotype = BallPythonEntity.convertGenotypeToPhenotype(genotype);
            return phenotype;
        }
    }
}

