/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.felisgamerus.regius.entity.custom.BallPythonEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.entity.PartEntity;

public class BallPythonEntityPart
extends PartEntity<BallPythonEntity> {
    private final EntityDimensions size;

    public BallPythonEntityPart(BallPythonEntity parent, float sizeX, float sizeY) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)sizeX, (float)sizeY);
        this.refreshDimensions();
    }

    protected void collideWithNearbyEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(0.2, 0.0, 0.2));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && (!(entity instanceof BallPythonEntityPart) || ((BallPythonEntityPart)((Object)entity)).getParent() != parent) && entity.isPushable()).forEach(entity -> entity.push(parent));
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == Items.BUCKET) {
            return InteractionResult.PASS;
        }
        return ((BallPythonEntity)this.getParent()).mobInteract(player, hand);
    }

    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source) && ((BallPythonEntity)this.getParent()).attackEntityPartFrom(this, source, amount);
    }

    @Nullable
    public ItemStack getPickResult() {
        Entity parent = this.getParent();
        return parent != null ? parent.getPickResult() : ItemStack.EMPTY;
    }

    public boolean isPickable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void push(Entity entityIn) {
        entityIn.push((Entity)this);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }
}

