/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.entity.custom;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface DryBucketable
extends Bucketable {
    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == Items.BUCKET && entity.isAlive()) {
            entity.playSound(((Bucketable)entity).getPickupSound(), 1.0f, 1.0f);
            ItemStack itemstack1 = ((Bucketable)entity).getBucketItemStack();
            ((Bucketable)entity).saveToBucketTag(itemstack1);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.setItemInHand(hand, itemstack2);
            Level level = entity.level();
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack1);
            }
            entity.discard();
            return Optional.of(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        return Optional.empty();
    }
}

