/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.felisgamerus.regius.entity.custom.BallPythonEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BallPythonBucketItem
extends BucketItem {
    private final EntityType<?> type;
    private final SoundEvent emptySound;
    private static final MapCodec<BallPythonEntity.GenotypeRecord> GENOTYPE_FIELD_CODEC = BallPythonEntity.GenotypeRecord.CODEC.fieldOf("Genotype");

    public BallPythonBucketItem(EntityType<?> type, Fluid content, SoundEvent emptySound, Item.Properties properties) {
        super(content, properties);
        this.type = type;
        this.emptySound = emptySound;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockPos blockpos2;
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = BallPythonBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (!level.mayInteract(player, blockpos) || !player.mayUseItemAt(blockpos1, direction, itemstack)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, level, blockpos, blockstate) ? blockpos : blockpos1;
        if (this.type != null) {
            this.checkExtraContent(player, level, itemstack, blockpos2);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
            }
            this.playEmptySound(player, (LevelAccessor)level, blockpos);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)BallPythonBucketItem.getEmptySuccessItem((ItemStack)itemstack, (Player)player));
            return InteractionResultHolder.sidedSuccess((Object)itemstack1, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack containerStack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawn((ServerLevel)level, containerStack, pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        level.playSound(player, pos, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel serverLevel, ItemStack bucketedMobStack, BlockPos pos) {
        Entity entity = this.type.spawn(serverLevel, bucketedMobStack, (Player)null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            CustomData customdata = (CustomData)bucketedMobStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            bucketable.loadFromBucketTag(customdata.copyTag());
            bucketable.setFromBucket(true);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CustomData customdata = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (customdata.isEmpty()) {
            return;
        }
        Optional optional = customdata.read(GENOTYPE_FIELD_CODEC).result();
        if (optional.isPresent()) {
            BallPythonEntity.GenotypeRecord genotypeRecord = (BallPythonEntity.GenotypeRecord)optional.get();
            String phenotype = genotypeRecord.getPhenotype(genotypeRecord.getGenotype());
            ChatFormatting[] achatformatting = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            tooltipComponents.add((Component)this.getPhenotypeComponent(phenotype).withStyle(achatformatting));
        }
    }

    private MutableComponent getPhenotypeComponent(String phenotype) {
        MutableComponent toReturn = Component.translatable((String)"entity.regius.ball_python.phenotype.normal");
        ArrayList<String> morphList = new ArrayList<String>(Arrays.asList(phenotype.split("_")));
        Collections.sort(morphList);
        for (int i = 0; i < morphList.size(); ++i) {
            String morph = morphList.get(i);
            if (toReturn.toString().equals("translation{key='entity.regius.ball_python.phenotype.normal', args=[]}")) {
                toReturn = Component.translatable((String)("entity.regius.ball_python.phenotype." + morph));
                continue;
            }
            toReturn.append(", ").append((Component)Component.translatable((String)("entity.regius.ball_python.phenotype." + morph)));
        }
        return toReturn;
    }

    public static Float getBucketPhenotype(ItemStack stack) {
        CustomData customdata = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        Optional optional = customdata.read(GENOTYPE_FIELD_CODEC).result();
        if (optional.isPresent()) {
            BallPythonEntity.GenotypeRecord genotypeRecord = (BallPythonEntity.GenotypeRecord)optional.get();
            String phenotype = genotypeRecord.getPhenotype(genotypeRecord.getGenotype());
            ArrayList<String> morphList = new ArrayList<String>(Arrays.asList(phenotype.split("_")));
            Collections.sort(morphList);
            for (int i = 0; i < morphList.size(); ++i) {
                String morph = morphList.get(i);
                if (!morph.equals("albino")) continue;
                return Float.valueOf(1.0f);
            }
        }
        return Float.valueOf(0.0f);
    }
}

