/*
 * Decompiled with CFR 0.152.
 */
package net.felisgamerus.regius.worldgen;

import java.util.List;
import net.felisgamerus.regius.Config;
import net.felisgamerus.regius.entity.ModEntities;
import net.felisgamerus.regius.worldgen.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> SPAWN_BALL_PYTHON = ModBiomeModifiers.registerKey("spawn_ball_python");
    public static final ResourceKey<BiomeModifier> ADD_SPHAGNUM_MOSS = ModBiomeModifiers.registerKey("add_sphagnum_moss");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(SPAWN_BALL_PYTHON, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SAVANNA)}), List.of(new MobSpawnSettings.SpawnerData(ModEntities.BALL_PYTHON.get(), Config.spawnWeight, 1, 1))));
        context.register(ADD_SPHAGNUM_MOSS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.SWAMP)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.SPHAGNUM_MOSS_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"regius", (String)name));
    }
}

