/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Scale
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, Long> amethystCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Long> echoShardCooldowns = new HashMap<UUID, Long>();
    private String prefix;
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("prefix", "&8[&bScale&8] "));
        this.getLogger().info("Scale has been enabled!");
        this.getCommand("scale").setExecutor((CommandExecutor)this);
        this.getCommand("scaleshard").setExecutor((CommandExecutor)this);
        this.getCommand("scaleshard").setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        this.getLogger().info("Scale is now disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("scale")) {
            block33: {
                if (args.length == 0 || args.length > 2) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fUsage: /scale <value> or /scale <playername> <value>")));
                    return true;
                }
                if (args.length == 1) {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        if (player.hasPermission("scale.use")) {
                            String scaleArgument = args[0];
                            try {
                                if (scaleArgument.startsWith("+") || scaleArgument.startsWith("-")) {
                                    double scaleChange = Double.parseDouble(scaleArgument);
                                    this.adjustScale(player, scaleChange, 2);
                                    break block33;
                                }
                                double scaleValue = Double.parseDouble(scaleArgument);
                                this.setScale((LivingEntity)player, scaleValue, 2);
                            }
                            catch (NumberFormatException e) {
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fInvalid value.")));
                            }
                        } else {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fYou do not have permission to use this command.")));
                        }
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fThis command can only be used by players.")));
                    }
                } else if (args.length == 2) {
                    String targetName = args[0];
                    String scaleValue = args[1];
                    if (targetName.equalsIgnoreCase("*")) {
                        if (sender.hasPermission("scale.other")) {
                            try {
                                if (scaleValue.startsWith("+") || scaleValue.startsWith("-")) {
                                    double scaleChange = Double.parseDouble(scaleValue);
                                    this.adjustScaleForMultiplePlayers(Bukkit.getOnlinePlayers(), scaleChange, 2);
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fAdjusting scale by &e" + scaleValue + "&f for all players.")));
                                    break block33;
                                }
                                double scale = Double.parseDouble(scaleValue);
                                this.setScaleForMultiplePlayers(Bukkit.getOnlinePlayers(), scale, 2);
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fSetting scale to &e" + scaleValue + "&f for all players.")));
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fInvalid scale value.")));
                            }
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fYou do not have permission to scale other players.")));
                        }
                    } else {
                        Player target = Bukkit.getPlayerExact((String)targetName);
                        if (target != null && target.isOnline()) {
                            if (sender.hasPermission("scale.other")) {
                                try {
                                    if (scaleValue.startsWith("+") || scaleValue.startsWith("-")) {
                                        double scaleChange = Double.parseDouble(scaleValue);
                                        this.adjustScale(target, scaleChange, 2);
                                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fAdjusting &e" + target.getName() + "'s &fscale by &e" + scaleChange)));
                                        break block33;
                                    }
                                    double scale = Double.parseDouble(scaleValue);
                                    this.setScale((LivingEntity)target, scale, 2);
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fSetting &e" + target.getName() + "'s &fscale to &e" + scale)));
                                }
                                catch (NumberFormatException e) {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fInvalid scale value.")));
                                }
                            } else {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fYou do not have permission to scale other players.")));
                            }
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fPlayer not found.")));
                        }
                    }
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("scaleshard")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.isOp() || player.hasPermission("scale.shard")) {
                    if (args.length == 0) {
                        this.openShardGui(player);
                    } else {
                        this.giveCrystalShard(player, args[0].toLowerCase());
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&cYou don't have permission to use this command.")));
                }
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fThis command can only be used by players.")));
            }
            return true;
        }
        return false;
    }

    private void adjustScaleForMultiplePlayers(Collection<? extends Player> players, double scaleChange, int durationInSeconds) {
        for (Player player : players) {
            double currentScale = player.getAttribute(Attribute.GENERIC_SCALE).getBaseValue();
            double targetScale = Math.max(0.01, Math.min(50.0, currentScale + scaleChange));
            this.setScale((LivingEntity)player, targetScale, durationInSeconds);
        }
    }

    private void setScaleForMultiplePlayers(Collection<? extends Player> players, double scale, int durationInSeconds) {
        for (Player player : players) {
            this.setScale((LivingEntity)player, scale, durationInSeconds);
        }
    }

    private void adjustScale(Player player, double scaleChange, int durationInSeconds) {
        double currentScale = player.getAttribute(Attribute.GENERIC_SCALE).getBaseValue();
        double targetScale = Math.max(0.01, Math.min(50.0, currentScale + scaleChange));
        this.setScale((LivingEntity)player, targetScale, durationInSeconds);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ConfigurationSection crystalsSection;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("scale")) {
            if (args.length == 1) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    suggestions.add(player.getName());
                }
                suggestions.add("*");
            }
        } else if (command.getName().equalsIgnoreCase("scaleshard") && sender.hasPermission("scale.shard") && (crystalsSection = this.config.getConfigurationSection("crystals")) != null) {
            suggestions.addAll(crystalsSection.getKeys(false));
        }
        return suggestions;
    }

    private void openShardGui(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&0Scale 1.0.1"));
        ConfigurationSection crystalsSection = this.config.getConfigurationSection("crystals");
        if (crystalsSection != null) {
            for (String key : crystalsSection.getKeys(false)) {
                ItemStack shard = this.createShardFromConfig(key);
                if (shard == null) continue;
                gui.addItem(new ItemStack[]{shard});
            }
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&0Scale 1.0.1"))) {
            event.setCancelled(true);
            if (event.getCurrentItem() != null && event.getCurrentItem().hasItemMeta()) {
                Player player = (Player)event.getWhoClicked();
                ItemStack item = event.getCurrentItem();
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fYou received a " + item.getItemMeta().getDisplayName())));
                player.closeInventory();
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTitle().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&0Scale 1.0.1"))) {
            HumanEntity humanEntity = event.getPlayer();
        }
    }

    private void giveCrystalShard(Player player, String shardType) {
        if (!this.config.contains("crystals." + shardType)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&cUnknown shard type: " + shardType)));
            return;
        }
        Material material = Material.getMaterial((String)this.config.getString("crystals." + shardType + ".material", "AMETHYST_SHARD"));
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("crystals." + shardType + ".name"));
        List lore = this.config.getStringList("crystals." + shardType + ".lore");
        ArrayList<String> translatedLore = new ArrayList<String>();
        for (String line : lore) {
            translatedLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        ItemStack shard = this.createShard(material, name, translatedLore);
        player.getInventory().addItem(new ItemStack[]{shard});
    }

    private ItemStack createShardFromConfig(String shardType) {
        Material material = Material.getMaterial((String)this.config.getString("crystals." + shardType + ".material", "AMETHYST_SHARD"));
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("crystals." + shardType + ".name"));
        List lore = this.config.getStringList("crystals." + shardType + ".lore");
        if (material == null) {
            return null;
        }
        ArrayList<String> translatedLore = new ArrayList<String>();
        for (String line : lore) {
            translatedLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        return this.createShard(material, name, translatedLore);
    }

    private ItemStack createShard(Material material, String name, List<String> lore) {
        ItemStack shard = new ItemStack(material);
        ItemMeta meta = shard.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        shard.setItemMeta(meta);
        return shard;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        String displayName;
        String shardType;
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.hasItemMeta() && event.getAction().toString().contains("RIGHT_CLICK") && (shardType = this.getShardTypeByDisplayName(displayName = item.getItemMeta().getDisplayName())) != null) {
            double scale = this.config.getDouble("crystals." + shardType + ".scale");
            int cooldown = this.config.getInt("crystals." + shardType + ".cooldown");
            String particleEffect = this.config.getString("crystals." + shardType + ".particle_effect");
            this.handleShardUse(player, (LivingEntity)player, item, scale, this.getCooldownMap(shardType), cooldown, particleEffect);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof LivingEntity) {
            String displayName;
            String shardType;
            Player player = (Player)event.getDamager();
            LivingEntity target = (LivingEntity)event.getEntity();
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.hasItemMeta() && (shardType = this.getShardTypeByDisplayName(displayName = item.getItemMeta().getDisplayName())) != null) {
                double scale = this.config.getDouble("crystals." + shardType + ".scale");
                int cooldown = this.config.getInt("crystals." + shardType + ".cooldown");
                String particleEffect = this.config.getString("crystals." + shardType + ".particle_effect");
                this.handleShardUse(player, target, item, scale, this.getCooldownMap(shardType), cooldown, particleEffect);
                event.setCancelled(true);
            }
        }
    }

    private String getShardTypeByDisplayName(String displayName) {
        for (String shardType : this.config.getConfigurationSection("crystals").getKeys(false)) {
            String name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("crystals." + shardType + ".name"));
            if (!displayName.equals(name)) continue;
            return shardType;
        }
        return null;
    }

    private Map<UUID, Long> getCooldownMap(String shardType) {
        if (shardType.equalsIgnoreCase("giant")) {
            return this.echoShardCooldowns;
        }
        return this.amethystCooldowns;
    }

    private void handleShardUse(Player user, LivingEntity target, ItemStack item, double scale, Map<UUID, Long> cooldownMap, int cooldown, String particleEffect) {
        if (this.isOnCooldown(user, cooldownMap)) {
            return;
        }
        this.startCooldown(user, item, cooldownMap, cooldown);
        user.getWorld().playSound(user.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 1.0f);
        this.spawnParticleEffect(target, particleEffect);
        this.setScale(target, scale, 2);
    }

    private void spawnParticleEffect(final LivingEntity target, String particleEffect) {
        final Particle particle = Particle.valueOf((String)particleEffect);
        new BukkitRunnable(){
            double t = 0.0;

            public void run() {
                this.t += 0.19634954084936207;
                for (double theta = 0.0; theta <= Math.PI * 2; theta += 0.39269908169872414) {
                    double x = 0.5 * Math.cos(this.t + theta);
                    double y = 0.5 * Math.sin(this.t + theta) + 1.5;
                    double z = 0.5 * Math.sin(this.t + theta);
                    target.getWorld().spawnParticle(particle, target.getLocation().add(x, y, z), 0);
                }
                if (this.t >= Math.PI * 4) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    private boolean isOnCooldown(Player player, Map<UUID, Long> cooldownMap) {
        if (cooldownMap.containsKey(player.getUniqueId())) {
            long timeLeft = (cooldownMap.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000L;
            if (timeLeft > 0L) {
                return true;
            }
            cooldownMap.remove(player.getUniqueId());
        }
        return false;
    }

    private void startCooldown(final Player player, final ItemStack item, final Map<UUID, Long> cooldownMap, int cooldown) {
        cooldownMap.put(player.getUniqueId(), System.currentTimeMillis() + (long)(cooldown * 1000));
        new BukkitRunnable(){

            public void run() {
                long timeLeft = (Long)cooldownMap.get(player.getUniqueId()) - System.currentTimeMillis();
                if (timeLeft > 0L) {
                    player.setCooldown(item.getType(), (int)(timeLeft / 50L));
                } else {
                    player.setCooldown(item.getType(), 0);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 1L, 1L);
    }

    private void setScale(final LivingEntity target, final double scale, int durationInSeconds) {
        block2: {
            try {
                double currentScale = target.getAttribute(Attribute.GENERIC_SCALE).getBaseValue();
                final int steps = 20 * durationInSeconds;
                final double scaleIncrement = (scale - currentScale) / (double)steps;
                new BukkitRunnable(){
                    int step = 0;

                    public void run() {
                        if (this.step >= steps) {
                            target.getAttribute(Attribute.GENERIC_SCALE).setBaseValue(scale);
                            this.cancel();
                        } else {
                            double newScale = target.getAttribute(Attribute.GENERIC_SCALE).getBaseValue() + scaleIncrement;
                            target.getAttribute(Attribute.GENERIC_SCALE).setBaseValue(newScale);
                            ++this.step;
                        }
                    }
                }.runTaskTimer((Plugin)this, 0L, 1L);
            }
            catch (Exception e) {
                if (!(target instanceof Player)) break block2;
                ((Player)target).sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&cError while setting scale.")));
            }
        }
    }

    private void handleSetCommand(CommandSender sender, String targetName, String scaleValue) {
        try {
            double scale = Double.parseDouble(scaleValue);
            if (targetName.equalsIgnoreCase("*")) {
                if (sender.hasPermission("scale.other")) {
                    HashMap<Player, Double> playersToScale = new HashMap<Player, Double>();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        playersToScale.put(player, scale);
                    }
                    this.setScaleForMultiplePlayers(playersToScale, 2);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fScaled all online players to &e" + scaleValue)));
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&fUnknown command. Type ''/help'' for help."));
                }
            } else {
                Player target = Bukkit.getPlayer((String)targetName);
                if (target != null && target.isOnline()) {
                    if (sender.hasPermission("scale.other")) {
                        this.setScale((LivingEntity)target, scale, 2);
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fSet &e" + targetName + "'s&f scale to &e" + scaleValue)));
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&fUnknown command. Type ''/help'' for help."));
                    }
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&cPlayer not found")));
                }
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&cInvalid scale value")));
        }
    }

    private void setScaleForMultiplePlayers(final Map<Player, Double> playersToScale, int durationInSeconds) {
        final int steps = 20 * durationInSeconds;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                if (this.step >= steps) {
                    for (Map.Entry entry : playersToScale.entrySet()) {
                        ((Player)entry.getKey()).getAttribute(Attribute.GENERIC_SCALE).setBaseValue(((Double)entry.getValue()).doubleValue());
                    }
                    this.cancel();
                } else {
                    for (Map.Entry entry : playersToScale.entrySet()) {
                        Player player = (Player)entry.getKey();
                        double targetScale = (Double)entry.getValue();
                        double currentScale = player.getAttribute(Attribute.GENERIC_SCALE).getBaseValue();
                        double scaleIncrement = (targetScale - currentScale) / (double)(steps - this.step);
                        player.getAttribute(Attribute.GENERIC_SCALE).setBaseValue(currentScale + scaleIncrement);
                    }
                    ++this.step;
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }
}

