/*
 * Decompiled with CFR 0.152.
 */
package com.clarity;

import com.clarity.ClarityConfig;
import com.clarity.ClarityMod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1058;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_9779;

public class PotionHudRenderer
implements HudRenderCallback {
    private static final class_310 client = class_310.method_1551();
    public static final PotionHudRenderer INSTANCE = new PotionHudRenderer();
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_LITERALS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    public static void renderPreview(class_332 context, int mouseX, int mouseY) {
        if (!ClarityMod.modEnabled) {
            return;
        }
        INSTANCE.renderInternal(context, mouseX, mouseY, true);
    }

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!ClarityMod.modEnabled || PotionHudRenderer.client.field_1690.field_1842) {
            return;
        }
        this.renderInternal(context, 0, 0, false);
    }

    private void renderInternal(class_332 context, int mouseX, int mouseY, boolean isPreview) {
        if (PotionHudRenderer.client.field_1724 == null) {
            return;
        }
        ArrayList<class_1293> effects = new ArrayList<class_1293>(PotionHudRenderer.client.field_1724.method_6026().stream().sorted(Comparator.comparingInt(class_1293::method_5584).reversed()).toList());
        if (effects.isEmpty() && isPreview) {
            effects.add(new class_1293(class_1294.field_5904, 1200, 1));
            effects.add(new class_1293(class_1294.field_5910, 200, 4));
        }
        if (effects.isEmpty()) {
            return;
        }
        int x = ClarityConfig.hudX;
        int y = ClarityConfig.hudY;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        matrices.method_22905((float)ClarityConfig.scale, (float)ClarityConfig.scale, 1.0f);
        int index = 0;
        for (class_1293 effect : effects) {
            int iconX;
            int textX;
            int iconWidth = 18;
            int entryHeight = 20;
            int secondsLeft = effect.method_5584() / 20;
            String timeString = PotionHudRenderer.formatTime(secondsLeft);
            int timeWidth = PotionHudRenderer.client.field_1772.method_1727(timeString);
            String ampString = "";
            if (ClarityConfig.showAmplifier && effect.method_5578() > 0) {
                ampString = PotionHudRenderer.getRomanNumeral(effect.method_5578() + 1);
            }
            int gap = 2;
            int entryWidth = iconWidth + gap + timeWidth;
            int bg = (ClarityConfig.backgroundOpacity & 0xFF) << 24;
            int bgX = -2;
            int bgY = index * entryHeight - 2;
            int bgW = entryWidth + 4;
            int bgH = entryHeight;
            context.method_25294(bgX, bgY, bgX + bgW, bgY + bgH, bg);
            if (ClarityConfig.iconOnRight) {
                textX = 0;
                iconX = textX + timeWidth + gap;
            } else {
                iconX = 0;
                textX = iconX + iconWidth + gap;
            }
            int col = PotionHudRenderer.getColor(secondsLeft);
            Objects.requireNonNull(PotionHudRenderer.client.field_1772);
            int textY = index * entryHeight + (entryHeight - 9) / 2;
            context.method_51433(PotionHudRenderer.client.field_1772, timeString, textX, textY, col, true);
            class_1058 sprite = client.method_18505().method_18663(effect.method_5579());
            context.method_25298(iconX, index * entryHeight, 0, iconWidth, iconWidth, sprite);
            if (!ampString.isEmpty()) {
                class_5250 ampText = class_2561.method_43470((String)ampString);
                int ampWidth = PotionHudRenderer.client.field_1772.method_1727(ampString);
                int ampX = iconX + (iconWidth - ampWidth) / 2;
                int n = index * entryHeight + (int)((float)iconWidth * 0.8f);
                Objects.requireNonNull(PotionHudRenderer.client.field_1772);
                int ampY = n - 9 / 2;
                context.method_51439(PotionHudRenderer.client.field_1772, (class_2561)ampText, ampX, ampY, col, true);
            }
            ++index;
        }
        matrices.method_22909();
    }

    private static int getColor(int secondsLeft) {
        if (ClarityConfig.warn2Enabled && secondsLeft <= ClarityConfig.warn2Threshold) {
            return PotionHudRenderer.parseHex(ClarityConfig.colorWarn2);
        }
        if (ClarityConfig.warn1Enabled && secondsLeft <= ClarityConfig.warn1Threshold) {
            return PotionHudRenderer.parseHex(ClarityConfig.colorWarn1);
        }
        return PotionHudRenderer.parseHex(ClarityConfig.colorNormal);
    }

    private static int parseHex(String hex) {
        try {
            String h = hex.replace("#", "");
            if (h.length() == 6) {
                return 0xFF000000 | Integer.parseInt(h, 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static String formatTime(int totalSeconds) {
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static String getRomanNumeral(int number) {
        if (number < 1 || number > 3999) {
            return String.valueOf(number);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ROMAN_VALUES.length; ++i) {
            while (number >= ROMAN_VALUES[i]) {
                number -= ROMAN_VALUES[i];
                sb.append(ROMAN_LITERALS[i]);
            }
        }
        return sb.toString();
    }
}

