/*
 * Decompiled with CFR 0.152.
 */
package com.clarity;

import com.clarity.ClarityConfig;
import com.clarity.ClarityMod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "clarity.properties");
    private static final Properties properties = new Properties();

    public static void saveConfig() {
        properties.setProperty("hudX", String.valueOf(ClarityConfig.hudX));
        properties.setProperty("hudY", String.valueOf(ClarityConfig.hudY));
        properties.setProperty("scale", String.valueOf(ClarityConfig.scale));
        properties.setProperty("backgroundOpacity", String.valueOf(ClarityConfig.backgroundOpacity));
        properties.setProperty("showAmplifier", String.valueOf(ClarityConfig.showAmplifier));
        properties.setProperty("iconOnRight", String.valueOf(ClarityConfig.iconOnRight));
        properties.setProperty("colorNormal", ClarityConfig.colorNormal);
        properties.setProperty("colorWarn1", ClarityConfig.colorWarn1);
        properties.setProperty("colorWarn2", ClarityConfig.colorWarn2);
        properties.setProperty("warn1Enabled", String.valueOf(ClarityConfig.warn1Enabled));
        properties.setProperty("warn2Enabled", String.valueOf(ClarityConfig.warn2Enabled));
        properties.setProperty("warn1Threshold", String.valueOf(ClarityConfig.warn1Threshold));
        properties.setProperty("warn2Threshold", String.valueOf(ClarityConfig.warn2Threshold));
        properties.setProperty("modEnabled", String.valueOf(ClarityMod.modEnabled));
        try (FileOutputStream fos = new FileOutputStream(CONFIG_FILE);){
            properties.store(fos, "Clarity Mod Settings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileInputStream fis = new FileInputStream(CONFIG_FILE);){
                properties.load(fis);
                ClarityConfig.hudX = Integer.parseInt(properties.getProperty("hudX", "4"));
                ClarityConfig.hudY = Integer.parseInt(properties.getProperty("hudY", "4"));
                ClarityConfig.scale = Double.parseDouble(properties.getProperty("scale", "1.0"));
                ClarityConfig.backgroundOpacity = Integer.parseInt(properties.getProperty("backgroundOpacity", "128"));
                ClarityConfig.showAmplifier = Boolean.parseBoolean(properties.getProperty("showAmplifier", "true"));
                ClarityConfig.iconOnRight = Boolean.parseBoolean(properties.getProperty("iconOnRight", "false"));
                ClarityConfig.colorNormal = properties.getProperty("colorNormal", "FFFFFF");
                ClarityConfig.colorWarn1 = properties.getProperty("colorWarn1", "FFA500");
                ClarityConfig.colorWarn2 = properties.getProperty("colorWarn2", "FF0000");
                ClarityConfig.warn1Enabled = Boolean.parseBoolean(properties.getProperty("warn1Enabled", "true"));
                ClarityConfig.warn2Enabled = Boolean.parseBoolean(properties.getProperty("warn2Enabled", "true"));
                ClarityConfig.warn1Threshold = Integer.parseInt(properties.getProperty("warn1Threshold", "30"));
                ClarityConfig.warn2Threshold = Integer.parseInt(properties.getProperty("warn2Threshold", "10"));
                ClarityMod.modEnabled = Boolean.parseBoolean(properties.getProperty("modEnabled", "true"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ConfigManager.saveConfig();
        }
    }
}

