/*
 * Decompiled with CFR 0.152.
 */
package com.clarity;

import com.clarity.ClarityConfig;
import com.clarity.ClarityMod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class PotionHudRenderer {
    private static final class_310 client = class_310.method_1551();
    public static final PotionHudRenderer INSTANCE = new PotionHudRenderer();
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_LITERALS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final class_2960 GUI_ATLAS = class_2960.method_60656((String)"textures/atlas/gui.png");

    public static void renderPreview(class_332 context, int mouseX, int mouseY) {
        if (!ClarityMod.modEnabled) {
            return;
        }
        INSTANCE.renderInternal(context, mouseX, mouseY, true);
    }

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!ClarityMod.modEnabled || PotionHudRenderer.client.field_1690.field_1842) {
            return;
        }
        this.renderInternal(context, 0, 0, false);
    }

    private void renderInternal(class_332 context, int mouseX, int mouseY, boolean isPreview) {
        if (PotionHudRenderer.client.field_1724 == null) {
            return;
        }
        ArrayList<class_1293> effects = new ArrayList<class_1293>(PotionHudRenderer.client.field_1724.method_6026().stream().sorted(Comparator.comparingInt(class_1293::method_5584).reversed()).toList());
        if (effects.isEmpty() && isPreview) {
            effects.add(new class_1293(class_1294.field_5904, 1200, 1));
            effects.add(new class_1293(class_1294.field_5910, 200, 4));
        }
        if (effects.isEmpty()) {
            return;
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)ClarityConfig.hudX, (float)ClarityConfig.hudY);
        float scale = (float)ClarityConfig.scale;
        matrices.scale(scale, scale);
        int baseX = 0;
        int baseY = 0;
        int index = 0;
        for (class_1293 effect : effects) {
            int iconX;
            int textX;
            int ampLevel;
            int iconWidth = 18;
            int entryHeight = 20;
            int secondsLeft = effect.method_5584() / 20;
            String timeString = PotionHudRenderer.formatTime(secondsLeft);
            int timeWidth = PotionHudRenderer.client.field_1772.method_1727(timeString);
            String ampString = "";
            if (ClarityConfig.showAmplifier && (ampLevel = effect.method_5578() + 1) > 1) {
                ampString = PotionHudRenderer.getRomanNumeral(ampLevel);
            }
            int ampWidth = ampString.isEmpty() ? 0 : PotionHudRenderer.client.field_1772.method_1727(ampString);
            int gap = 2;
            int entryWidth = iconWidth + gap + timeWidth;
            int bg = (ClarityConfig.backgroundOpacity & 0xFF) << 24;
            int bgX = baseX - 2;
            int bgY = baseY + index * entryHeight - 2;
            int bgW = entryWidth + 4;
            int bgH = entryHeight;
            context.method_25294(bgX, bgY, bgX + bgW, bgY + bgH, bg);
            if (ClarityConfig.iconOnRight) {
                textX = 0;
                iconX = textX + timeWidth + gap;
            } else {
                iconX = 0;
                textX = iconX + iconWidth + gap;
            }
            int col = PotionHudRenderer.getColor(secondsLeft);
            Objects.requireNonNull(PotionHudRenderer.client.field_1772);
            int textY = baseY + index * entryHeight + (entryHeight - 9) / 2;
            int textStartX = baseX + textX;
            context.method_51433(PotionHudRenderer.client.field_1772, timeString, textStartX, textY, col, true);
            class_6880 entry = effect.method_5579();
            Optional keyOpt = entry.method_40230();
            if (keyOpt.isPresent()) {
                class_5321 key;
                class_2960 effectId;
                class_2960 alt1;
                class_2960 spriteId = class_329.method_71644((class_6880)entry);
                class_1058 sprite = PotionHudRenderer.resolveSprite(spriteId);
                if (sprite == null && (sprite = PotionHudRenderer.resolveSprite(alt1 = class_2960.method_60655((String)(effectId = (key = (class_5321)keyOpt.get()).method_29177()).method_12836(), (String)("effect/" + effectId.method_12832())))) == null) {
                    class_2960 alt2 = class_2960.method_60655((String)effectId.method_12836(), (String)("mob_effect/" + effectId.method_12832()));
                    sprite = PotionHudRenderer.resolveSprite(alt2);
                }
                int iconAbsX = baseX + iconX;
                int iconAbsY = baseY + index * entryHeight + (entryHeight - iconWidth) / 2 - 1;
                if (sprite != null) {
                    context.method_52709(class_10799.field_56883, sprite, iconAbsX, iconAbsY, iconWidth, iconWidth);
                } else {
                    context.method_52706(class_10799.field_56883, spriteId, iconAbsX, iconAbsY, iconWidth, iconWidth);
                }
            }
            if (!ampString.isEmpty()) {
                int iconAbsX = baseX + iconX;
                int iconAbsY = baseY + index * entryHeight;
                int ampX = iconAbsX + (iconWidth - ampWidth) / 2;
                int n = iconAbsY + (int)((float)iconWidth * 0.8f);
                Objects.requireNonNull(PotionHudRenderer.client.field_1772);
                int ampY = n - 9 / 2;
                context.method_51433(PotionHudRenderer.client.field_1772, ampString, ampX, ampY, col, true);
            }
            ++index;
        }
        matrices.popMatrix();
    }

    private static int getColor(int secondsLeft) {
        if (ClarityConfig.warn2Enabled && secondsLeft <= ClarityConfig.warn2Threshold) {
            return PotionHudRenderer.parseHex(ClarityConfig.colorWarn2);
        }
        if (ClarityConfig.warn1Enabled && secondsLeft <= ClarityConfig.warn1Threshold) {
            return PotionHudRenderer.parseHex(ClarityConfig.colorWarn1);
        }
        return PotionHudRenderer.parseHex(ClarityConfig.colorNormal);
    }

    private static int parseHex(String hex) {
        try {
            String h = hex.replace("#", "");
            if (h.length() == 6) {
                return 0xFF000000 | Integer.parseInt(h, 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static String formatTime(int totalSeconds) {
        if (totalSeconds <= 0) {
            return "inf";
        }
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static String getRomanNumeral(int number) {
        if (number < 1 || number > 3999) {
            return String.valueOf(number);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ROMAN_VALUES.length; ++i) {
            while (number >= ROMAN_VALUES[i]) {
                number -= ROMAN_VALUES[i];
                sb.append(ROMAN_LITERALS[i]);
            }
        }
        return sb.toString();
    }

    private static class_1058 resolveSprite(class_2960 texturePath) {
        class_1044 texture = client.method_1531().method_4619(GUI_ATLAS);
        if (texture instanceof class_1059) {
            class_1059 atlasTexture = (class_1059)texture;
            return atlasTexture.method_4608(texturePath);
        }
        return null;
    }
}

