/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib;

import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class Effect {
    protected int iterations;
    protected class_243 originPos;
    protected boolean updatePositions;
    protected boolean useEyePosAsOrigin;
    protected class_1297 entityOrigin;
    protected class_243 originOffset = class_243.field_1353;
    public EffectModifier executeOnStop;
    public boolean shouldSpawnParticlesEveryNIteration = false;
    public int spawnParticlesEveryNIteration = 5;
    public boolean shouldLimitParticlesSpawnedPerIteration = true;
    public int particleLimit = 5000;
    public boolean shouldLimitParticlesEveryNIterations = false;
    public int limitParticlesEveryNIterations = 5;
    public boolean forced = false;
    protected class_3218 world;
    protected class_2394 particle;
    public EffectType type;
    protected int delay;
    protected boolean done = false;
    protected int ticks = 0;
    private class_5321<class_1937> worldRegistryKey;
    private int currentParticleCount = 0;

    public Effect(class_3218 world, EffectType type, class_2394 particle, class_243 originPos) {
        this.world = world;
        this.type = type;
        this.particle = particle;
        this.originPos = originPos;
        this.worldRegistryKey = world.method_27983();
    }

    private Effect() {
        this.worldRegistryKey = this.world.method_27983();
    }

    protected static void copy(Effect original, Effect copy) {
        if (original == null) {
            return;
        }
        copy.setIterations(original.getIterations());
        copy.setOriginPos(original.getOriginPos());
        copy.setUpdatePositions(original.isUpdatePositions());
        copy.setEntityOrigin(original.getEntityOrigin());
        copy.setOriginOffset(original.getOriginOffset());
        copy.setWorld(original.getWorld());
        copy.setParticle(original.getParticle());
        copy.setDelay(original.getDelay());
        copy.setUseEyePosAsOrigin(original.isUseEyePosAsOrigin());
        copy.setExecuteOnStop(original.getExecuteOnStop());
        copy.setShouldSpawnParticlesEveryNIteration(original.shouldSpawnParticlesEveryNIteration());
        copy.setShouldLimitParticlesEveryNIterations(original.shouldLimitParticlesEveryNIterations());
        copy.setShouldLimitParticlesSpawnedPerIteration(original.shouldLimitParticlesSpawnedPerIteration());
        copy.setLimitParticlesEveryNIterations(original.getLimitParticlesEveryNIterations());
        copy.setSpawnParticlesEveryNIteration(original.getSpawnParticlesEveryNIteration());
        copy.setParticleLimit(original.getParticleLimit());
        copy.setForced(original.isForced());
        copy.type = original.type;
        copy.done = original.done;
        copy.ticks = original.ticks;
    }

    protected void onRun() {
    }

    protected void onStop() {
        if (this.executeOnStop != null) {
            this.executeOnStop.modifyEffect(this, this.ticks);
        }
    }

    public EffectModifier getExecuteOnStop() {
        return this.executeOnStop;
    }

    public void setExecuteOnStop(EffectModifier executeOnStop) {
        this.executeOnStop = executeOnStop;
    }

    public EffectType getType() {
        return this.type;
    }

    public void updatePos() {
        if (this.entityOrigin != null) {
            if (this.originOffset == null) {
                if (this.useEyePosAsOrigin) {
                    this.originPos = this.entityOrigin.method_33571();
                    return;
                }
                this.originPos = this.entityOrigin.method_73189();
                return;
            }
            if (this.useEyePosAsOrigin) {
                this.originPos = this.entityOrigin.method_33571().method_1019(this.originOffset);
                return;
            }
            this.originPos = this.entityOrigin.method_73189().method_1019(this.originOffset);
        }
    }

    public void runFor(double seconds) {
        this.setIterations((int)(seconds * 20.0));
        this.run();
    }

    public void runFor(double seconds, EffectModifier modifier) {
        this.setIterations((int)(seconds * 20.0));
        this.run(modifier);
    }

    public void run() {
        this.run(null);
    }

    public void run(EffectModifier modifier) {
        if (this.world.method_8608()) {
            return;
        }
        this.onRun();
        if (this.type == EffectType.INSTANT) {
            return;
        }
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.done) {
                return;
            }
            if (modifier != null) {
                modifier.modifyEffect(this, this.ticks);
            }
            if (this.updatePositions) {
                this.updatePos();
            }
            if (this.type == EffectType.DELAYED) {
                ++this.ticks;
                if (this.ticks > this.delay) {
                    this.done = true;
                    this.ticks = 0;
                    this.onRun();
                }
            } else {
                ++this.ticks;
                if (this.shouldSpawnParticlesEveryNIteration && this.ticks % this.spawnParticlesEveryNIteration != 0) {
                    return;
                }
                this.onRun();
                if (this.shouldLimitParticlesEveryNIterations && this.ticks % this.limitParticlesEveryNIterations == 0) {
                    this.currentParticleCount = 0;
                } else if (this.shouldLimitParticlesSpawnedPerIteration) {
                    this.currentParticleCount = 0;
                }
                if (this.ticks > this.iterations) {
                    this.done = true;
                    this.ticks = 0;
                    this.onStop();
                }
            }
        });
    }

    public void displayParticle(class_2394 effect, class_243 pos) {
        this.displayParticle(effect, pos, class_243.field_1353);
    }

    public void displayParticle(class_243 pos, int color, float size) {
        class_2390 dustParticle = new class_2390(color, size);
        this.displayParticle((class_2394)dustParticle, pos);
    }

    public void displayParticle(class_2394 effect, class_243 pos, class_243 vel) {
        if (this.shouldLimitParticlesSpawnedPerIteration || this.shouldLimitParticlesEveryNIterations) {
            ++this.currentParticleCount;
            if (this.currentParticleCount > this.particleLimit) {
                return;
            }
        }
        this.world.method_14199(effect, this.forced, this.forced, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, vel.method_10216(), vel.method_10214(), vel.method_10215(), 0.0);
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Nullable
    public class_243 getOriginPos() {
        if (this.originPos != null) {
            if (this.originOffset == null) {
                return this.originPos;
            }
            return this.originPos.method_1019(this.originOffset);
        }
        return null;
    }

    public void setOriginPos(class_243 origin_pos) {
        this.originPos = origin_pos;
    }

    public boolean isUpdatePositions() {
        return this.updatePositions;
    }

    public void setUpdatePositions(boolean updatePositions) {
        this.updatePositions = updatePositions;
    }

    public class_1297 getEntityOrigin() {
        return this.entityOrigin;
    }

    public void setEntityOrigin(class_1297 entityOrigin) {
        this.entityOrigin = entityOrigin;
    }

    public class_243 getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(class_243 originOffset) {
        this.originOffset = originOffset;
    }

    public boolean isUseEyePosAsOrigin() {
        return this.useEyePosAsOrigin;
    }

    public void setUseEyePosAsOrigin(boolean useEyePosAsOrigin) {
        this.useEyePosAsOrigin = useEyePosAsOrigin;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public void setWorld(class_3218 world) {
        this.world = world;
    }

    public class_2394 getParticle() {
        return this.particle;
    }

    public void setParticle(class_2394 particle) {
        this.particle = particle;
    }

    public int getLimitParticlesEveryNIterations() {
        return this.limitParticlesEveryNIterations;
    }

    public void setLimitParticlesEveryNIterations(int limitParticlesEveryNIterations) {
        this.limitParticlesEveryNIterations = limitParticlesEveryNIterations;
    }

    public boolean shouldLimitParticlesEveryNIterations() {
        return this.shouldLimitParticlesEveryNIterations;
    }

    public void setShouldLimitParticlesEveryNIterations(boolean shouldLimitParticlesEveryNIterations) {
        this.shouldLimitParticlesEveryNIterations = shouldLimitParticlesEveryNIterations;
    }

    public int getParticleLimit() {
        return this.particleLimit;
    }

    public void setParticleLimit(int particleLimit) {
        this.particleLimit = particleLimit;
    }

    public int getSpawnParticlesEveryNIteration() {
        return this.spawnParticlesEveryNIteration;
    }

    public void setSpawnParticlesEveryNIteration(int spawnParticlesEveryNIteration) {
        this.spawnParticlesEveryNIteration = spawnParticlesEveryNIteration;
    }

    public boolean shouldSpawnParticlesEveryNIteration() {
        return this.shouldSpawnParticlesEveryNIteration;
    }

    public void setShouldSpawnParticlesEveryNIteration(boolean shouldSpawnParticlesEveryNIteration) {
        this.shouldSpawnParticlesEveryNIteration = shouldSpawnParticlesEveryNIteration;
    }

    public boolean shouldLimitParticlesSpawnedPerIteration() {
        return this.shouldLimitParticlesSpawnedPerIteration;
    }

    public void setShouldLimitParticlesSpawnedPerIteration(boolean shouldLimitParticlesSpawnedPerIteration) {
        this.shouldLimitParticlesSpawnedPerIteration = shouldLimitParticlesSpawnedPerIteration;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }
}

