/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.Effect;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class AnimatedBallEffect
extends Effect {
    public int particles = 150;
    public int particlesPerIteration = 10;
    public float size = 1.0f;
    public float xFactor = 1.0f;
    public float yFactor = 1.0f;
    public float zFactor = 1.0f;
    public double xRotation;
    public double yRotation;
    public double zRotation = 0.0;
    protected int step = 0;

    public AnimatedBallEffect(class_3218 world, class_2394 particle, class_243 origin, int count, int particles_per_iteration, float size, class_243 factors, class_243 rotation) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particle = particle;
        this.world = world;
        this.particles = count;
        this.size = size;
        this.particlesPerIteration = particles_per_iteration;
        this.xFactor = (float)factors.method_10216();
        this.yFactor = (float)factors.method_10214();
        this.zFactor = (float)factors.method_10215();
        this.xRotation = rotation.method_10216();
        this.yRotation = rotation.method_10214();
        this.zRotation = rotation.method_10215();
    }

    public AnimatedBallEffect(class_3218 world, class_2394 particle, class_243 origin) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particle = particle;
        this.world = world;
        this.originPos = origin;
    }

    public AnimatedBallEffect(class_3218 world, class_2394 particle, class_243 origin, int count, int particles_per_iteration, float size) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particle = particle;
        this.world = world;
        this.particles = count;
        this.size = size;
        this.particlesPerIteration = particles_per_iteration;
    }

    public AnimatedBallEffect(class_3218 world, class_2394 particle, class_243 origin, int count, int particles_per_iteration, float size, class_243 factors) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particle = particle;
        this.world = world;
        this.particles = count;
        this.size = size;
        this.particlesPerIteration = particles_per_iteration;
        this.xFactor = (float)factors.method_10216();
        this.yFactor = (float)factors.method_10214();
        this.zFactor = (float)factors.method_10215();
    }

    private AnimatedBallEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setParticles(builder.particles);
        this.setParticlesPerIteration(builder.particlesPerIteration);
        this.setSize(builder.size);
        this.setxFactor(builder.xFactor);
        this.setyFactor(builder.yFactor);
        this.setzFactor(builder.zFactor);
        this.setxRotation(builder.xRotation);
        this.setyRotation(builder.yRotation);
        this.setzRotation(builder.zRotation);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    public static void copy(AnimatedBallEffect original, AnimatedBallEffect copy) {
        Effect.copy(original, copy);
        copy.setParticles(original.getParticles());
        copy.setParticlesPerIteration(original.getParticlesPerIteration());
        copy.setSize(original.getSize());
        copy.setxFactor(original.getxFactor());
        copy.setyFactor(original.getyFactor());
        copy.setzFactor(original.getzFactor());
        copy.setxRotation(original.getxRotation());
        copy.setyRotation(original.getyRotation());
        copy.setzRotation(original.getzRotation());
    }

    @Override
    protected void onRun() {
        class_243 pos = this.getOriginPos();
        if (pos == null) {
            return;
        }
        for (int i = 0; i < this.particlesPerIteration; ++i) {
            ++this.step;
            float t = (float)(Math.PI / (double)this.particles * (double)this.step);
            float r = (float)(Math.sin(t) * (double)this.size);
            float s = (float)(Math.PI * 2 * (double)t);
            double x = (double)(this.xFactor * r) * Math.cos(s) + this.originOffset.method_10216();
            double y = (double)(this.yFactor * this.size) * Math.cos(t) + this.originOffset.method_10214();
            double z = (double)(this.zFactor * r) * Math.sin(s) + this.originOffset.method_10215();
            class_243 vector = new class_243(x, y, z);
            vector = VectorUtils.rotateVector(vector, (float)this.xRotation, (float)this.yRotation, (float)this.zRotation);
            this.displayParticle(this.particle, this.originPos.method_1019(vector));
        }
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public int getParticlesPerIteration() {
        return this.particlesPerIteration;
    }

    public void setParticlesPerIteration(int particlesPerIteration) {
        this.particlesPerIteration = particlesPerIteration;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getxFactor() {
        return this.xFactor;
    }

    public void setxFactor(float xFactor) {
        this.xFactor = xFactor;
    }

    public float getyFactor() {
        return this.yFactor;
    }

    public void setyFactor(float yFactor) {
        this.yFactor = yFactor;
    }

    public float getzFactor() {
        return this.zFactor;
    }

    public void setzFactor(float zFactor) {
        this.zFactor = zFactor;
    }

    public double getxRotation() {
        return this.xRotation;
    }

    public void setxRotation(double xRotation) {
        this.xRotation = xRotation;
    }

    public double getyRotation() {
        return this.yRotation;
    }

    public void setyRotation(double yRotation) {
        this.yRotation = yRotation;
    }

    public double getzRotation() {
        return this.zRotation;
    }

    public void setzRotation(double zRotation) {
        this.zRotation = zRotation;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private EffectModifier executeOnStop;
        private boolean useEyePosAsOrigin = false;
        private boolean forced = false;
        private int particles = 150;
        private int particlesPerIteration = 10;
        private float size = 1.0f;
        private float xFactor = 1.0f;
        private float yFactor = 1.0f;
        private float zFactor = 1.0f;
        private double xRotation;
        private double yRotation;
        private double zRotation = 0.0;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder particlesPerIteration(int particlesPerIteration) {
            this.particlesPerIteration = particlesPerIteration;
            return this;
        }

        public Builder size(float size) {
            this.size = size;
            return this;
        }

        public Builder factor(class_243 factor) {
            this.xFactor = (float)factor.method_10216();
            this.yFactor = (float)factor.method_10214();
            this.zFactor = (float)factor.method_10215();
            return this;
        }

        public Builder rotation(class_243 rotation) {
            this.xRotation = rotation.method_10216();
            this.yRotation = rotation.method_10214();
            this.zRotation = rotation.method_10215();
            return this;
        }

        public AnimatedBallEffect build() {
            return new AnimatedBallEffect(this);
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }
    }
}

