/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class AnimatedCircleEffect
extends YPREffect {
    public float xRotation;
    public float yRotation;
    public float zRotation = 0.0f;
    public double angularVelocityX = 0.015707963267948967;
    public double angularVelocityY = 0.018479956785822312;
    public double angularVelocityZ = 0.02026833970057931;
    public float radius = 0.4f;
    public double maxAngle = Math.PI * 2;
    public boolean resetCircle = false;
    public boolean enableRotation = true;
    public int particles = 20;
    public boolean wholeCircle = false;
    public float radiusGrow = 0.0f;
    protected float step = 0.0f;

    public AnimatedCircleEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch, int particles_per_circle, float radius, float radiusGrow, double maxAngle, boolean wholeCircle, boolean resetCircle, boolean enableRotation, class_243 angularVelocity, class_243 rotations) {
        super(world, EffectType.REPEATING, particle, origin);
        this.yaw = yaw;
        this.pitch = pitch;
        this.particles = particles_per_circle;
        this.radius = radius;
        this.radiusGrow = radiusGrow;
        this.maxAngle = maxAngle;
        this.wholeCircle = wholeCircle;
        this.resetCircle = resetCircle;
        this.enableRotation = enableRotation;
        this.angularVelocityX = angularVelocity.method_10216();
        this.angularVelocityY = angularVelocity.method_10214();
        this.angularVelocityZ = angularVelocity.method_10215();
        this.xRotation = (float)rotations.method_10216();
        this.yRotation = (float)rotations.method_10214();
        this.zRotation = (float)rotations.method_10215();
    }

    public AnimatedCircleEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch) {
        super(world, EffectType.REPEATING, particle, origin);
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public AnimatedCircleEffect(class_3218 world, class_2394 particle, class_243 origin) {
        super(world, EffectType.REPEATING, particle, origin);
    }

    private AnimatedCircleEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.xRotation = builder.xRotation;
        this.yRotation = builder.yRotation;
        this.zRotation = builder.zRotation;
        this.angularVelocityX = builder.angularVelocityX;
        this.angularVelocityY = builder.angularVelocityY;
        this.angularVelocityZ = builder.angularVelocityZ;
        this.setRadius(builder.radius);
        this.setMaxAngle(builder.maxAngle);
        this.setResetCircle(builder.resetCircle);
        this.setEnableRotation(builder.enableRotation);
        this.setParticles(builder.particles);
        this.setWholeCircle(builder.wholeCircle);
        this.setRadiusGrow(builder.radiusGrow);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    public static void copy(AnimatedCircleEffect original, AnimatedCircleEffect copy) {
        YPREffect.copy(original, copy);
        copy.setRadius(original.getRadius());
        copy.setMaxAngle(original.getMaxAngle());
        copy.setResetCircle(original.isResetCircle());
        copy.setEnableRotation(original.isEnableRotation());
        copy.setParticles(original.getParticles());
        copy.setWholeCircle(original.isWholeCircle());
        copy.setRadiusGrow(original.getRadiusGrow());
        copy.setRotations(new class_243((double)original.xRotation, (double)original.yRotation, (double)original.zRotation));
        copy.setAngularVelocity(new class_243(original.angularVelocityX, original.angularVelocityY, original.angularVelocityZ));
    }

    @Override
    public void onRun() {
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        if (this.radiusGrow != 0.0f) {
            this.radius += this.step * this.radiusGrow;
        }
        double inc = this.maxAngle / (double)this.particles;
        int steps = this.wholeCircle ? this.particles : 1;
        for (int i = 0; i < steps; ++i) {
            double angle = (double)this.step * inc;
            class_243 v = new class_243(Math.cos(angle) * (double)this.radius, 0.0, Math.sin(angle) * (double)this.radius);
            v = VectorUtils.rotateVector(v, this.xRotation, this.yRotation, this.zRotation);
            v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
            if (this.enableRotation) {
                v = VectorUtils.rotateVector(v, (float)(this.angularVelocityX * (double)this.step), (float)(this.angularVelocityY * (double)this.step), (float)(this.angularVelocityZ * (double)this.step));
            }
            this.displayParticle(this.particle, origin.method_1019(v));
            this.step += 1.0f;
        }
        if (this.resetCircle) {
            this.step = 0.0f;
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public double getMaxAngle() {
        return this.maxAngle;
    }

    public void setMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
    }

    public boolean isResetCircle() {
        return this.resetCircle;
    }

    public void setResetCircle(boolean resetCircle) {
        this.resetCircle = resetCircle;
    }

    public boolean isEnableRotation() {
        return this.enableRotation;
    }

    public void setEnableRotation(boolean enableRotation) {
        this.enableRotation = enableRotation;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public boolean isWholeCircle() {
        return this.wholeCircle;
    }

    public void setWholeCircle(boolean wholeCircle) {
        this.wholeCircle = wholeCircle;
    }

    public float getRadiusGrow() {
        return this.radiusGrow;
    }

    public void setRadiusGrow(float radiusGrow) {
        this.radiusGrow = radiusGrow;
    }

    public class_243 getRotations() {
        return new class_243((double)this.xRotation, (double)this.yRotation, (double)this.zRotation);
    }

    public void setRotations(class_243 rotations) {
        this.xRotation = (float)rotations.method_10216();
        this.yRotation = (float)rotations.method_10214();
        this.zRotation = (float)rotations.method_10215();
    }

    public void setAngularVelocity(class_243 angularVelocity) {
        this.angularVelocityX = angularVelocity.method_10216();
        this.angularVelocityY = angularVelocity.method_10214();
        this.angularVelocityZ = angularVelocity.method_10215();
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private EffectModifier executeOnStop;
        private float xRotation;
        private float yRotation;
        private float zRotation = 0.0f;
        private double angularVelocityX = 0.015707963267948967;
        private double angularVelocityY = 0.018479956785822312;
        private double angularVelocityZ = 0.02026833970057931;
        private float radius = 0.4f;
        private double maxAngle = Math.PI * 2;
        private boolean resetCircle = false;
        private boolean enableRotation = true;
        private int particles = 20;
        private boolean wholeCircle = false;
        private float radiusGrow = 0.0f;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR = true;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder rotations(class_243 rotation) {
            this.xRotation = (float)rotation.method_10216();
            this.yRotation = (float)rotation.method_10214();
            this.zRotation = (float)rotation.method_10215();
            return this;
        }

        public Builder angularVelocityX(double angularVelocityX) {
            this.angularVelocityX = angularVelocityX;
            return this;
        }

        public Builder angularVelocityY(double angularVelocityY) {
            this.angularVelocityY = angularVelocityY;
            return this;
        }

        public Builder angularVelocityZ(double angularVelocityZ) {
            this.angularVelocityZ = angularVelocityZ;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder maxAngle(double maxAngle) {
            this.maxAngle = maxAngle;
            return this;
        }

        public Builder resetCircle(boolean resetCircle) {
            this.resetCircle = resetCircle;
            return this;
        }

        public Builder enableRotation(boolean enableRotation) {
            this.enableRotation = enableRotation;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder wholeCircle(boolean wholeCircle) {
            this.wholeCircle = wholeCircle;
            return this;
        }

        public Builder radiusGrow(float radiusGrow) {
            this.radiusGrow = radiusGrow;
            return this;
        }

        public Builder yawOffset(float yawOffset) {
            this.yawOffset = yawOffset;
            return this;
        }

        public Builder pitchOffset(float pitchOffset) {
            this.pitchOffset = pitchOffset;
            return this;
        }

        public Builder yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder shouldUpdateYPR(boolean shouldUpdateYPR) {
            this.shouldUpdateYPR = shouldUpdateYPR;
            return this;
        }

        public AnimatedCircleEffect build() {
            return new AnimatedCircleEffect(this);
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

