/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.TargetedEffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ArcEffect
extends TargetedEffect {
    public float height = 2.0f;
    public int particles = 100;
    protected int step = 0;

    public ArcEffect(class_3218 world, class_2394 particle, class_243 origin, class_243 target, int count, float height) {
        super(world, EffectType.REPEATING, particle, origin);
        this.setTargetPos(target);
        this.particles = count;
        this.height = height;
    }

    public ArcEffect(class_3218 world, class_2394 particle, class_243 origin, class_243 target) {
        super(world, EffectType.REPEATING, particle, origin);
        this.setTargetPos(target);
    }

    private ArcEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setHeight(builder.height);
        this.setParticles(builder.particles);
        this.setTargetPos(builder.targetPos);
        this.setUpdateTargetPositions(builder.updateTargetPositions);
        this.setEntityTarget(builder.entityTarget);
        this.setTargetOffset(builder.targetOffset);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setUseEyePosAsTarget(builder.useEyePosAsTarget);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static void copy(ArcEffect original, ArcEffect copy) {
        TargetedEffect.copy(original, copy);
        copy.setHeight(original.getHeight());
        copy.setParticles(original.getParticles());
        copy.step = original.step;
    }

    public ArcEffect(class_3218 world, class_2394 particle, class_243 origin, class_243 target, int count) {
        super(world, EffectType.REPEATING, particle, origin);
        this.setTargetPos(target);
        this.particles = count;
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    @Override
    public void onRun() {
        class_243 origin = this.getOriginPos();
        class_243 target = this.getTargetPos();
        if (target == null) {
            return;
        }
        if (origin == null) {
            return;
        }
        class_243 link = target.method_1020(origin);
        float length = (float)link.method_1033();
        float pitch = (float)((double)(4.0f * this.height) / Math.pow(length, 2.0));
        for (int i = 0; i < this.particles; ++i) {
            ++this.step;
            class_243 v = new class_243(link.method_10216(), link.method_10214(), link.method_10215()).method_1029().method_1021((double)(length * (float)i / (float)this.particles));
            float x = (float)i / (float)this.particles * length - length / 2.0f;
            float y = (float)((double)(-pitch) * Math.pow(x, 2.0) + (double)this.height);
            this.displayParticle(this.particle, origin.method_1019(v).method_1031(0.0, (double)y, 0.0));
            ++this.step;
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private float height = 2.0f;
        private int particles = 100;
        private class_243 targetPos;
        private boolean updateTargetPositions = true;
        private class_1297 entityTarget;
        private class_243 targetOffset;
        private boolean useEyePosAsOrigin;
        private boolean useEyePosAsTarget;
        private EffectModifier executeOnStop;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder useEyePosAsTarget(boolean useEyePos) {
            this.useEyePosAsTarget = useEyePos;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder height(float height) {
            this.height = height;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder targetPos(class_243 targetPos) {
            this.targetPos = targetPos;
            return this;
        }

        public Builder updateTargetPositions(boolean updateTargetPositions) {
            this.updateTargetPositions = updateTargetPositions;
            return this;
        }

        public Builder entityTarget(class_1297 entityTarget) {
            this.entityTarget = entityTarget;
            return this;
        }

        public Builder targetOffset(class_243 targetOffset) {
            this.targetOffset = targetOffset;
            return this;
        }

        public ArcEffect build() {
            return new ArcEffect(this);
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

