/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import java.util.ArrayList;
import java.util.List;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.LineEffect;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.RandomUtils;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ConeEffect
extends YPREffect {
    public float lengthGrow = 0.05f;
    public double angularVelocity = 0.19634954084936207;
    public int particles = 10;
    public float radiusGrow = 0.006f;
    public int particlesCone = 180;
    public double rotation = 0.0;
    public boolean randomize = false;
    public boolean solid = false;
    public int strands = 1;
    public boolean flipped = false;
    public boolean inverted = false;
    public boolean drawCenterAxis = false;
    public boolean drawFinishPoint = false;
    public class_2394 secondaryParticle = this.particle;
    protected int step = 0;
    private boolean lineCreated = false;
    private List<class_243> positions = new ArrayList<class_243>();
    private int counter;
    boolean inversionCalculated = false;

    public ConeEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch, int particleConeSize, int particlesPerIteration, int strands_number, float lengthGrow, float radiusGrow, double angularVel, double startRotation, boolean solid, boolean random) {
        super(world, EffectType.REPEATING, particle, origin);
        this.yaw = yaw;
        this.pitch = pitch;
        this.particles = particlesPerIteration;
        this.particlesCone = particleConeSize;
        this.strands = strands_number;
        this.lengthGrow = lengthGrow;
        this.radiusGrow = radiusGrow;
        this.angularVelocity = angularVel;
        this.rotation = startRotation;
        this.solid = solid;
        this.randomize = random;
        this.setShouldUpdateYPR(true);
    }

    public ConeEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch) {
        super(world, EffectType.REPEATING, particle, origin);
        this.yaw = yaw;
        this.pitch = pitch;
        this.setShouldUpdateYPR(true);
    }

    private ConeEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setLengthGrow(builder.lengthGrow);
        this.setAngularVelocity(builder.angularVelocity);
        this.setParticles(builder.particles);
        this.setRadiusGrow(builder.radiusGrow);
        this.setParticlesCone(builder.particlesCone);
        this.setRotation(builder.rotation);
        this.setRandomize(builder.randomize);
        this.setSolid(builder.solid);
        this.setStrands(builder.strands);
        this.setFlipped(builder.flipped);
        this.setDrawCenterAxis(builder.drawCenterAxis);
        this.setDrawFinishPoint(builder.drawFinishPoint);
        this.setSecondaryParticle(builder.secondaryParticle);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setInverted(builder.inverted);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static void copy(ConeEffect original, ConeEffect copy) {
        YPREffect.copy(original, copy);
        copy.setLengthGrow(original.getLengthGrow());
        copy.setAngularVelocity(original.getAngularVelocity());
        copy.setParticles(original.getParticles());
        copy.setRadiusGrow(original.getRadiusGrow());
        copy.setParticlesCone(original.getParticlesCone());
        copy.setRotation(original.getRotation());
        copy.setRandomize(original.isRandomize());
        copy.setSolid(original.isSolid());
        copy.setStrands(original.getStrands());
        copy.setFlipped(original.isFlipped());
        copy.setInverted(original.isInverted());
        copy.setDrawCenterAxis(original.isDrawCenterAxis());
        copy.setDrawFinishPoint(original.isDrawFinishPoint());
        copy.setSecondaryParticle(original.getSecondaryParticle());
        copy.step = original.step;
        copy.lineCreated = original.lineCreated;
        copy.positions = original.positions;
        copy.counter = original.counter;
        copy.inverted = original.inverted;
    }

    public ConeEffect(class_3218 world, class_2394 particle, class_243 origin) {
        super(world, EffectType.REPEATING, particle, origin);
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    public class_243 getPredictedMaxCenterPosition() {
        float total_length = (float)this.getIterations() * this.lengthGrow;
        class_243 v = new class_243(0.0, (double)total_length, 0.0);
        v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
        return this.originPos.method_1019(v);
    }

    private void calculateAllPositions() {
        class_243 originPos = this.getOriginPos();
        if (originPos == null) {
            return;
        }
        for (int x = 0; x < this.particles; ++x) {
            if (this.step > this.particlesCone) {
                this.step = 0;
            }
            if (this.randomize && this.step == 0) {
                this.rotation = RandomUtils.getRandomAngle();
            }
            for (int y = 0; y < this.strands; ++y) {
                double angle = (double)this.step * this.angularVelocity + this.rotation + Math.PI * 2 * (double)y / (double)this.strands;
                float radius = (float)this.step * this.radiusGrow;
                if (this.solid) {
                    radius *= RandomUtils.random.nextFloat();
                }
                float length = (float)this.step * this.lengthGrow;
                class_243 v = new class_243(Math.cos(angle) * (double)radius, (double)length, Math.sin(angle) * (double)radius);
                v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
                this.positions.add(originPos.method_1019(v));
            }
            ++this.step;
        }
        this.step = 0;
        this.counter = this.positions.size();
    }

    @Override
    protected void onRun() {
        class_243 originPos = this.getOriginPos();
        if (originPos == null) {
            return;
        }
        if (this.inverted && !this.inversionCalculated) {
            this.calculateAllPositions();
            this.inversionCalculated = true;
        }
        for (int x = 0; x < this.particles; ++x) {
            if (this.step > this.particlesCone) {
                this.step = 0;
            }
            if (this.randomize && this.step == 0) {
                this.rotation = RandomUtils.getRandomAngle();
            }
            for (int y = 0; y < this.strands; ++y) {
                if (this.inverted) {
                    --this.counter;
                    if (this.counter < 0) {
                        return;
                    }
                    if (this.flipped) {
                        this.displayParticle(this.particle, this.getPredictedMaxCenterPosition().method_1019(this.positions.get(this.counter).method_1021(-1.0)));
                        continue;
                    }
                    this.displayParticle(this.particle, originPos.method_1019(this.positions.get(this.counter)));
                    continue;
                }
                double angle = (double)this.step * this.angularVelocity + this.rotation + Math.PI * 2 * (double)y / (double)this.strands;
                float radius = (float)this.step * this.radiusGrow;
                if (this.solid) {
                    radius *= RandomUtils.random.nextFloat();
                }
                float length = (float)this.step * this.lengthGrow;
                class_243 v = new class_243(Math.cos(angle) * (double)radius, (double)length, Math.sin(angle) * (double)radius);
                v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
                if (this.flipped) {
                    v = v.method_1021(-1.0);
                    this.displayParticle(this.particle, this.getPredictedMaxCenterPosition().method_1019(v));
                    continue;
                }
                this.displayParticle(this.particle, originPos.method_1019(v));
            }
            if (this.drawCenterAxis && !this.lineCreated) {
                LineEffect line = new LineEffect(this.world, this.secondaryParticle, this.getOriginPos(), this.getPredictedMaxCenterPosition(), this.particles);
                line.setIterations(this.iterations);
                line.run();
                this.lineCreated = true;
            }
            if (this.drawFinishPoint) {
                if (this.flipped) {
                    this.displayParticle(this.secondaryParticle, originPos);
                } else {
                    this.displayParticle(this.secondaryParticle, this.getPredictedMaxCenterPosition());
                }
            }
            ++this.step;
        }
    }

    public float getLengthGrow() {
        return this.lengthGrow;
    }

    public void setLengthGrow(float lengthGrow) {
        this.lengthGrow = lengthGrow;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(double angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public float getRadiusGrow() {
        return this.radiusGrow;
    }

    public void setRadiusGrow(float radiusGrow) {
        this.radiusGrow = radiusGrow;
    }

    public int getParticlesCone() {
        return this.particlesCone;
    }

    public void setParticlesCone(int particlesCone) {
        this.particlesCone = particlesCone;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean solid) {
        this.solid = solid;
    }

    public int getStrands() {
        return this.strands;
    }

    public void setStrands(int strands) {
        this.strands = strands;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isDrawCenterAxis() {
        return this.drawCenterAxis;
    }

    public void setDrawCenterAxis(boolean drawCenterAxis) {
        this.drawCenterAxis = drawCenterAxis;
    }

    public class_2394 getSecondaryParticle() {
        return this.secondaryParticle;
    }

    public void setSecondaryParticle(class_2394 secondaryParticle) {
        this.secondaryParticle = secondaryParticle;
    }

    public boolean isDrawFinishPoint() {
        return this.drawFinishPoint;
    }

    public void setDrawFinishPoint(boolean drawFinishPoint) {
        this.drawFinishPoint = drawFinishPoint;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle = class_2398.field_46911;
        private EffectModifier executeOnStop;
        private float lengthGrow = 0.05f;
        private double angularVelocity = 0.19634954084936207;
        private int particles = 10;
        private float radiusGrow = 0.006f;
        private int particlesCone = 180;
        private double rotation = 0.0;
        private boolean randomize = false;
        private boolean solid = false;
        private int strands = 1;
        private boolean flipped = false;
        private boolean inverted = false;
        private boolean drawCenterAxis = false;
        private boolean drawFinishPoint = false;
        private class_2394 secondaryParticle = this.particle;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR = true;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder lengthGrow(float lengthGrow) {
            this.lengthGrow = lengthGrow;
            return this;
        }

        public Builder angularVelocity(double angularVelocity) {
            this.angularVelocity = angularVelocity;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder radiusGrow(float radiusGrow) {
            this.radiusGrow = radiusGrow;
            return this;
        }

        public Builder particlesCone(int particlesCone) {
            this.particlesCone = particlesCone;
            return this;
        }

        public Builder rotation(double rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder randomize(boolean randomize) {
            this.randomize = randomize;
            return this;
        }

        public Builder solid(boolean solid) {
            this.solid = solid;
            return this;
        }

        public Builder strands(int strands) {
            this.strands = strands;
            return this;
        }

        public Builder flipped(boolean flipped) {
            this.flipped = flipped;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder inverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public Builder drawCenterAxis(boolean drawCenterAxis) {
            this.drawCenterAxis = drawCenterAxis;
            return this;
        }

        public Builder drawFinishPoint(boolean drawFinishPoint) {
            this.drawFinishPoint = drawFinishPoint;
            return this;
        }

        public Builder secondaryParticle(class_2394 secondaryParticle) {
            this.secondaryParticle = secondaryParticle;
            return this;
        }

        public Builder yawOffset(float yawOffset) {
            this.yawOffset = yawOffset;
            return this;
        }

        public Builder pitchOffset(float pitchOffset) {
            this.pitchOffset = pitchOffset;
            return this;
        }

        public Builder yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder shouldUpdateYPR(boolean shouldUpdateYPR) {
            this.shouldUpdateYPR = shouldUpdateYPR;
            return this;
        }

        public ConeEffect build() {
            return new ConeEffect(this);
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

