/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.ParticleAnimationLib;
import me.emafire003.dev.particleanimationlib.effects.base.TargetedEffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class CuboidEffect
extends TargetedEffect {
    public int particles;
    public double xLength = 0.0;
    public double yLength = 0.0;
    public double zLength = 0.0;
    public double padding = 0.0;
    public boolean blockSnap = false;
    private double useXLength = 0.0;
    private double useYLength = 0.0;
    private double useZLength = 0.0;
    protected class_243 minCorner;

    @Deprecated
    public CuboidEffect(@NotNull class_3218 world, @NotNull class_2394 particle, @NotNull class_243 origin, @NotNull class_243 target, int particles_per_row, double x_length, double y_length, double z_length, double padding, boolean blockSnap) {
        super(world, EffectType.REPEATING, particle, origin);
        this.targetPos = target;
        this.particles = particles_per_row;
        this.xLength = x_length;
        this.yLength = y_length;
        this.zLength = z_length;
        this.padding = padding;
        this.blockSnap = blockSnap;
    }

    public CuboidEffect(@NotNull class_3218 world, @NotNull class_2394 particle, @NotNull class_243 origin, @NotNull class_243 target, int particles_per_row, double padding, boolean blockSnap) {
        super(world, EffectType.REPEATING, particle, origin);
        this.targetPos = target;
        this.particles = particles_per_row;
        this.padding = padding;
        this.blockSnap = blockSnap;
    }

    public CuboidEffect(@NotNull class_3218 world, @NotNull class_2394 particle, @NotNull class_243 origin, int particles_per_row, double x_length, double y_length, double z_length, double padding, boolean blockSnap) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles_per_row;
        this.xLength = x_length;
        this.yLength = y_length;
        this.zLength = z_length;
        this.padding = padding;
        this.blockSnap = blockSnap;
    }

    public CuboidEffect(@NotNull class_3218 world, @NotNull class_2394 particle, @NotNull class_243 origin, int particles_per_row, double x_length, double y_length, double z_length) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles_per_row;
        this.xLength = x_length;
        this.yLength = y_length;
        this.zLength = z_length;
    }

    public CuboidEffect(@NotNull class_3218 world, @NotNull class_2394 particle, @NotNull class_243 origin, @NotNull class_243 target, int particles_per_row) {
        super(world, EffectType.REPEATING, particle, origin);
        this.targetPos = target;
        this.particles = particles_per_row;
    }

    private CuboidEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.particles = builder.particles;
        this.xLength = builder.xLength;
        this.yLength = builder.yLength;
        this.zLength = builder.zLength;
        this.setPadding(builder.padding);
        this.setBlockSnap(builder.blockSnap);
        this.setTargetPos(builder.targetPos);
        this.setUpdateTargetPositions(builder.updateTargetPositions);
        this.setEntityTarget(builder.entityTarget);
        this.setTargetOffset(builder.targetOffset);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setUseEyePosAsTarget(builder.useEyePosAsTarget);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static void copy(CuboidEffect original, CuboidEffect copy) {
        TargetedEffect.copy(original, copy);
        copy.setPadding(original.getPadding());
        copy.setBlockSnap(original.isBlockSnap());
        copy.setXLength(original.getXLength());
        copy.setYLength(original.getYLength());
        copy.setZLength(original.getZLength());
        copy.setParticles(original.getParticles());
        copy.useXLength = original.useXLength;
        copy.useYLength = original.useYLength;
        copy.useZLength = original.useZLength;
        copy.minCorner = original.minCorner;
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    @Override
    protected void onRun() {
        if (this.world == null || this.world.method_8608()) {
            return;
        }
        class_243 target = this.getTargetPos();
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        if (target == null && this.xLength == 0.0 && this.yLength == 0.0 && this.zLength == 0.0) {
            return;
        }
        if (this.blockSnap) {
            if (target != null) {
                target = class_2338.method_49638((class_2374)target).method_46558();
            }
            this.minCorner = class_2338.method_49638((class_2374)origin).method_46558();
        } else {
            this.minCorner = origin;
        }
        if (this.xLength == 0.0 && this.yLength == 0.0 && this.zLength == 0.0) {
            double x = this.minCorner.method_10216();
            double y = this.minCorner.method_10214();
            double z = this.minCorner.method_10215();
            try {
                if (target.method_10216() < x) {
                    x = target.method_10216();
                }
                if (target.method_10214() < y) {
                    y = target.method_10214();
                }
                if (target.method_10215() < z) {
                    z = target.method_10215();
                }
            }
            catch (NullPointerException e) {
                ParticleAnimationLib.LOGGER.error("Error! The target position is null and the lengths are zero! Specify at least a target position or a length value!");
                e.printStackTrace();
            }
            this.minCorner = new class_243(x, y, z);
            this.useXLength = Math.abs(origin.method_10216() - target.method_10216());
            this.useYLength = Math.abs(origin.method_10214() - target.method_10214());
            this.useZLength = Math.abs(origin.method_10215() - target.method_10215());
        } else {
            this.useXLength = this.xLength;
            this.useYLength = this.yLength;
            this.useZLength = this.zLength;
        }
        double extra = this.padding * 2.0;
        if (this.blockSnap) {
            extra += 1.0;
        }
        this.useXLength += extra;
        this.useYLength += extra;
        this.useZLength += extra;
        if (this.padding != 0.0) {
            this.minCorner = this.minCorner.method_1031(-this.padding, -this.padding, -this.padding);
        }
        this.drawOutline();
    }

    private void drawOutline() {
        for (int i = 0; i < this.particles; ++i) {
            this.drawEdge(i, 0, 2, 2);
            this.drawEdge(i, 0, 1, 2);
            this.drawEdge(i, 0, 1, 1);
            this.drawEdge(i, 0, 2, 1);
            this.drawEdge(i, 2, 0, 2);
            this.drawEdge(i, 1, 0, 2);
            this.drawEdge(i, 1, 0, 1);
            this.drawEdge(i, 2, 0, 1);
            this.drawEdge(i, 2, 2, 0);
            this.drawEdge(i, 1, 2, 0);
            this.drawEdge(i, 1, 1, 0);
            this.drawEdge(i, 2, 1, 0);
        }
    }

    private void drawEdge(int i, int dx, int dy, int dz) {
        double x = dx == 0 ? this.useXLength * (double)i / (double)this.particles : this.useXLength * (double)(dx - 1);
        double y = dy == 0 ? this.useYLength * (double)i / (double)this.particles : this.useYLength * (double)(dy - 1);
        double z = dz == 0 ? this.useZLength * (double)i / (double)this.particles : this.useZLength * (double)(dz - 1);
        this.displayParticle(this.particle, this.minCorner.method_1031(x, y, z));
    }

    public double getXLength() {
        return this.xLength;
    }

    public void setXLength(double xLength) {
        this.xLength = xLength;
    }

    public double getYLength() {
        return this.yLength;
    }

    public void setYLength(double yLength) {
        this.yLength = yLength;
    }

    public double getZLength() {
        return this.zLength;
    }

    public void setZLength(double zLength) {
        this.zLength = zLength;
    }

    public double getPadding() {
        return this.padding;
    }

    public void setPadding(double padding) {
        this.padding = padding;
    }

    public boolean isBlockSnap() {
        return this.blockSnap;
    }

    public void setBlockSnap(boolean blockSnap) {
        this.blockSnap = blockSnap;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private boolean useEyePosAsTarget;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private EffectModifier executeOnStop;
        private int particles = 8;
        private double xLength = 0.0;
        private double yLength = 0.0;
        private double zLength = 0.0;
        private double padding = 0.0;
        private boolean blockSnap = false;
        private class_243 targetPos;
        private boolean updateTargetPositions = true;
        private class_1297 entityTarget;
        private class_243 targetOffset;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder useEyePosAsTarget(boolean useEyePos) {
            this.useEyePosAsTarget = useEyePos;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder xLength(double length) {
            this.xLength = length;
            return this;
        }

        public Builder yLength(double length) {
            this.yLength = length;
            return this;
        }

        public Builder zLength(double length) {
            this.zLength = length;
            return this;
        }

        public Builder xLength(class_243 lengths) {
            this.xLength = lengths.field_1352;
            this.yLength = lengths.field_1351;
            this.zLength = lengths.field_1350;
            return this;
        }

        public Builder padding(double padding) {
            this.padding = padding;
            return this;
        }

        public Builder blockSnap(boolean blockSnap) {
            this.blockSnap = blockSnap;
            return this;
        }

        public Builder targetPos(class_243 targetPos) {
            this.targetPos = targetPos;
            return this;
        }

        public Builder updateTargetPositions(boolean updateTargetPositions) {
            this.updateTargetPositions = updateTargetPositions;
            return this;
        }

        public Builder entityTarget(class_1297 entityTarget) {
            this.entityTarget = entityTarget;
            return this;
        }

        public Builder targetOffset(class_243 targetOffset) {
            this.targetOffset = targetOffset;
            return this;
        }

        public CuboidEffect build() {
            return new CuboidEffect(this);
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

