/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class DonutEffect
extends YPREffect {
    public int particlesCircle = 10;
    public int circles = 36;
    public float radiusDonut = 2.0f;
    public float radiusTube = 0.5f;
    public class_243 rotation = class_243.field_1353;
    public float radiusDonutIncrease = 0.0f;
    public float radiusTubeIncrease = 0.0f;
    public int particlesCircleIncrease = 0;
    public int circlesIncrease = 0;
    public int increaseCirclesEveryNIterations = 20;
    public int increaseParticlesCircleEveryNIterations = 20;
    private int iteration = 0;

    public DonutEffect(class_3218 world, class_2394 particle, class_243 originPos, float yaw, float pitch, int particlesCircle, int circles, float radiusDonut, float radiusTube, class_243 rotation, float radiusDonutIncrease, float radiusTubeIncrease, int particlesCircleIncrease, int increaseParticlesCircleEveryNIterations, int circlesIncrease, int increaseCirclesEveryNIterations) {
        super(world, EffectType.REPEATING, particle, originPos);
        this.yaw = yaw;
        this.pitch = pitch;
        this.particlesCircle = particlesCircle;
        this.particlesCircleIncrease = particlesCircleIncrease;
        this.circles = circles;
        this.radiusDonut = radiusDonut;
        this.radiusTube = radiusTube;
        this.rotation = rotation;
        this.radiusDonutIncrease = radiusDonutIncrease;
        this.radiusTubeIncrease = radiusTubeIncrease;
        this.circlesIncrease = circlesIncrease;
        this.increaseParticlesCircleEveryNIterations = increaseParticlesCircleEveryNIterations;
        this.increaseCirclesEveryNIterations = increaseCirclesEveryNIterations;
    }

    public DonutEffect(class_3218 world, class_2394 particle, class_243 originPos) {
        super(world, EffectType.REPEATING, particle, originPos);
    }

    public static void copy(DonutEffect original, DonutEffect copy) {
        YPREffect.copy(original, copy);
        copy.setCircles(original.getCircles());
        copy.setRadiusDonut(original.getRadiusDonut());
        copy.setRadiusTube(original.getRadiusTube());
        copy.setRadiusDonutIncrease(original.getRadiusDonutIncrease());
        copy.setRadiusTubeIncrease(original.getRadiusTubeIncrease());
        copy.setRotation(original.getRotation());
        copy.setParticlesCircle(original.getParticlesCircle());
        copy.setParticlesCircleIncrease(original.getParticlesCircleIncrease());
        copy.setIncreaseCirclesEveryNIterations(original.getIncreaseCirclesEveryNIterations());
        copy.setCirclesIncrease(original.getCirclesIncrease());
        copy.setIncreaseCirclesEveryNIterations(original.getIncreaseCirclesEveryNIterations());
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    private DonutEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setWorld(builder.world);
        this.setParticle(builder.particle);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setParticlesCircle(builder.particlesCircle);
        this.setCircles(builder.circles);
        this.setRadiusDonut(builder.radiusDonut);
        this.setRadiusTube(builder.radiusTube);
        this.setRotation(builder.rotation);
        this.setRadiusDonutIncrease(builder.radiusDonutIncrease);
        this.setRadiusTubeIncrease(builder.radiusTubeIncrease);
        this.setParticlesCircleIncrease(builder.particlesCircleIncrease);
        this.setCirclesIncrease(builder.circlesIncrease);
        this.setIncreaseCirclesEveryNIterations(builder.increaseCirclesEveryNIterations);
        this.setIncreaseParticlesCircleEveryNIterations(builder.increaseParticlesCircleEveryNIterations);
        this.setForced(builder.forced);
    }

    @Override
    public void onRun() {
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        if (this.radiusDonutIncrease != 0.0f) {
            this.radiusDonut += this.radiusDonutIncrease;
        }
        if (this.radiusTubeIncrease != 0.0f) {
            this.radiusTube += this.radiusTubeIncrease;
        }
        if ((this.increaseParticlesCircleEveryNIterations == 0 || this.iteration % this.increaseParticlesCircleEveryNIterations == 0) && this.particlesCircleIncrease != 0) {
            this.particlesCircle += this.particlesCircleIncrease;
        }
        if ((this.increaseCirclesEveryNIterations == 0 || this.iteration % this.increaseCirclesEveryNIterations == 0) && this.circlesIncrease != 0) {
            this.circles += this.circlesIncrease;
        }
        for (int i = 0; i < this.circles; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)this.circles;
            for (int j = 0; j < this.particlesCircle; ++j) {
                double phi = Math.PI * 2 * (double)j / (double)this.particlesCircle;
                double cosPhi = Math.cos(phi);
                class_243 v = new class_243(((double)this.radiusDonut + (double)this.radiusTube * cosPhi) * Math.cos(theta), ((double)this.radiusDonut + (double)this.radiusTube * cosPhi) * Math.sin(theta), (double)this.radiusTube * Math.sin(phi));
                v = VectorUtils.rotateVector(v, this.getYaw() + 90.0f, this.getPitch() + 90.0f);
                v = VectorUtils.rotateVector(v, (float)this.rotation.field_1352, (float)this.rotation.field_1351, (float)this.rotation.field_1350);
                this.displayParticle(this.particle, origin.method_1019(v));
            }
        }
        ++this.iteration;
        if (this.iterations == this.iteration) {
            this.iteration = 0;
        }
    }

    public int getParticlesCircle() {
        return this.particlesCircle;
    }

    public void setParticlesCircle(int particlesCircle) {
        this.particlesCircle = particlesCircle;
    }

    public int getCircles() {
        return this.circles;
    }

    public void setCircles(int circles) {
        this.circles = circles;
    }

    public float getRadiusTube() {
        return this.radiusTube;
    }

    public void setRadiusTube(float radiusTube) {
        this.radiusTube = radiusTube;
    }

    public float getRadiusDonut() {
        return this.radiusDonut;
    }

    public void setRadiusDonut(float radiusDonut) {
        this.radiusDonut = radiusDonut;
    }

    public class_243 getRotation() {
        return this.rotation;
    }

    public void setRotation(class_243 rotation) {
        this.rotation = rotation;
    }

    public float getRadiusDonutIncrease() {
        return this.radiusDonutIncrease;
    }

    public void setRadiusDonutIncrease(float radiusDonutIncrease) {
        this.radiusDonutIncrease = radiusDonutIncrease;
    }

    public int getParticlesCircleIncrease() {
        return this.particlesCircleIncrease;
    }

    public void setParticlesCircleIncrease(int particlesCircleIncrease) {
        this.particlesCircleIncrease = particlesCircleIncrease;
    }

    public float getRadiusTubeIncrease() {
        return this.radiusTubeIncrease;
    }

    public void setRadiusTubeIncrease(float radiusTubeIncrease) {
        this.radiusTubeIncrease = radiusTubeIncrease;
    }

    public int getCirclesIncrease() {
        return this.circlesIncrease;
    }

    public void setCirclesIncrease(int circlesIncrease) {
        this.circlesIncrease = circlesIncrease;
    }

    public int getIncreaseCirclesEveryNIterations() {
        return this.increaseCirclesEveryNIterations;
    }

    public void setIncreaseCirclesEveryNIterations(int increaseCirclesEveryNIterations) {
        this.increaseCirclesEveryNIterations = increaseCirclesEveryNIterations;
    }

    public int getIncreaseParticlesCircleEveryNIterations() {
        return this.increaseParticlesCircleEveryNIterations;
    }

    public void setIncreaseParticlesCircleEveryNIterations(int increaseParticlesCircleEveryNIterations) {
        this.increaseParticlesCircleEveryNIterations = increaseParticlesCircleEveryNIterations;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private EffectModifier executeOnStop;
        private boolean shouldSpawnParticlesEveryNIteration;
        private int spawnParticlesEveryNIteration;
        private boolean shouldLimitParticlesSpawnedPerIteration;
        private int particleLimit;
        private boolean shouldLimitParticlesEveryNIterations;
        private int limitParticlesEveryNIterations;
        private class_3218 world;
        private class_2394 particle;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR;
        public int particlesCircle = 10;
        public int circles = 36;
        public float radiusDonut = 2.0f;
        public float radiusTube = 0.5f;
        public class_243 rotation = class_243.field_1353;
        public float radiusDonutIncrease = 0.0f;
        public float radiusTubeIncrease = 0.0f;
        public int particlesCircleIncrease = 0;
        public int circlesIncrease = 0;
        public int increaseCirclesEveryNIterations = 20;
        public int increaseParticlesCircleEveryNIterations = 20;
        private boolean forced = false;

        public Builder iterations(int val) {
            this.iterations = val;
            return this;
        }

        public Builder originPos(class_243 val) {
            this.originPos = val;
            return this;
        }

        public Builder updatePositions(boolean val) {
            this.updatePositions = val;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean val) {
            this.useEyePosAsOrigin = val;
            return this;
        }

        public Builder entityOrigin(class_1297 val) {
            this.entityOrigin = val;
            return this;
        }

        public Builder originOffset(class_243 val) {
            this.originOffset = val;
            return this;
        }

        public Builder executeOnStop(EffectModifier val) {
            this.executeOnStop = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder world(class_3218 val) {
            this.world = val;
            return this;
        }

        public Builder particle(class_2394 val) {
            this.particle = val;
            return this;
        }

        public Builder yawOffset(float val) {
            this.yawOffset = val;
            return this;
        }

        public Builder pitchOffset(float val) {
            this.pitchOffset = val;
            return this;
        }

        public Builder yaw(float val) {
            this.yaw = val;
            return this;
        }

        public Builder pitch(float val) {
            this.pitch = val;
            return this;
        }

        public Builder shouldUpdateYPR(boolean val) {
            this.shouldUpdateYPR = val;
            return this;
        }

        public Builder particlesCircle(int val) {
            this.particlesCircle = val;
            return this;
        }

        public Builder circles(int val) {
            this.circles = val;
            return this;
        }

        public Builder radiusDonut(float val) {
            this.radiusDonut = val;
            return this;
        }

        public Builder radiusTube(float val) {
            this.radiusTube = val;
            return this;
        }

        public Builder rotation(class_243 val) {
            this.rotation = val;
            return this;
        }

        public Builder radiusDonutIncrease(float val) {
            this.radiusDonutIncrease = val;
            return this;
        }

        public Builder radiusTubeIncrease(float val) {
            this.radiusTubeIncrease = val;
            return this;
        }

        public Builder particlesCircleIncrease(int val) {
            this.particlesCircleIncrease = val;
            return this;
        }

        public Builder circlesIncrease(int val) {
            this.circlesIncrease = val;
            return this;
        }

        public Builder increaseCirclesEveryNIterations(int val) {
            this.increaseCirclesEveryNIterations = val;
            return this;
        }

        public Builder increaseParticlesCircleEveryNIterations(int val) {
            this.increaseParticlesCircleEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }

        public DonutEffect build() {
            return new DonutEffect(this);
        }
    }
}

