/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import java.awt.image.BufferedImage;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.ParticleAnimationLib;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import me.emafire003.dev.particleanimationlib.util.image.ImageLoadCallback;
import me.emafire003.dev.particleanimationlib.util.image.ImageUtils;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class ImageEffect
extends YPREffect {
    public String fileName;
    public boolean transparency = false;
    public int frameDelay = 5;
    public int stepX = 5;
    public int stepY = 5;
    public float scale = 0.025f;
    public float particleSize = 1.0f;
    public boolean enableRotation = true;
    public class_243 rotation = null;
    public boolean orient = false;
    public Plane plane = Plane.XYZ;
    public double angularVelocityX = 0.015707963267948967;
    public double angularVelocityY = 0.018479956785822312;
    public double angularVelocityZ = 0.02026833970057931;
    public boolean blackAndWhite = false;
    public boolean invertColors = false;
    protected BufferedImage[] images = null;
    protected int step = 0;
    protected int rotationStepCounter = 0;
    protected int stepDelay = 0;
    protected ImageLoadCallback imageLoadCallback;
    public static final String ERROR_IMAGE = "https://github.com/Emafire003/ParticleAnimationLib/blob/main/src/main/resources/data/particleanimationlib/images/error.png";
    private static final int black = 0;
    private static final int white = 0xFFFFFF;

    public ImageEffect(class_3218 world, class_243 origin, float yaw, float pitch, String fileName, boolean transparency, int frameDelay, int stepX, int stepY, float scale, float particleSize, class_243 rotation, boolean orient, boolean enableRotation, Plane plane, double angularVelocityX, double angularVelocityY, double angularVelocityZ, boolean blackAndWhite, boolean invertColors) {
        super(world, EffectType.REPEATING, null, origin);
        this.yaw = yaw;
        this.pitch = pitch;
        this.fileName = fileName;
        if (fileName != null && !fileName.isBlank()) {
            this.load(fileName);
        } else {
            ParticleAnimationLib.LOGGER.error("The file you have specified is invalid! The file path you have specified is: " + fileName);
            this.load(ERROR_IMAGE);
        }
        this.transparency = transparency;
        this.frameDelay = frameDelay;
        this.stepX = stepX;
        this.stepY = stepY;
        this.scale = scale;
        this.particleSize = particleSize;
        this.enableRotation = enableRotation;
        this.rotation = rotation;
        this.orient = orient;
        this.plane = plane;
        this.angularVelocityX = angularVelocityX;
        this.angularVelocityY = angularVelocityY;
        this.angularVelocityZ = angularVelocityZ;
        this.blackAndWhite = blackAndWhite;
        this.invertColors = invertColors;
    }

    private ImageEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, null, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setWorld(builder.world);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setTransparency(builder.transparency);
        this.setFrameDelay(builder.frameDelay);
        this.setStepX(builder.stepX);
        this.setStepY(builder.stepY);
        this.setScale(builder.scale);
        this.setParticleSize(builder.particleSize);
        this.setEnableRotation(builder.enableRotation);
        this.setRotation(builder.rotation);
        this.setOrient(builder.orient);
        this.setPlane(builder.plane);
        this.setAngularVelocityX(builder.angularVelocityX);
        this.setAngularVelocityY(builder.angularVelocityY);
        this.setAngularVelocityZ(builder.angularVelocityZ);
        this.setBlackAndWhite(builder.blackAndWhite);
        this.setInvertColors(builder.invertColors);
        this.setForced(builder.forced);
        if (builder.fileId != null) {
            this.fileName = "id:" + String.valueOf(builder.fileId);
            this.load(builder.fileId);
            return;
        }
        this.setFileName(builder.fileName);
    }

    public static void copy(ImageEffect original, ImageEffect copy) {
        YPREffect.copy(original, copy);
        copy.setFileName(original.getFileName());
        copy.setTransparency(original.isTransparency());
        copy.setFrameDelay(original.getFrameDelay());
        copy.setStepX(original.getStepX());
        copy.setStepY(original.getStepY());
        copy.setScale(original.getScale());
        copy.setParticleSize(original.getParticleSize());
        copy.setEnableRotation(original.isEnableRotation());
        copy.setRotation(original.getRotation());
        copy.setOrient(original.isOrient());
        copy.setPlane(original.getPlane());
        copy.setAngularVelocityX(original.getAngularVelocityX());
        copy.setAngularVelocityY(original.getAngularVelocityY());
        copy.setAngularVelocityZ(original.getAngularVelocityZ());
        copy.setBlackAndWhite(original.isBlackAndWhite());
        copy.setInvertColors(original.isInvertColors());
        copy.images = original.images;
        copy.step = original.step;
        copy.rotationStepCounter = original.rotationStepCounter;
        copy.stepDelay = original.stepDelay;
        copy.imageLoadCallback = original.imageLoadCallback;
    }

    public static Builder builder(class_3218 world, class_243 originPos, String fileName) {
        return new Builder().world(world).fileName(fileName).originPos(originPos);
    }

    public static Builder builder(class_3218 world, class_243 originPos, class_2960 image) {
        return new Builder().world(world).fileId(image).originPos(originPos);
    }

    public void load(String fileName) {
        this.imageLoadCallback = i -> {
            this.images = i;
            this.imageLoadCallback = null;
        };
        ImageUtils.loadImage(fileName, this.imageLoadCallback, this.getWorld().method_8503());
    }

    public void load(class_2960 fileName) {
        this.imageLoadCallback = i -> {
            this.images = i;
            this.imageLoadCallback = null;
        };
        ImageUtils.loadImage(fileName, this.imageLoadCallback, this.getWorld().method_8503());
    }

    @Override
    public void onRun() {
        BufferedImage image;
        if (this.images == null && this.fileName != null) {
            return;
        }
        if (this.images == null && this.imageLoadCallback != null) {
            return;
        }
        if (this.images == null || this.images.length == 0) {
            return;
        }
        if (this.stepDelay == this.frameDelay) {
            ++this.step;
            this.stepDelay = 0;
        }
        ++this.stepDelay;
        if (this.step >= this.images.length - 1) {
            this.step = 0;
        }
        if ((image = this.images[this.step]) == null) {
            image = this.images[0];
            this.step = 0;
        }
        class_243 origin = this.getOriginPos();
        for (int y = 0; y < image.getHeight(); y += this.stepY) {
            for (int x = 0; x < image.getWidth(); x += this.stepX) {
                class_243 v = new class_243((double)((float)image.getWidth() / 2.0f - (float)x), (double)((float)image.getHeight() / 2.0f - (float)y), 0.0).method_1021((double)this.scale);
                if (this.rotation != null) {
                    v = VectorUtils.rotateVector(v, (float)this.rotation.method_10216(), (float)this.rotation.method_10214(), (float)this.rotation.method_10215());
                }
                if (origin != null && this.orient) {
                    v = v.method_1037((float)Math.toRadians(this.getPitch()));
                    v = v.method_1024((float)Math.toRadians(this.getYaw()));
                }
                if (this.enableRotation) {
                    double rotX = 0.0;
                    double rotY = 0.0;
                    double rotZ = 0.0;
                    switch (this.plane.ordinal()) {
                        case 0: {
                            rotX = this.angularVelocityX * (double)this.rotationStepCounter;
                            break;
                        }
                        case 1: {
                            rotY = this.angularVelocityY * (double)this.rotationStepCounter;
                            break;
                        }
                        case 2: {
                            rotZ = this.angularVelocityZ * (double)this.rotationStepCounter;
                            break;
                        }
                        case 3: {
                            rotX = this.angularVelocityX * (double)this.rotationStepCounter;
                            rotY = this.angularVelocityY * (double)this.rotationStepCounter;
                            break;
                        }
                        case 4: {
                            rotX = this.angularVelocityX * (double)this.rotationStepCounter;
                            rotZ = this.angularVelocityZ * (double)this.rotationStepCounter;
                            break;
                        }
                        case 5: {
                            rotX = this.angularVelocityX * (double)this.rotationStepCounter;
                            rotY = this.angularVelocityY * (double)this.rotationStepCounter;
                            rotZ = this.angularVelocityZ * (double)this.rotationStepCounter;
                            break;
                        }
                        case 6: {
                            rotY = this.angularVelocityY * (double)this.rotationStepCounter;
                            rotZ = this.angularVelocityZ * (double)this.step;
                        }
                    }
                    v = VectorUtils.rotateVector(v, (float)rotX, (float)rotY, (float)rotZ);
                }
                int pixel = image.getRGB(x, y);
                if (this.transparency && pixel >> 24 == 0) continue;
                this.display(image, v, origin, pixel);
            }
        }
        ++this.rotationStepCounter;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (fileName != null && !fileName.isBlank()) {
            this.load(fileName);
        } else {
            ParticleAnimationLib.LOGGER.error("The file you have specified is invalid! The file path you have specified is: " + fileName);
            this.load(ERROR_IMAGE);
        }
    }

    public void setFileId(class_2960 fileId) {
        if (fileId != null) {
            this.fileName = "id:" + String.valueOf(fileId);
            this.load(fileId);
        } else {
            ParticleAnimationLib.LOGGER.error("The file you have specified is invalid! The file id you have specified is: " + String.valueOf(fileId));
            this.load(ERROR_IMAGE);
        }
    }

    public boolean isTransparency() {
        return this.transparency;
    }

    public void setTransparency(boolean transparency) {
        this.transparency = transparency;
    }

    public int getFrameDelay() {
        return this.frameDelay;
    }

    public void setFrameDelay(int frameDelay) {
        this.frameDelay = frameDelay;
    }

    public int getStepX() {
        return this.stepX;
    }

    public void setStepX(int stepX) {
        this.stepX = stepX;
    }

    public int getStepY() {
        return this.stepY;
    }

    public void setStepY(int stepY) {
        this.stepY = stepY;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getParticleSize() {
        return this.particleSize;
    }

    public void setParticleSize(float particleSize) {
        this.particleSize = particleSize;
    }

    public boolean isEnableRotation() {
        return this.enableRotation;
    }

    public void setEnableRotation(boolean enableRotation) {
        this.enableRotation = enableRotation;
    }

    public class_243 getRotation() {
        return this.rotation;
    }

    public void setRotation(class_243 rotation) {
        this.rotation = rotation;
    }

    public boolean isOrient() {
        return this.orient;
    }

    public void setOrient(boolean orient) {
        this.orient = orient;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
    }

    public double getAngularVelocityX() {
        return this.angularVelocityX;
    }

    public void setAngularVelocityX(double angularVelocityX) {
        this.angularVelocityX = angularVelocityX;
    }

    public double getAngularVelocityY() {
        return this.angularVelocityY;
    }

    public void setAngularVelocityY(double angularVelocityY) {
        this.angularVelocityY = angularVelocityY;
    }

    public double getAngularVelocityZ() {
        return this.angularVelocityZ;
    }

    public void setAngularVelocityZ(double angularVelocityZ) {
        this.angularVelocityZ = angularVelocityZ;
    }

    public boolean isBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackAndWhite = blackAndWhite;
    }

    public boolean isInvertColors() {
        return this.invertColors;
    }

    public void setInvertColors(boolean invert_colors) {
        this.invertColors = invert_colors;
    }

    protected void display(BufferedImage image, class_243 v, class_243 pos, int pixel_color) {
        if (this.blackAndWhite) {
            pixel_color = (pixel_color = Math.abs(pixel_color)) > 0x7FFFFF ? 0 : 0xFFFFFF;
        }
        if (this.invertColors) {
            pixel_color = 0xFFFFFF - pixel_color;
        }
        this.displayParticle(pos.method_1019(v), pixel_color, this.particleSize);
    }

    public static enum Plane {
        X,
        Y,
        Z,
        XY,
        XZ,
        XYZ,
        YZ;

    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private EffectModifier executeOnStop;
        private boolean shouldSpawnParticlesEveryNIteration;
        private int spawnParticlesEveryNIteration;
        private boolean shouldLimitParticlesSpawnedPerIteration;
        private int particleLimit;
        private boolean shouldLimitParticlesEveryNIterations;
        private int limitParticlesEveryNIterations;
        private class_3218 world;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR;
        private String fileName;
        private boolean transparency = false;
        private int frameDelay = 5;
        private int stepX = 5;
        private int stepY = 5;
        private float scale = 0.025f;
        private float particleSize = 1.0f;
        private boolean enableRotation = true;
        private class_243 rotation = null;
        private boolean orient = false;
        private Plane plane = Plane.XYZ;
        private double angularVelocityX = 0.015707963267948967;
        private double angularVelocityY = 0.018479956785822312;
        private double angularVelocityZ = 0.02026833970057931;
        private boolean blackAndWhite = false;
        private boolean invertColors = false;
        private class_2960 fileId;
        private boolean forced = false;

        public Builder iterations(int val) {
            this.iterations = val;
            return this;
        }

        public Builder originPos(class_243 val) {
            this.originPos = val;
            return this;
        }

        public Builder updatePositions(boolean val) {
            this.updatePositions = val;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean val) {
            this.useEyePosAsOrigin = val;
            return this;
        }

        public Builder entityOrigin(class_1297 val) {
            this.entityOrigin = val;
            return this;
        }

        public Builder originOffset(class_243 val) {
            this.originOffset = val;
            return this;
        }

        public Builder executeOnStop(EffectModifier val) {
            this.executeOnStop = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder world(class_3218 val) {
            this.world = val;
            return this;
        }

        public Builder yawOffset(float val) {
            this.yawOffset = val;
            return this;
        }

        public Builder pitchOffset(float val) {
            this.pitchOffset = val;
            return this;
        }

        public Builder yaw(float val) {
            this.yaw = val;
            return this;
        }

        public Builder pitch(float val) {
            this.pitch = val;
            return this;
        }

        public Builder shouldUpdateYPR(boolean val) {
            this.shouldUpdateYPR = val;
            return this;
        }

        public Builder fileName(String val) {
            this.fileName = val;
            return this;
        }

        public Builder fileId(class_2960 val) {
            this.fileId = val;
            return this;
        }

        public Builder transparency(boolean val) {
            this.transparency = val;
            return this;
        }

        public Builder frameDelay(int val) {
            this.frameDelay = val;
            return this;
        }

        public Builder stepX(int val) {
            this.stepX = val;
            return this;
        }

        public Builder stepY(int val) {
            this.stepY = val;
            return this;
        }

        public Builder scale(float val) {
            this.scale = val;
            return this;
        }

        public Builder particleSize(float val) {
            this.particleSize = val;
            return this;
        }

        public Builder enableRotation(boolean val) {
            this.enableRotation = val;
            return this;
        }

        public Builder rotation(class_243 val) {
            this.rotation = val;
            return this;
        }

        public Builder orient(boolean val) {
            this.orient = val;
            return this;
        }

        public Builder plane(Plane val) {
            this.plane = val;
            return this;
        }

        public Builder angularVelocityX(double val) {
            this.angularVelocityX = val;
            return this;
        }

        public Builder angularVelocityY(double val) {
            this.angularVelocityY = val;
            return this;
        }

        public Builder angularVelocityZ(double val) {
            this.angularVelocityZ = val;
            return this;
        }

        public Builder blackAndWhite(boolean val) {
            this.blackAndWhite = val;
            return this;
        }

        public Builder invertColors(boolean val) {
            this.invertColors = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }

        public ImageEffect build() {
            return new ImageEffect(this);
        }
    }
}

