/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.Effect;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.TargetedYPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class LineEffect
extends TargetedYPREffect {
    public boolean isZigZag = false;
    public int zigZags = 10;
    public class_243 zigZagOffset = new class_243(0.0, 0.1, 0.0);
    public class_243 zigZagRelativeOffset = new class_243(0.0, 0.0, 0.0);
    public int particles = 100;
    public double length = 0.0;
    public double maxLength = 0.0;
    private Effect subEffectAtEnd = null;
    protected boolean zag = false;
    protected int step = 0;

    public LineEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch, int particles, double length, boolean isZigZag, int numberOfZigZags, class_243 zigZagOffset, class_243 zigZagRelativeOffset, Effect effectAtEnd) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles;
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
        this.isZigZag = isZigZag;
        this.zigZags = numberOfZigZags;
        this.zigZagOffset = zigZagOffset;
        this.zigZagRelativeOffset = zigZagRelativeOffset;
        this.subEffectAtEnd = effectAtEnd;
    }

    public LineEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch, int particles, double length, boolean isZigZag, int numberOfZigZags, class_243 zigZagOffset, class_243 zigZagRelativeOffset) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles;
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
        this.isZigZag = isZigZag;
        this.zigZags = numberOfZigZags;
        this.zigZagOffset = zigZagOffset;
        this.zigZagRelativeOffset = zigZagRelativeOffset;
    }

    private LineEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setZigZag(builder.isZigZag);
        this.setZigZags(builder.zigZags);
        this.setZigZagOffset(builder.zigZagOffset);
        this.setZigZagRelativeOffset(builder.zigZagRelativeOffset);
        this.setParticles(builder.particles);
        this.setLength(builder.length);
        this.setMaxLength(builder.maxLength);
        this.setSubEffectAtEnd(builder.subEffectAtEnd);
        this.setTargetPos(builder.targetPos);
        this.setUpdateTargetPositions(builder.updateTargetPositions);
        this.setEntityTarget(builder.entityTarget);
        this.setTargetOffset(builder.targetOffset);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setUseEyePosAsTarget(builder.useEyePosAsTarget);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setForced(builder.forced);
    }

    public static void copy(LineEffect original, LineEffect copy) {
        TargetedYPREffect.copy(original, copy);
        copy.setZigZag(original.isZigZag());
        copy.setZigZags(original.getZigZags());
        copy.setZigZagOffset(original.getZigZagOffset());
        copy.setZigZagRelativeOffset(original.getZigZagRelativeOffset());
        copy.setParticles(original.getParticles());
        copy.setLength(original.getLength());
        copy.setMaxLength(original.getMaxLength());
        copy.setSubEffectAtEnd(original.getSubEffectAtEnd());
        copy.zag = original.zag;
        copy.step = original.step;
    }

    public LineEffect(class_3218 world, class_2394 particle, class_243 origin, float yaw, float pitch, int particles, double length) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles;
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public LineEffect(class_3218 world, class_2394 particle, class_243 origin, class_243 target, int particles, int maxLength, boolean isZigZag, int numberOfZigZags, class_243 zigZagOffset, class_243 zigZagRelativeOffset) {
        super(world, EffectType.REPEATING, particle, origin);
        this.targetPos = target;
        this.particles = particles;
        this.isZigZag = isZigZag;
        this.maxLength = maxLength;
        this.zigZags = numberOfZigZags;
        this.zigZagOffset = zigZagOffset;
        this.zigZagRelativeOffset = zigZagRelativeOffset;
    }

    public LineEffect(class_3218 world, class_2394 particle, class_243 origin, class_243 target, int particles) {
        super(world, EffectType.REPEATING, particle, origin);
        this.targetPos = target;
        this.particles = particles;
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    @Override
    public void onRun() {
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        class_243 target = this.length > 0.0 ? origin.method_1019(this.getDirection().method_1029().method_1021(this.length)) : this.getTargetPos();
        int amount = this.particles;
        if (this.isZigZag) {
            amount /= this.zigZags;
        }
        if (target == null) {
            return;
        }
        class_243 link = target.method_1020(origin);
        float length = (float)link.method_1033();
        if (this.maxLength > 0.0) {
            length = (float)Math.min((double)length, this.maxLength);
        }
        link = link.method_1029();
        float ratio = length / (float)this.particles;
        class_243 v = link.method_1021((double)ratio);
        class_243 loc = origin.method_1020(v);
        for (int i = 0; i < this.particles; ++i) {
            if (this.isZigZag) {
                class_243 rel = VectorUtils.rotateVector(this.zigZagRelativeOffset, this.getYaw(), this.getPitch());
                if (this.zag) {
                    loc = loc.method_1019(rel);
                    loc = loc.method_1019(this.zigZagOffset);
                } else {
                    loc = loc.method_1020(rel);
                    loc = loc.method_1020(this.zigZagOffset);
                }
            }
            if (this.step >= amount) {
                this.zag = !this.zag;
                this.step = 0;
            }
            ++this.step;
            loc = loc.method_1019(v);
            this.displayParticle(this.particle, loc);
        }
        if (this.subEffectAtEnd != null) {
            this.subEffectAtEnd.setOriginPos(loc);
            this.subEffectAtEnd.run();
        }
    }

    public boolean isZigZag() {
        return this.isZigZag;
    }

    public void setZigZag(boolean zigZag) {
        this.isZigZag = zigZag;
    }

    public int getZigZags() {
        return this.zigZags;
    }

    public void setZigZags(int zigZags) {
        this.zigZags = zigZags;
    }

    public class_243 getZigZagOffset() {
        return this.zigZagOffset;
    }

    public void setZigZagOffset(class_243 zigZagOffset) {
        this.zigZagOffset = zigZagOffset;
    }

    public class_243 getZigZagRelativeOffset() {
        return this.zigZagRelativeOffset;
    }

    public void setZigZagRelativeOffset(class_243 zigZagRelativeOffset) {
        this.zigZagRelativeOffset = zigZagRelativeOffset;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(double maxLength) {
        this.maxLength = maxLength;
    }

    public Effect getSubEffectAtEnd() {
        return this.subEffectAtEnd;
    }

    public void setSubEffectAtEnd(Effect subEffectAtEnd) {
        this.subEffectAtEnd = subEffectAtEnd;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private EffectModifier executeOnStop;
        private boolean isZigZag = false;
        private int zigZags = 10;
        private class_243 zigZagOffset = new class_243(0.0, 0.1, 0.0);
        private class_243 zigZagRelativeOffset = new class_243(0.0, 0.0, 0.0);
        private int particles = 100;
        private double length = 0.0;
        private double maxLength = 0.0;
        private Effect subEffectAtEnd = null;
        private class_243 targetPos;
        private boolean updateTargetPositions = true;
        private class_1297 entityTarget;
        private class_243 targetOffset;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR = true;
        private boolean useEyePosAsOrigin;
        private boolean useEyePosAsTarget;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder useEyePosAsTarget(boolean useEyePos) {
            this.useEyePosAsTarget = useEyePos;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder isZigZag(boolean isZigZag) {
            this.isZigZag = isZigZag;
            return this;
        }

        public Builder zigZags(int zigZags) {
            this.zigZags = zigZags;
            return this;
        }

        public Builder zigZagOffset(class_243 zigZagOffset) {
            this.zigZagOffset = zigZagOffset;
            return this;
        }

        public Builder zigZagRelativeOffset(class_243 zigZagRelativeOffset) {
            this.zigZagRelativeOffset = zigZagRelativeOffset;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder length(double length) {
            this.length = length;
            return this;
        }

        public Builder maxLength(double maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder subEffectAtEnd(Effect subEffectAtEnd) {
            this.subEffectAtEnd = subEffectAtEnd;
            return this;
        }

        public Builder targetPos(class_243 targetPos) {
            this.targetPos = targetPos;
            return this;
        }

        public Builder updateTargetPositions(boolean updateTargetPositions) {
            this.updateTargetPositions = updateTargetPositions;
            return this;
        }

        public Builder entityTarget(class_1297 entityTarget) {
            this.entityTarget = entityTarget;
            return this;
        }

        public Builder targetOffset(class_243 targetOffset) {
            this.targetOffset = targetOffset;
            return this;
        }

        public Builder yawOffset(float yawOffset) {
            this.yawOffset = yawOffset;
            return this;
        }

        public Builder pitchOffset(float pitchOffset) {
            this.pitchOffset = pitchOffset;
            return this;
        }

        public Builder yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder shouldUpdateYPR(boolean shouldUpdateYPR) {
            this.shouldUpdateYPR = shouldUpdateYPR;
            return this;
        }

        public LineEffect build() {
            return new LineEffect(this);
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

