/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import me.emafire003.dev.particleanimationlib.Effect;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.RandomUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class SphereEffect
extends Effect {
    public double radius = 0.6;
    public int particles = 50;
    public double radiusIncrease = 0.0;
    public int particleIncrease = 0;
    public boolean halfSphere = false;
    public boolean invertHalfSphere = false;

    public SphereEffect(class_3218 world, class_2394 particle, class_243 origin, int particles, double radius, double radiusIncrease, int particleIncrease, boolean half_sphere, boolean invert_half_sphere) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles;
        this.radius = radius;
        this.radiusIncrease = radiusIncrease;
        this.particleIncrease = particleIncrease;
        this.halfSphere = half_sphere;
        this.invertHalfSphere = invert_half_sphere;
    }

    private SphereEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setRadius(builder.radius);
        this.particles = builder.particles;
        this.setRadiusIncrease(builder.radiusIncrease);
        this.setParticleIncrease(builder.particleIncrease);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setHalfSphere(builder.halfSphere);
        this.setInvertedHalfSphere(builder.invertHalfSphere);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static void copy(SphereEffect original, SphereEffect copy) {
        Effect.copy(original, copy);
        copy.setRadius(original.getRadius());
        copy.setRadiusIncrease(original.getRadiusIncrease());
        copy.setParticleIncrease(original.getParticleIncrease());
        copy.setParticles(original.getParticles());
        copy.setHalfSphere(original.isHalfSphere());
        copy.setInvertedHalfSphere(original.isInvertHalSphere());
    }

    public SphereEffect(class_3218 world, class_2394 particle, class_243 origin) {
        super(world, EffectType.REPEATING, particle, origin);
    }

    public SphereEffect(class_3218 world, class_2394 particle, class_243 origin, int particles, double radius) {
        super(world, EffectType.REPEATING, particle, origin);
        this.particles = particles;
        this.radius = radius;
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    @Override
    public void onRun() {
        class_243 origin;
        if (this.radiusIncrease != 0.0) {
            this.radius += this.radiusIncrease;
        }
        if (this.particleIncrease != 0) {
            this.particles += this.particleIncrease;
        }
        if ((origin = this.getOriginPos()) == null) {
            return;
        }
        for (int i = 0; i < this.particles; ++i) {
            class_243 vector = RandomUtils.getRandomVector().method_1021(this.radius);
            if (this.halfSphere) {
                vector = this.invertHalfSphere ? new class_243(vector.method_10216(), Math.abs(vector.method_10214()) * -1.0, vector.method_10215()) : new class_243(vector.method_10216(), Math.abs(vector.method_10214()), vector.method_10215());
            }
            this.displayParticle(this.particle, origin.method_1019(vector));
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadiusIncrease() {
        return this.radiusIncrease;
    }

    public void setRadiusIncrease(double radiusIncrease) {
        this.radiusIncrease = radiusIncrease;
    }

    public int getParticleIncrease() {
        return this.particleIncrease;
    }

    public void setParticleIncrease(int particleIncrease) {
        this.particleIncrease = particleIncrease;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public boolean isHalfSphere() {
        return this.halfSphere;
    }

    public void setHalfSphere(boolean half_sphere) {
        this.halfSphere = half_sphere;
    }

    public boolean isInvertHalSphere() {
        return this.invertHalfSphere;
    }

    public void setInvertedHalfSphere(boolean invert_half_sphere) {
        this.invertHalfSphere = invert_half_sphere;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private boolean useEyePosAsOrigin;
        private EffectModifier executeOnStop;
        private double radius = 0.6;
        private int particles = 50;
        private double radiusIncrease = 0.0;
        private int particleIncrease = 0;
        public boolean halfSphere = false;
        public boolean invertHalfSphere = false;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder radius(double radius) {
            this.radius = radius;
            return this;
        }

        public Builder particles(int particles) {
            this.particles = particles;
            return this;
        }

        public Builder radiusIncrease(double radiusIncrease) {
            this.radiusIncrease = radiusIncrease;
            return this;
        }

        public Builder particleIncrease(int particleIncrease) {
            this.particleIncrease = particleIncrease;
            return this;
        }

        public Builder halfSphere(boolean halfSphere) {
            this.halfSphere = halfSphere;
            return this;
        }

        public Builder invertHalfSphere(boolean invertHalfSphere) {
            this.invertHalfSphere = invertHalfSphere;
            return this;
        }

        public SphereEffect build() {
            return new SphereEffect(this);
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

