/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.Objects;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.StringParser;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class TextEffect
extends YPREffect {
    public String text = "Text";
    public boolean invert = false;
    public int stepX = 1;
    public int stepY = 1;
    public float size = 0.2f;
    public boolean realtime = false;
    private static final Font DEFAULT_FONT = new Font("Sans Serif", 0, 10);
    public Font font = DEFAULT_FONT;
    protected BufferedImage image = null;
    private String lastParsedText = null;
    private Font lastParsedFont = null;

    public TextEffect(class_3218 world, class_2394 particle, class_243 originPos, float yaw, float pitch, String text, boolean invert, int stepX, int stepY, float size, boolean realtime, Font font) {
        super(world, EffectType.REPEATING, particle, originPos);
        this.yaw = yaw;
        this.pitch = pitch;
        this.text = text;
        this.invert = invert;
        this.stepX = stepX;
        this.stepY = stepY;
        this.size = size;
        this.realtime = realtime;
        this.font = font;
    }

    private TextEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setText(builder.text);
        this.setInvert(builder.invert);
        this.setStepX(builder.stepX);
        this.setStepY(builder.stepY);
        this.setSize(builder.size);
        this.setRealtime(builder.realtime);
        this.setFont(builder.font);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setForced(builder.forced);
    }

    public static void copy(TextEffect original, TextEffect copy) {
        YPREffect.copy(original, copy);
        copy.setFont(original.getFont());
        copy.setText(original.getText());
        copy.setSize(original.getSize());
        copy.setStepX(original.getStepX());
        copy.setStepY(original.getStepY());
        copy.setInvert(original.isInvert());
        copy.setRealtime(original.isRealtime());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public int getStepX() {
        return this.stepX;
    }

    public void setStepX(int stepX) {
        this.stepX = stepX;
    }

    public int getStepY() {
        return this.stepY;
    }

    public void setStepY(int stepY) {
        this.stepY = stepY;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public boolean isRealtime() {
        return this.realtime;
    }

    public void setRealtime(boolean realtime) {
        this.realtime = realtime;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void onRun() {
        if (this.font == null) {
            return;
        }
        class_243 origin_pos = this.getOriginPos();
        if (origin_pos == null) {
            return;
        }
        try {
            if (this.image == null || this.shouldRecalculateImage()) {
                this.lastParsedText = this.text;
                this.lastParsedFont = this.font;
                this.image = StringParser.stringToBufferedImage(this.lastParsedFont, this.lastParsedText);
            }
            for (int y = 0; y < this.image.getHeight(); y += this.stepY) {
                for (int x = 0; x < this.image.getWidth(); x += this.stepX) {
                    int color = this.image.getRGB(x, y);
                    if (!this.invert && Color.black.getRGB() != color || this.invert && Color.black.getRGB() == color) continue;
                    class_243 v = new class_243((double)((float)this.image.getWidth() / 2.0f - (float)x), (double)((float)this.image.getHeight() / 2.0f - (float)y), 0.0).method_1021((double)this.size);
                    v = VectorUtils.rotateVector(v, this.getYaw() - 90.0f, 0.0f);
                    this.displayParticle(this.particle, this.originPos.method_1019(v));
                }
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private boolean shouldRecalculateImage() {
        if (!this.realtime) {
            return false;
        }
        return !Objects.equals(this.lastParsedText, this.text) || !Objects.equals(this.lastParsedFont, this.font);
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private boolean useEyePosAsOrigin;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR;
        public String text = "Text";
        public boolean invert = false;
        public int stepX = 1;
        public int stepY = 1;
        public float size = 0.2f;
        public boolean realtime = false;
        public Font font = DEFAULT_FONT;
        private EffectModifier executeOnStop;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int val) {
            this.iterations = val;
            return this;
        }

        public Builder originPos(class_243 val) {
            this.originPos = val;
            return this;
        }

        public Builder updatePositions(boolean val) {
            this.updatePositions = val;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean val) {
            this.useEyePosAsOrigin = val;
            return this;
        }

        public Builder entityOrigin(class_1297 val) {
            this.entityOrigin = val;
            return this;
        }

        public Builder originOffset(class_243 val) {
            this.originOffset = val;
            return this;
        }

        public Builder world(class_3218 val) {
            this.world = val;
            return this;
        }

        public Builder particle(class_2394 val) {
            this.particle = val;
            return this;
        }

        public Builder yawOffset(float val) {
            this.yawOffset = val;
            return this;
        }

        public Builder pitchOffset(float val) {
            this.pitchOffset = val;
            return this;
        }

        public Builder yaw(float val) {
            this.yaw = val;
            return this;
        }

        public Builder pitch(float val) {
            this.pitch = val;
            return this;
        }

        public Builder shouldUpdateYPR(boolean val) {
            this.shouldUpdateYPR = val;
            return this;
        }

        public Builder text(String val) {
            this.text = val;
            return this;
        }

        public Builder invert(boolean val) {
            this.invert = val;
            return this;
        }

        public Builder stepX(int val) {
            this.stepX = val;
            return this;
        }

        public Builder stepY(int val) {
            this.stepY = val;
            return this;
        }

        public Builder size(float val) {
            this.size = val;
            return this;
        }

        public Builder realtime(boolean val) {
            this.realtime = val;
            return this;
        }

        public Builder font(Font val) {
            this.font = val;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public TextEffect build() {
            return new TextEffect(this);
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

