/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.effects;

import java.util.ArrayList;
import java.util.List;
import me.emafire003.dev.particleanimationlib.EffectType;
import me.emafire003.dev.particleanimationlib.effects.base.YPREffect;
import me.emafire003.dev.particleanimationlib.util.EffectModifier;
import me.emafire003.dev.particleanimationlib.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class VortexEffect
extends YPREffect {
    public float radius = 2.0f;
    public float radiusGrow = 0.0f;
    public float startRange = 0.0f;
    public float lengthGrow = 0.05f;
    public double radials = 0.19634954084936207;
    public int circles = 3;
    public int helixes = 4;
    public boolean flipped;
    public boolean inverted = false;
    protected int step = 0;
    private boolean inversionCalculated = false;
    private List<class_243> positions = new ArrayList<class_243>();
    private int counter;

    public VortexEffect(@NotNull class_3218 world, class_2394 particle, class_243 originPos, float yaw, float pitch, float radius, float radiusGrow, float startRange, float lengthGrow, double radials_per_iteration, int circles, int helixes) {
        super(world, EffectType.REPEATING, particle, originPos);
        this.type = EffectType.REPEATING;
        this.world = world;
        this.particle = particle;
        this.yaw = yaw;
        this.pitch = pitch;
        this.radius = radius;
        this.radiusGrow = radiusGrow;
        this.startRange = startRange;
        this.lengthGrow = lengthGrow;
        this.radials = radials_per_iteration;
        this.circles = circles;
        this.helixes = helixes;
    }

    public VortexEffect(@NotNull class_3218 world, class_2394 particle, class_243 originPos, float yaw, float pitch, float radius, float lengthGrow, int circles, int helixes) {
        super(world, EffectType.REPEATING, particle, originPos);
        this.type = EffectType.REPEATING;
        this.world = world;
        this.particle = particle;
        this.yaw = yaw;
        this.pitch = pitch;
        this.radius = radius;
        this.lengthGrow = lengthGrow;
        this.circles = circles;
        this.helixes = helixes;
    }

    public VortexEffect(@NotNull class_3218 world, class_2394 particle, class_243 originPos, float yaw, float pitch) {
        super(world, EffectType.REPEATING, particle, originPos);
        this.type = EffectType.REPEATING;
        this.world = world;
        this.particle = particle;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    private VortexEffect(Builder builder) {
        super(builder.world, EffectType.REPEATING, builder.particle, builder.originPos);
        this.setIterations(builder.iterations);
        this.setOriginPos(builder.originPos);
        this.setUpdatePositions(builder.updatePositions);
        this.setEntityOrigin(builder.entityOrigin);
        this.setOriginOffset(builder.originOffset);
        this.world = builder.world;
        this.particle = builder.particle;
        this.setRadius(builder.radius);
        this.setRadiusGrow(builder.radiusGrow);
        this.setStartRange(builder.startRange);
        this.setLengthGrow(builder.lengthGrow);
        this.setRadials(builder.radials);
        this.setCircles(builder.circles);
        this.setHelixes(builder.helixes);
        this.setFlipped(builder.flipped);
        this.setYawOffset(builder.yawOffset);
        this.setPitchOffset(builder.pitchOffset);
        this.setYaw(builder.yaw);
        this.setPitch(builder.pitch);
        this.setShouldUpdateYPR(builder.shouldUpdateYPR);
        this.setInverted(builder.inverted);
        this.setUseEyePosAsOrigin(builder.useEyePosAsOrigin);
        this.setExecuteOnStop(builder.executeOnStop);
        this.setShouldLimitParticlesEveryNIterations(builder.shouldLimitParticlesEveryNIterations);
        this.setLimitParticlesEveryNIterations(builder.limitParticlesEveryNIterations);
        this.setParticleLimit(builder.particleLimit);
        this.setShouldLimitParticlesSpawnedPerIteration(builder.shouldLimitParticlesSpawnedPerIteration);
        this.setSpawnParticlesEveryNIteration(builder.spawnParticlesEveryNIteration);
        this.setShouldSpawnParticlesEveryNIteration(builder.shouldSpawnParticlesEveryNIteration);
        this.setForced(builder.forced);
    }

    public static Builder builder(class_3218 world, class_2394 particle, class_243 originPos) {
        return new Builder().world(world).particle(particle).originPos(originPos);
    }

    public class_243 getPredictedMaxCenterPosition() {
        float total_length = (float)this.getIterations() * this.lengthGrow * (float)this.circles;
        class_243 v = new class_243(0.0, (double)total_length, 0.0);
        v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
        return this.originPos.method_1019(v);
    }

    private void calculateAllPositions() {
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        for (int x = 0; x < this.circles; ++x) {
            for (int i = 0; i < this.helixes; ++i) {
                double angle = (double)this.step * this.radials + Math.PI * 2 * (double)i / (double)this.helixes;
                class_243 v = new class_243(Math.cos(angle) * (double)(this.radius + (float)this.step * this.radiusGrow), (double)(this.startRange + (float)this.step * this.lengthGrow), Math.sin(angle) * (double)(this.radius + (float)this.step * this.radiusGrow));
                v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
                this.positions.add(v);
            }
            ++this.step;
        }
        this.counter = this.positions.size();
        this.step = 0;
    }

    @Override
    protected void onRun() {
        class_243 origin = this.getOriginPos();
        if (origin == null) {
            return;
        }
        if (this.inverted && !this.inversionCalculated) {
            this.calculateAllPositions();
            this.inversionCalculated = true;
        }
        for (int x = 0; x < this.circles; ++x) {
            for (int i = 0; i < this.helixes; ++i) {
                if (this.inverted) {
                    --this.counter;
                    if (this.counter < 0) {
                        return;
                    }
                    if (this.flipped) {
                        this.displayParticle(this.particle, this.getPredictedMaxCenterPosition().method_1019(this.positions.get(this.counter).method_1021(-1.0)));
                        continue;
                    }
                    this.displayParticle(this.particle, origin.method_1019(this.positions.get(this.counter)));
                    continue;
                }
                double angle = (double)this.step * this.radials + Math.PI * 2 * (double)i / (double)this.helixes;
                class_243 v = new class_243(Math.cos(angle) * (double)(this.radius + (float)this.step * this.radiusGrow), (double)(this.startRange + (float)this.step * this.lengthGrow), Math.sin(angle) * (double)(this.radius + (float)this.step * this.radiusGrow));
                v = VectorUtils.rotateVector(v, this.getYaw(), this.getPitch() + 90.0f);
                if (this.flipped) {
                    v = v.method_1021(-1.0);
                    this.displayParticle(this.particle, this.getPredictedMaxCenterPosition().method_1019(v));
                    continue;
                }
                this.displayParticle(this.particle, origin.method_1019(v));
            }
            ++this.step;
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadiusGrow() {
        return this.radiusGrow;
    }

    public static void copy(VortexEffect original, VortexEffect copy) {
        YPREffect.copy(original, copy);
        copy.setRadius(original.getRadius());
        copy.setRadiusGrow(original.getRadiusGrow());
        copy.setStartRange(original.getStartRange());
        copy.setLengthGrow(original.getLengthGrow());
        copy.setRadials(original.getRadials());
        copy.setCircles(original.getCircles());
        copy.setHelixes(original.getHelixes());
        copy.setFlipped(original.isFlipped());
        copy.setInverted(original.isInverted());
        copy.step = original.step;
        copy.inversionCalculated = original.inversionCalculated;
        copy.positions = original.positions;
        copy.counter = original.counter;
    }

    public void setRadiusGrow(float radiusGrow) {
        this.radiusGrow = radiusGrow;
    }

    public float getStartRange() {
        return this.startRange;
    }

    public void setStartRange(float startRange) {
        this.startRange = startRange;
    }

    public float getLengthGrow() {
        return this.lengthGrow;
    }

    public void setLengthGrow(float lengthGrow) {
        this.lengthGrow = lengthGrow;
    }

    public double getRadials() {
        return this.radials;
    }

    public void setRadials(double radials) {
        this.radials = radials;
    }

    public int getCircles() {
        return this.circles;
    }

    public void setCircles(int circles) {
        this.circles = circles;
    }

    public int getHelixes() {
        return this.helixes;
    }

    public void setHelixes(int helixes) {
        this.helixes = helixes;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public static final class Builder {
        private int iterations;
        private class_243 originPos;
        private boolean updatePositions;
        private class_1297 entityOrigin;
        private class_243 originOffset;
        private class_3218 world;
        private class_2394 particle;
        private EffectModifier executeOnStop;
        private float radius = 2.0f;
        private float radiusGrow = 0.0f;
        private float startRange = 0.0f;
        private float lengthGrow = 0.05f;
        private double radials = 0.19634954084936207;
        private int circles = 3;
        private int helixes = 4;
        private boolean flipped = false;
        public boolean inverted = false;
        private float yawOffset;
        private float pitchOffset;
        private float yaw;
        private float pitch;
        private boolean shouldUpdateYPR = true;
        private boolean useEyePosAsOrigin = false;
        private boolean shouldSpawnParticlesEveryNIteration = false;
        private int spawnParticlesEveryNIteration = 5;
        private boolean shouldLimitParticlesSpawnedPerIteration = true;
        private int particleLimit = 5000;
        private boolean shouldLimitParticlesEveryNIterations = false;
        private int limitParticlesEveryNIterations = 5;
        private boolean forced = false;

        private Builder() {
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder originPos(class_243 originPos) {
            this.originPos = originPos;
            return this;
        }

        public Builder updatePositions(boolean updatePositions) {
            this.updatePositions = updatePositions;
            return this;
        }

        public Builder entityOrigin(class_1297 entityOrigin) {
            this.entityOrigin = entityOrigin;
            return this;
        }

        public Builder originOffset(class_243 originOffset) {
            this.originOffset = originOffset;
            return this;
        }

        public Builder executeOnStop(EffectModifier executeOnStop) {
            this.executeOnStop = executeOnStop;
            return this;
        }

        public Builder useEyePosAsOrigin(boolean useEyePos) {
            this.useEyePosAsOrigin = useEyePos;
            return this;
        }

        public Builder world(class_3218 world) {
            this.world = world;
            return this;
        }

        public Builder particle(class_2394 particle) {
            this.particle = particle;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder radiusGrow(float radiusGrow) {
            this.radiusGrow = radiusGrow;
            return this;
        }

        public Builder startRange(float startRange) {
            this.startRange = startRange;
            return this;
        }

        public Builder lengthGrow(float lengthGrow) {
            this.lengthGrow = lengthGrow;
            return this;
        }

        public Builder radials(double radials) {
            this.radials = radials;
            return this;
        }

        public Builder circles(int circles) {
            this.circles = circles;
            return this;
        }

        public Builder helixes(int helixes) {
            this.helixes = helixes;
            return this;
        }

        public Builder flipped(boolean flipped) {
            this.flipped = flipped;
            return this;
        }

        public Builder inverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public Builder yawOffset(float yawOffset) {
            this.yawOffset = yawOffset;
            return this;
        }

        public Builder pitchOffset(float pitchOffset) {
            this.pitchOffset = pitchOffset;
            return this;
        }

        public Builder yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder shouldUpdateYPR(boolean shouldUpdateYPR) {
            this.shouldUpdateYPR = shouldUpdateYPR;
            return this;
        }

        public VortexEffect build() {
            return new VortexEffect(this);
        }

        public Builder shouldLimitParticlesEveryNIterations(boolean val) {
            this.shouldLimitParticlesEveryNIterations = val;
            return this;
        }

        public Builder limitParticlesEveryNIterations(int val) {
            this.limitParticlesEveryNIterations = val;
            return this;
        }

        public Builder particleLimit(int val) {
            this.particleLimit = val;
            return this;
        }

        public Builder shouldLimitParticlesSpawnedPerIteration(boolean val) {
            this.shouldLimitParticlesSpawnedPerIteration = val;
            return this;
        }

        public Builder spawnParticlesEveryNIteration(int val) {
            this.spawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder shouldSpawnParticlesEveryNIteration(boolean val) {
            this.shouldSpawnParticlesEveryNIteration = val;
            return this;
        }

        public Builder forced(boolean forced) {
            this.forced = forced;
            return this;
        }
    }
}

