/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.util.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import me.emafire003.dev.particleanimationlib.ParticleAnimationLib;
import me.emafire003.dev.particleanimationlib.util.image.ImageLoadCallback;
import me.emafire003.dev.particleanimationlib.util.image.ImageUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;

public class ImageLoadTask {
    private static final int REQUEST_TIMEOUT = 30000;
    private static final int BUFFER_SIZE = 10240;
    private static boolean dirsMade = false;
    private final String fileName;
    private final ImageLoadCallback callback;
    private final MinecraftServer server;

    public ImageLoadTask(String filePath, ImageLoadCallback callback, MinecraftServer server) {
        this.fileName = filePath;
        this.callback = callback;
        this.server = server;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.fileName.startsWith("id:")) {
            id = class_2960.method_60654((String)this.fileName.replaceFirst("id:", ""));
            resourceOptional = this.server.method_34864().method_14486(id);
            if (resourceOptional.isEmpty()) {
                ParticleAnimationLib.LOGGER.error("Error! Can't find image from the id: " + String.valueOf(id));
                return;
            }
            imageResource = (class_3298)resourceOptional.get();
            try {
                if (this.fileName.endsWith(".gif")) {
                    reader = ImageIO.getImageReadersBySuffix("GIF").next();
                    in = ImageIO.createImageInputStream(imageResource.method_14482());
                    reader.setInput(in);
                    numImages = reader.getNumImages(true);
                    images = new BufferedImage[numImages];
                    for (i = 0; i < numImages - 1; ++i) {
                        images[i] = reader.read(i);
                    }
                } else {
                    images = new BufferedImage[]{ImageIO.read(imageResource.method_14482())};
                }
                imageResource.method_43039().close();
                imageResource.method_14482().close();
                this.callback.loaded(images);
                return;
            }
            catch (Exception e) {
                ParticleAnimationLib.LOGGER.error("There was an error while trying to read from a file Identifier!");
                e.printStackTrace();
            }
        }
        if (this.fileName.startsWith("http")) {
            try {
                cacheFolder = ImageUtils.getImageCacheFolder();
                if (cacheFolder == null) {
                    ParticleAnimationLib.LOGGER.warn("Can't load from URL because no cache folder has been set by the owning plugin: " + this.fileName);
                    this.callback.loaded(new BufferedImage[0]);
                    return;
                }
                if (!ImageLoadTask.dirsMade) {
                    ImageLoadTask.dirsMade = true;
                    if (!cacheFolder.exists() && !cacheFolder.mkdirs()) {
                        ParticleAnimationLib.LOGGER.error("Could not create cache folder: " + cacheFolder.getAbsolutePath());
                    }
                }
                if ((imageFile = new File(cacheFolder, cacheFileName = URLEncoder.encode(this.fileName, StandardCharsets.UTF_8))).exists()) ** GOTO lbl62
                imageUrl = new URL(this.fileName);
                conn = (HttpURLConnection)imageUrl.openConnection();
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(30000);
                conn.setInstanceFollowRedirects(true);
                in = conn.getInputStream();
                out = new FileOutputStream(imageFile);
                buffer = new byte[10240];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.close();
            }
            catch (Exception ex) {
                ParticleAnimationLib.LOGGER.error("Failed to load file " + this.fileName, (Throwable)ex);
                this.callback.loaded(new BufferedImage[0]);
                return;
            }
        } else if (!this.fileName.startsWith(File.pathSeparator)) {
            imageFile = new File(ParticleAnimationLib.DEFAULT_CHACE_PATH.toFile(), this.fileName);
            if (!imageFile.exists()) {
                imageFile = new File(this.fileName);
            }
        } else {
            imageFile = new File(this.fileName);
        }
lbl62:
        // 4 sources

        if (!imageFile.exists()) {
            ParticleAnimationLib.LOGGER.warn("Failed to find file " + this.fileName);
            images = new BufferedImage[]{};
            this.callback.loaded(images);
            return;
        }
        try {
            if (this.fileName.endsWith(".gif")) {
                reader = ImageIO.getImageReadersBySuffix("GIF").next();
                in = ImageIO.createImageInputStream(imageFile);
                reader.setInput(in);
                numImages = reader.getNumImages(true);
                images = new BufferedImage[numImages];
                for (i = 0; i < numImages - 1; ++i) {
                    images[i] = reader.read(i);
                }
            } else {
                images = new BufferedImage[]{ImageIO.read(imageFile)};
            }
        }
        catch (Exception ex) {
            ParticleAnimationLib.LOGGER.warn("Failed to load file " + this.fileName, (Throwable)ex);
            images = new BufferedImage[]{};
        }
        this.callback.loaded(images);
    }
}

