/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.particleanimationlib.util.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import me.emafire003.dev.particleanimationlib.ParticleAnimationLib;
import me.emafire003.dev.particleanimationlib.util.image.ImageLoadCallback;
import me.emafire003.dev.particleanimationlib.util.image.ImageLoadTask;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class ImageUtils {
    private static File imageCacheFolder;
    private static Map<String, BufferedImage[]> imageCache;

    public static void setImageCacheFolder(File folder) {
        imageCacheFolder = folder;
    }

    public static File getImageCacheFolder() {
        if (imageCacheFolder == null) {
            return ParticleAnimationLib.DEFAULT_CHACE_PATH.toFile();
        }
        return imageCacheFolder;
    }

    private static void startTask(String fileName, ImageLoadCallback callback, MinecraftServer server) {
        ImageLoadTask imageLoadTask = new ImageLoadTask(fileName, images -> {
            imageCache.put(fileName, images);
            callback.loaded(images);
        }, server);
        imageLoadTask.run();
    }

    private static void startTask(class_2960 fileName, ImageLoadCallback callback, MinecraftServer server) {
        ImageLoadTask imageLoadTask = new ImageLoadTask("id:" + fileName.toString(), images -> {
            imageCache.put("id:" + String.valueOf(fileName), images);
            callback.loaded(images);
        }, server);
        imageLoadTask.run();
    }

    public static void loadImage(String fileName, ImageLoadCallback callback, MinecraftServer server) {
        BufferedImage[] images;
        if (imageCache == null) {
            imageCache = new HashMap<String, BufferedImage[]>();
            ImageUtils.startTask(fileName, callback, server);
        }
        if ((images = imageCache.get(fileName)) != null) {
            callback.loaded(images);
        } else {
            ImageUtils.startTask(fileName, callback, server);
        }
    }

    public static void loadImage(class_2960 fileName, ImageLoadCallback callback, MinecraftServer server) {
        BufferedImage[] images;
        if (imageCache == null) {
            imageCache = new HashMap<String, BufferedImage[]>();
            ImageUtils.startTask(fileName, callback, server);
        }
        if ((images = imageCache.get("id:" + String.valueOf(fileName))) != null && images.length > 0) {
            callback.loaded(images);
        } else {
            ImageUtils.startTask(fileName, callback, server);
        }
    }

    static {
        imageCache = new HashMap<String, BufferedImage[]>();
    }
}

