/*
 * Decompiled with CFR 0.152.
 */
package io.github.yo56789.mcdiscwbhk;

import io.github.yo56789.mcdiscwbhk.WebhookHandler;
import io.github.yo56789.mcdiscwbhk.config.Config;
import io.github.yo56789.mcdiscwbhk.data.Colors;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements DedicatedServerModInitializer {
    public static final String MODID = "mcdiscwbhk";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mcdiscwbhk");

    public void onInitializeServer() {
        Config.init();
        if (Config.EVENT_SERVER_STARTING_ENABLED) {
            ServerLifecycleEvents.SERVER_STARTING.register(server -> {
                String data = WebhookHandler.assembleMessage(Config.EVENT_SERVER_STARTING, Config.SERVER_NAME, Colors.DARK_GREEN.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
        if (Config.EVENT_SERVER_STARTED_ENABLED) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                String data = WebhookHandler.assembleMessage(Config.EVENT_SERVER_STARTED, Config.SERVER_NAME, Colors.GREEN.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
        if (Config.EVENT_SERVER_STOPPING_ENABLED) {
            ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
                String data = WebhookHandler.assembleMessage(Config.EVENT_SERVER_STOPPING, Config.SERVER_NAME, Colors.DARK_RED.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
        if (Config.EVENT_SERVER_STOPPED_ENABLED) {
            ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
                String data = WebhookHandler.assembleMessage(Config.EVENT_SERVER_STOPPED, Config.SERVER_NAME, Colors.RED.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
        if (Config.EVENT_PLAYER_JOIN_ENABLED) {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                String data = WebhookHandler.assembleMessage(String.format(Config.EVENT_PLAYER_JOIN, handler.method_32311().method_5477().method_10851()), Config.SERVER_NAME, Colors.GREEN.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
        if (Config.EVENT_PLAYER_LEAVE_ENABLED) {
            ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
                String data = WebhookHandler.assembleMessage(String.format(Config.EVENT_PLAYER_LEAVE, handler.method_32311().method_5477().method_10851()), Config.SERVER_NAME, Colors.RED.colorCode);
                WebhookHandler.post(Config.WEBHOOK_URI, data);
            });
        }
    }
}

