/*
 * Decompiled with CFR 0.152.
 */
package io.github.yo56789.mcdiscwbhk.config;

import io.github.yo56789.mcdiscwbhk.Main;
import io.github.yo56789.mcdiscwbhk.config.SimpleConfig;

public class Config {
    static SimpleConfig config = SimpleConfig.of("mcdiscwbhk").provider(name -> "# Discord webhook URI\n# How to get a webhook: https://support.discord.com/hc/en-us/articles/228383668-Intro-to-Webhooks\nwebhook-uri=\n\n# Server name\n# Can be set to anything, and shows for server-related events\nserver-webhook-name=Server\n\n# User avatar provider\n# Replace the part where the UUID is located with %s\nuser-avatar-url=https://mc-heads.net/avatar/%s\n\n# Webhook mode\n# Options: \"message\", \"embed\" or \"list\"\n# \"message\" sends messages with the bot using the persons mc username. \"embed\" sends everything in embeds. \"list\" sends messages like a list.\nwebhook-mode=message\n\n# Format for sending messages in \"list\" mode\n# First %s is username Second %s is message content\n# Default: %s > %s\nlist-message-format=**%s** > %s\n\n# Events\n# Leaving blank will cause event to be disabled\n\n# Player Message\nevent-player-message-enabled=true\n\n# Server starting\nevent-server-starting-enabled=false\nevent-server-starting-message=Server Starting!\n\n# Server started\nevent-server-started-enabled=true\nevent-server-started-message=Server Started!\n\n# Server stopping\nevent-server-stopping-enabled=false\nevent-server-stopping-message=Server Stopping!\n\n# Server stopped\nevent-server-stopped-enabled=true\nevent-server-stopped-message=Server Stopped!\n\n# Player join\n# %s = username of player\nevent-player-join-enabled=true\nevent-player-join-message=%s joined!\n\n# Player leave\n# %s = username of player\nevent-player-leave-enabled=true\nevent-player-leave-message=%s left!").request();
    public static final String WEBHOOK_URI = config.getOrDefault("webhook-uri", "");
    public static final String SERVER_NAME = config.getOrDefault("server-webhook-name", "Server");
    public static final String USER_AVATAR_URL = config.getOrDefault("user-avatar-url", "https://mc-heads.net/avatar/%s");
    public static final String WEBHOOK_MODE = Config.verifyWebhookMode();
    public static final String CLASSIC_MESSAGE_FORMAT = config.getOrDefault("list-message-format", "%s > %s");
    public static final boolean EVENT_PLAYER_MESSAGE_ENABLED = config.getOrDefault("event-player-message-enabled", true);
    public static final boolean EVENT_SERVER_STARTING_ENABLED = config.getOrDefault("event-server-starting-enabled", false);
    public static final String EVENT_SERVER_STARTING = config.getOrDefault("event-server-starting-message", "Server Starting!");
    public static final boolean EVENT_SERVER_STARTED_ENABLED = config.getOrDefault("event-server-started-enabled", true);
    public static final String EVENT_SERVER_STARTED = config.getOrDefault("event-server-started-message", "Server Started!");
    public static final boolean EVENT_SERVER_STOPPING_ENABLED = config.getOrDefault("event-server-stopping-enabled", false);
    public static final String EVENT_SERVER_STOPPING = config.getOrDefault("event-server-stopping-message", "Server Stopping!");
    public static final boolean EVENT_SERVER_STOPPED_ENABLED = config.getOrDefault("event-server-stopped-enabled", true);
    public static final String EVENT_SERVER_STOPPED = config.getOrDefault("event-server-stopped-message", "Server Stopped!");
    public static final boolean EVENT_PLAYER_JOIN_ENABLED = config.getOrDefault("event-player-join-enabled", true);
    public static final String EVENT_PLAYER_JOIN = config.getOrDefault("event-player-join-message", "%s joined!");
    public static final boolean EVENT_PLAYER_LEAVE_ENABLED = config.getOrDefault("event-player-leave-enabled", true);
    public static final String EVENT_PLAYER_LEAVE = config.getOrDefault("event-player-leave-message", "%s left!");

    public static void init() {
        Main.LOGGER.info("Webhook URL: " + (!WEBHOOK_URI.isEmpty() ? WEBHOOK_URI.substring(0, 35).concat("***************************************************") : ""));
        Main.LOGGER.info("Launched in " + WEBHOOK_MODE + " mode");
    }

    private static String verifyWebhookMode() {
        String mode = config.getOrDefault("webhook-mode", "message");
        if (mode.equalsIgnoreCase("message") || mode.equalsIgnoreCase("embed") || mode.equalsIgnoreCase("list")) {
            return mode;
        }
        return "message";
    }
}

