/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections;

import dev.booky.cloudcore.config.ConfigurateLoader;
import dev.booky.cloudprotections.config.ProtectionAreaSerializer;
import dev.booky.cloudprotections.config.ProtectionRegionSerializer;
import dev.booky.cloudprotections.region.ProtectionFlag;
import dev.booky.cloudprotections.region.ProtectionRegion;
import dev.booky.cloudprotections.region.area.IProtectionArea;
import io.leangen.geantyref.TypeToken;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class ProtectionsManager {
    private static final Component PREFIX = ((TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"C", (TextColor)TextColor.color((int)4683263)))).append((Component)Component.text((String)"l", (TextColor)TextColor.color((int)5010687)))).append((Component)Component.text((String)"o", (TextColor)TextColor.color((int)5338111)))).append((Component)Component.text((String)"u", (TextColor)TextColor.color((int)5665535)))).append((Component)Component.text((String)"d", (TextColor)TextColor.color((int)5992959)))).append((Component)Component.text((String)"P", (TextColor)TextColor.color((int)0x5F6FFF)))).append((Component)Component.text((String)"r", (TextColor)TextColor.color((int)6582015)))).append((Component)Component.text((String)"o", (TextColor)TextColor.color((int)6909439)))).append((Component)Component.text((String)"t", (TextColor)TextColor.color((int)7236863)))).append((Component)Component.text((String)"e", (TextColor)TextColor.color((int)7564287)))).append((Component)Component.text((String)"c", (TextColor)TextColor.color((int)7891711)))).append((Component)Component.text((String)"t", (TextColor)TextColor.color((int)8219135)))).append((Component)Component.text((String)"i", (TextColor)TextColor.color((int)8546559)))).append((Component)Component.text((String)"o", (TextColor)TextColor.color((int)0x8666FF)))).append((Component)Component.text((String)"n", (TextColor)TextColor.color((int)9135615)))).append((Component)Component.text((String)"s", (TextColor)TextColor.color((int)9463039)))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY))).build()).compact();
    private static final TypeToken<List<ProtectionRegion>> REGIONS_TOKEN = new TypeToken<List<ProtectionRegion>>(){};
    private static final ConfigurateLoader<?, ?> CONFIG_LOADER = ConfigurateLoader.yamlLoader().withAllDefaultSerializers().withSerializers(builder -> builder.register(ProtectionRegion.class, (TypeSerializer)ProtectionRegionSerializer.INSTANCE).register(IProtectionArea.class, (TypeSerializer)ProtectionAreaSerializer.INSTANCE)).build();
    private final Plugin plugin;
    private final Path regionsPath;
    private final Map<String, ProtectionRegion> regions = new LinkedHashMap<String, ProtectionRegion>();

    public ProtectionsManager(Plugin plugin) {
        this.plugin = plugin;
        this.regionsPath = plugin.getDataFolder().toPath().resolve("regions.yml");
    }

    public void reloadRegions() {
        List regions = (List)CONFIG_LOADER.loadObject(this.regionsPath, REGIONS_TOKEN, List::of);
        this.replaceRegions(regions);
    }

    public void saveRegions() {
        CONFIG_LOADER.saveObject(this.regionsPath, List.copyOf(this.regions.values()), REGIONS_TOKEN);
    }

    public synchronized void updateRegions(Consumer<Map<String, ProtectionRegion>> consumer) {
        HashMap<String, ProtectionRegion> mutRegions = new HashMap<String, ProtectionRegion>(this.regions);
        consumer.accept(mutRegions);
        this.replaceRegions(mutRegions.values());
        this.saveRegions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceRegions(Collection<ProtectionRegion> regions) {
        ArrayList<ProtectionRegion> regionList = new ArrayList<ProtectionRegion>(regions);
        regionList.sort(Comparator.comparingInt(ProtectionRegion::getPriority).reversed());
        Map<String, ProtectionRegion> map = this.regions;
        synchronized (map) {
            this.regions.clear();
            for (ProtectionRegion region : regionList) {
                this.regions.put(region.getId(), region);
            }
        }
    }

    public final boolean isProtected(Location location, ProtectionFlag flag, @Nullable Player player) {
        return this.isProtected(location.getBlock(), flag, player);
    }

    public final boolean isProtected(Block block, ProtectionFlag flag, @Nullable Player player) {
        if (player != null && player.getGameMode() == GameMode.CREATIVE) {
            return false;
        }
        for (ProtectionRegion region : this.getRegions()) {
            if (!region.check(block, flag)) continue;
            return player == null || !region.isExcluded(player);
        }
        return false;
    }

    @Nullable
    public ProtectionRegion getRegion(String id) {
        return this.regions.get(id);
    }

    public Set<String> getRegionIds() {
        return Collections.unmodifiableSet(this.regions.keySet());
    }

    public Collection<ProtectionRegion> getRegions() {
        return Collections.unmodifiableCollection(this.regions.values());
    }

    public Component getPrefix() {
        return PREFIX;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

