/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.commands;

import dev.booky.cloudcore.util.BlockBBox;
import dev.booky.cloudprotections.ProtectionsManager;
import dev.booky.cloudprotections.region.ProtectionFlag;
import dev.booky.cloudprotections.region.ProtectionRegion;
import dev.booky.cloudprotections.region.area.BoxProtectionArea;
import dev.booky.cloudprotections.region.area.IProtectionArea;
import dev.booky.cloudprotections.region.area.SphericalProtectionArea;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIPaper;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CustomArgument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.ListArgument;
import dev.jorel.commandapi.arguments.ListArgumentBuilder;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.arguments.WorldArgument;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.CommandArguments;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.Position;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public final class ProtectionsCommand {
    private final ProtectionsManager manager;

    private ProtectionsCommand(ProtectionsManager manager) {
        this.manager = manager;
    }

    public static void create(ProtectionsManager manager) {
        ProtectionsCommand command = new ProtectionsCommand(manager);
        command.unregister();
        command.register();
    }

    private WrapperCommandSyntaxException fail(Component message) {
        return CommandAPIPaper.failWithAdventureComponent((ComponentLike)this.failMsg(message));
    }

    private void fail(CommandSender sender, Component message) {
        sender.sendMessage(this.failMsg(message));
    }

    private Component failMsg(Component message) {
        return this.manager.getPrefix().append(message.colorIfAbsent((TextColor)NamedTextColor.RED));
    }

    private void success(CommandSender sender, Component message) {
        sender.sendMessage(this.successMsg(message));
    }

    private Component successMsg(Component message) {
        return this.manager.getPrefix().append(message.colorIfAbsent((TextColor)NamedTextColor.YELLOW));
    }

    private void unregister() {
        CommandAPI.unregister((String)"cloudprotections");
        CommandAPI.unregister((String)"cprotections");
        CommandAPI.unregister((String)"cprots");
    }

    private void register() {
        Function<BiPredicate, ListArgument> flagsListArg = filter -> new ListArgumentBuilder("flags").withList(info -> Arrays.stream(ProtectionFlag.values()).filter(flag -> filter.test(info, flag)).toList()).withMapper(flag -> flag.name().toLowerCase(Locale.ROOT)).buildGreedy();
        Supplier<Argument> regionArgument = () -> (Argument)new CustomArgument((Argument)new StringArgument("region"), info -> {
            ProtectionRegion region = this.manager.getRegion((String)info.currentInput());
            if (region != null) {
                return region;
            }
            throw CustomArgument.CustomArgumentException.fromAdventureComponent((ComponentLike)this.failMsg((Component)Component.translatable((String)"protections.command.invalid-region", (ComponentLike[])new ComponentLike[]{Component.text((String)((String)info.currentInput()), (TextColor)NamedTextColor.WHITE)})));
        }).replaceSuggestions(ArgumentSuggestions.strings(info -> (String[])this.manager.getRegionIds().toArray(String[]::new)));
        BiPredicate<SuggestionInfo, ProtectionFlag> flagRemoveFilter = (info, flag) -> {
            ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)info.previousArgs().getUnchecked("region"));
            return region.hasFlag((ProtectionFlag)((Object)flag));
        };
        BiPredicate<SuggestionInfo, ProtectionFlag> flagAddFilter = flagRemoveFilter.negate();
        LiteralArgument createArgument = new LiteralArgument("create");
        for (AreaType areaType : AreaType.values()) {
            createArgument.then(new LiteralArgument(areaType.name().toLowerCase(Locale.ROOT)).then(new StringArgument("id").then(areaType.provideArgs(this))));
        }
        ((CommandTree)((CommandTree)((CommandTree)((CommandTree)((CommandTree)new CommandTree("cloudprotections").withPermission("cloudprotections.command")).withAliases(new String[]{"cprotections", "cprots"})).then((AbstractArgumentTree)createArgument.withPermission("cloudprotections.command.create"))).then((AbstractArgumentTree)((Argument)new LiteralArgument("list").withPermission("cloudprotections.command.list")).executesNative(this::listRegions))).then(new LiteralArgument("modify").then(((Argument)((Argument)((Argument)((Argument)regionArgument.get().then((AbstractArgumentTree)((Argument)new LiteralArgument("delete").withPermission("cloudprotections.command.delete")).executesNative(this::deleteRegion))).then(((Argument)new LiteralArgument("rename").withPermission("cloudprotections.command.rename")).then((AbstractArgumentTree)new StringArgument("id").executesNative(this::renameRegion)))).then(((Argument)((Argument)((Argument)((Argument)new LiteralArgument("flags").withPermission("cloudprotections.command.flags")).executesNative(this::listRegionFlags)).then(((Argument)new LiteralArgument("add").withPermission("cloudprotections.command.flags.add")).then((AbstractArgumentTree)flagsListArg.apply(flagAddFilter).executesNative(this::addRegionFlag)))).then(((Argument)new LiteralArgument("remove").withPermission("cloudprotections.command.flags.remove")).then((AbstractArgumentTree)flagsListArg.apply(flagRemoveFilter).executesNative(this::removeRegionFlag)))).then((AbstractArgumentTree)new LiteralArgument("list").executesNative(this::listRegionFlags)))).then(((Argument)((Argument)((Argument)((Argument)new LiteralArgument("exclusions").withPermission("cloudprotections.command.exclusions")).executesNative(this::listRegionExclusions)).then(((Argument)new LiteralArgument("add").withPermission("cloudprotections.command.exclusions.add")).then((AbstractArgumentTree)new GreedyStringArgument("uuid").executesNative(this::addRegionExclusion)))).then(((Argument)new LiteralArgument("remove").withPermission("cloudprotections.command.exclusions.remove")).then((AbstractArgumentTree)new GreedyStringArgument("uuid").executesNative(this::removeRegionExclusion)))).then((AbstractArgumentTree)new LiteralArgument("list").executesNative(this::listRegionExclusions)))).then(((Argument)((Argument)new LiteralArgument("priority").withPermission("cloudprotections.command.priority")).executesNative(this::showRegionPriority)).then((AbstractArgumentTree)((Argument)new IntegerArgument("priority").withPermission("cloudprotections.command.priority.update")).executesNative(this::updateRegionPriority)))))).register();
    }

    private void createRegion(NativeProxyCommandSender sender, CommandArguments args, AreaType areaType) throws WrapperCommandSyntaxException {
        String id = Objects.requireNonNull((String)args.getUnchecked("id"));
        if (this.manager.getRegion(id) != null) {
            throw this.fail((Component)Component.translatable((String)"protections.command.create.already-exists", (ComponentLike[])new ComponentLike[]{Component.text((String)id, (TextColor)NamedTextColor.WHITE)}));
        }
        IProtectionArea area = areaType.create(sender, args);
        ProtectionRegion region = new ProtectionRegion(id, area, EnumSet.allOf(ProtectionFlag.class));
        this.manager.updateRegions(regions -> regions.putIfAbsent(id, region));
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.create.success", (ComponentLike[])new ComponentLike[]{Component.text((String)id, (TextColor)NamedTextColor.WHITE)}));
    }

    private void deleteRegion(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        throw this.fail((Component)Component.translatable((String)"protections.command.delete.confirmation-required", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE), Component.translatable((String)"protections.command.delete.confirmation-button").clickEvent(ClickEvent.callback(clicker -> {
            if (clicker != sender.getCaller()) {
                return;
            }
            if (this.manager.getRegion(region.getId()) != region) {
                this.fail((CommandSender)sender, (Component)Component.translatable((String)"protections.command.delete.invalid-region", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
                return;
            }
            this.manager.updateRegions(regions -> regions.remove(region.getId(), region));
            this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.delete.success", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }))}));
    }

    private void renameRegion(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        String newId = Objects.requireNonNull((String)args.getUnchecked("id"));
        ProtectionRegion newRegion = new ProtectionRegion(newId, region.getArea(), region.getFlags());
        if (this.manager.getRegion(newId) != null) {
            throw this.fail((Component)Component.translatable((String)"protections.command.rename.already-exists", (ComponentLike[])new ComponentLike[]{Component.text((String)newId, (TextColor)NamedTextColor.WHITE)}));
        }
        this.manager.updateRegions(regions -> {
            regions.remove(region.getId());
            regions.put(newId, newRegion);
        });
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.rename.success", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE), Component.text((String)newId, (TextColor)NamedTextColor.WHITE)}));
    }

    private void listRegions(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        Collection<ProtectionRegion> regions = this.manager.getRegions();
        if (regions.isEmpty()) {
            throw this.fail((Component)Component.translatable((String)"protections.command.list.none"));
        }
        TranslatableComponent.Builder msg = Component.translatable().key("protections.command.list.header").arguments(new ComponentLike[]{Component.text((int)regions.size(), (TextColor)NamedTextColor.WHITE)});
        for (ProtectionRegion region : regions) {
            AreaType areaType = AreaType.get(region.getArea());
            Component description = areaType.getDescription(region.getArea());
            Location centerLocation = region.getArea().getCenterLocation();
            msg.appendNewline().appendSpace();
            msg.append(Component.translatable((String)"protections.command.list.entry", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE), description, Component.text((int)region.getFlags().size(), (TextColor)NamedTextColor.WHITE)}).clickEvent(ClickEvent.callback(clicker -> {
                if (clicker == sender.getCaller() && clicker instanceof Entity) {
                    Entity entity = (Entity)clicker;
                    entity.teleportAsync(centerLocation, PlayerTeleportEvent.TeleportCause.COMMAND);
                }
            }, opts -> opts.uses(-1).lifetime((TemporalAmount)Duration.ofMinutes(10L)))));
        }
        this.success((CommandSender)sender, (Component)msg.build());
    }

    private void addRegionFlag(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        List flags = Objects.requireNonNull((List)args.getUnchecked("flags"));
        flags.removeIf(region::hasFlag);
        if (flags.isEmpty()) {
            throw this.fail((Component)Component.translatable((String)"protections.command.flags.add.nothing-changed", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        TranslatableComponent.Builder msg = Component.translatable().key(flags.size() == 1 ? "protections.command.flags.add.success.singular" : "protections.command.flags.add.success.plural").arguments(new ComponentLike[]{Component.text((int)flags.size(), (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)});
        for (ProtectionFlag flag : flags) {
            region.addFlag(flag);
            if (msg.children().isEmpty()) {
                msg.appendSpace();
            } else {
                msg.append((Component)Component.text((String)", "));
            }
            msg.append(flag.getName().colorIfAbsent((TextColor)NamedTextColor.WHITE));
        }
        this.manager.saveRegions();
        this.success((CommandSender)sender, (Component)msg.build());
    }

    private void removeRegionFlag(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        List flags = Objects.requireNonNull((List)args.getUnchecked("flags"));
        flags.removeIf(Predicate.not(region::hasFlag));
        if (flags.isEmpty()) {
            throw this.fail((Component)Component.translatable((String)"protections.command.flags.remove.nothing-changed", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        TranslatableComponent.Builder msg = Component.translatable().key(flags.size() == 1 ? "protections.command.flags.remove.success.singular" : "protections.command.flags.remove.success.plural").arguments(new ComponentLike[]{Component.text((int)flags.size(), (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)});
        for (ProtectionFlag flag : flags) {
            region.removeFlag(flag);
            if (msg.children().isEmpty()) {
                msg.appendSpace();
            } else {
                msg.append((Component)Component.text((String)", "));
            }
            msg.append(flag.getName().colorIfAbsent((TextColor)NamedTextColor.WHITE));
        }
        this.manager.saveRegions();
        this.success((CommandSender)sender, (Component)msg.build());
    }

    private void listRegionFlags(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        Set<ProtectionFlag> flags = Set.copyOf(region.getFlags());
        if (flags.isEmpty()) {
            throw this.fail((Component)Component.translatable((String)"protections.command.flags.list.none", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        TranslatableComponent.Builder msg = Component.translatable().key(flags.size() == 1 ? "protections.command.flags.list.info.singular" : "protections.command.flags.list.info.plural").arguments(new ComponentLike[]{Component.text((int)flags.size(), (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)});
        for (ProtectionFlag flag : flags) {
            if (msg.children().isEmpty()) {
                msg.appendSpace();
            } else {
                msg.append((Component)Component.text((String)", "));
            }
            msg.append(flag.getName().colorIfAbsent((TextColor)NamedTextColor.WHITE));
        }
        this.success((CommandSender)sender, (Component)msg.build());
    }

    private void addRegionExclusion(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        UUID uuid;
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        if (!region.addExclusion(uuid = args.getOptionalUnchecked("uuid").map(UUID::fromString).orElseThrow())) {
            throw this.fail((Component)Component.translatable((String)"protections.command.exclusions.add.nothing-changed", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        this.manager.saveRegions();
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.exclusions.add.success", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE), Component.text((String)uuid.toString(), (TextColor)NamedTextColor.WHITE)}));
    }

    private void removeRegionExclusion(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        UUID uuid;
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        if (!region.removeExclusion(uuid = args.getOptionalUnchecked("uuid").map(UUID::fromString).orElseThrow())) {
            throw this.fail((Component)Component.translatable((String)"protections.command.exclusions.remove.nothing-changed", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        this.manager.saveRegions();
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.exclusions.remove.success", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE), Component.text((String)uuid.toString(), (TextColor)NamedTextColor.WHITE)}));
    }

    private void listRegionExclusions(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        Set<UUID> exclusions = Set.copyOf(region.getExcludedPlayerIds());
        if (exclusions.isEmpty()) {
            throw this.fail((Component)Component.translatable((String)"protections.command.exclusions.list.none", (ComponentLike[])new ComponentLike[]{Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        TranslatableComponent.Builder msg = Component.translatable().key(exclusions.size() == 1 ? "protections.command.exclusions.list.info.singular" : "protections.command.exclusions.list.info.plural").arguments(new ComponentLike[]{Component.text((int)exclusions.size(), (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)});
        for (UUID exclusion : exclusions) {
            msg.appendNewline();
            msg.append((Component)Component.text((String)" - "));
            msg.append((Component)Component.text((String)exclusion.toString(), (TextColor)NamedTextColor.WHITE));
        }
        this.success((CommandSender)sender, (Component)msg.build());
    }

    private void showRegionPriority(NativeProxyCommandSender sender, CommandArguments args) {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.priority.info", (ComponentLike[])new ComponentLike[]{Component.text((int)region.getPriority(), (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
    }

    private void updateRegionPriority(NativeProxyCommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        ProtectionRegion region = Objects.requireNonNull((ProtectionRegion)args.getUnchecked("region"));
        int newPriority = Objects.requireNonNull((Integer)args.getUnchecked("priority"));
        if (region.getPriority() == newPriority) {
            throw this.fail((Component)Component.translatable((String)"protections.command.priority.already-set", (ComponentLike[])new ComponentLike[]{Component.text((int)newPriority, (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
        }
        this.manager.updateRegions(regions -> {
            ProtectionRegion newRegion = new ProtectionRegion(region.getId(), region.getArea(), newPriority, region.getExcludedPlayerIds(), region.getFlags());
            regions.put(region.getId(), newRegion);
        });
        this.success((CommandSender)sender, (Component)Component.translatable((String)"protections.command.priority.updated", (ComponentLike[])new ComponentLike[]{Component.text((int)newPriority, (TextColor)NamedTextColor.WHITE), Component.text((String)region.getId(), (TextColor)NamedTextColor.WHITE)}));
    }

    private static enum AreaType {
        BOX{

            @Override
            public Argument<?> provideArgs(ProtectionsCommand command) {
                return (Argument)new LocationArgument("corner1", LocationType.BLOCK_POSITION).then(new LocationArgument("corner2", LocationType.BLOCK_POSITION).then((AbstractArgumentTree)((Argument)new WorldArgument("dimension").setOptional(true)).executesNative((sender, args) -> command.createRegion(sender, args, this))));
            }

            @Override
            public IProtectionArea create(NativeProxyCommandSender sender, CommandArguments args) {
                World dimension = args.getOptionalUnchecked("dimension").orElseGet(() -> ((NativeProxyCommandSender)sender).getWorld());
                Vector corner1 = Objects.requireNonNull((Location)args.getUnchecked("corner1")).toVector();
                Vector corner2 = Objects.requireNonNull((Location)args.getUnchecked("corner2")).toVector();
                BlockBBox box = new BlockBBox(dimension, corner1, corner2);
                return new BoxProtectionArea(box);
            }

            @Override
            protected boolean matches(IProtectionArea instance) {
                return instance instanceof BoxProtectionArea;
            }

            @Override
            public Component getDescription(IProtectionArea instance) {
                BlockBBox box = ((BoxProtectionArea)instance).getBox();
                String dimensionStr = box.getWorld().getKey().asString();
                String minStr = box.getMinX() + ":" + box.getMinY() + ":" + box.getMinZ();
                String maxStr = box.getMaxX() + ":" + box.getMaxY() + ":" + box.getMaxZ();
                String centerStr = box.getBlockCenterX() + ":" + box.getBlockCenterY() + ":" + box.getBlockCenterZ();
                return Component.translatable((String)"protections.command.list.box", (ComponentLike[])new ComponentLike[]{Component.text((String)minStr, (TextColor)NamedTextColor.WHITE), Component.text((String)maxStr, (TextColor)NamedTextColor.WHITE), Component.text((String)dimensionStr, (TextColor)NamedTextColor.WHITE)}).hoverEvent((HoverEventSource)Component.translatable((String)"protections.command.list.hover", (ComponentLike[])new ComponentLike[]{Component.text((String)centerStr, (TextColor)NamedTextColor.WHITE)}));
            }
        }
        ,
        SPHERE{

            @Override
            public Argument<?> provideArgs(ProtectionsCommand command) {
                return (Argument)new LocationArgument("center", LocationType.BLOCK_POSITION).then(new DoubleArgument("radius", Vector.getEpsilon()).then((AbstractArgumentTree)((Argument)new WorldArgument("dimension").setOptional(true)).executesNative((sender, args) -> command.createRegion(sender, args, this))));
            }

            @Override
            public IProtectionArea create(NativeProxyCommandSender sender, CommandArguments args) {
                World dimension = args.getOptionalUnchecked("dimension").orElseGet(() -> ((NativeProxyCommandSender)sender).getWorld());
                double radius = Objects.requireNonNull((Double)args.getUnchecked("radius"));
                Block centerBlock = Objects.requireNonNull((Location)args.getUnchecked("center")).getBlock();
                BlockPosition centerBlockPos = Position.block((int)centerBlock.getX(), (int)centerBlock.getY(), (int)centerBlock.getZ());
                return new SphericalProtectionArea(dimension, centerBlockPos, radius);
            }

            @Override
            protected boolean matches(IProtectionArea instance) {
                return instance instanceof SphericalProtectionArea;
            }

            @Override
            public Component getDescription(IProtectionArea instance) {
                SphericalProtectionArea area = (SphericalProtectionArea)instance;
                BlockPosition centerBlock = area.getCenterBlockPos();
                String dimensionStr = area.getWorld().getKey().asString();
                String centerStr = centerBlock.blockX() + ":" + centerBlock.blockY() + ":" + centerBlock.blockZ();
                String radiusStr = "%,.2f".formatted(area.getRadius());
                return Component.translatable((String)"protections.command.list.spherical", (ComponentLike[])new ComponentLike[]{Component.text((String)radiusStr, (TextColor)NamedTextColor.WHITE), Component.text((String)centerStr, (TextColor)NamedTextColor.WHITE), Component.text((String)dimensionStr, (TextColor)NamedTextColor.WHITE)}).hoverEvent((HoverEventSource)Component.translatable((String)"protections.command.list.hover", (ComponentLike[])new ComponentLike[]{Component.text((String)centerStr, (TextColor)NamedTextColor.WHITE)}));
            }
        };


        public static AreaType get(IProtectionArea instance) {
            for (AreaType areaType : AreaType.values()) {
                if (!areaType.matches(instance)) continue;
                return areaType;
            }
            throw new UnsupportedOperationException("Unsupported area implementation: " + String.valueOf(instance));
        }

        public abstract Argument<?> provideArgs(ProtectionsCommand var1);

        public abstract IProtectionArea create(NativeProxyCommandSender var1, CommandArguments var2);

        public abstract Component getDescription(IProtectionArea var1);

        protected abstract boolean matches(IProtectionArea var1);
    }
}

