/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.config;

import dev.booky.cloudcore.util.BlockBBox;
import dev.booky.cloudprotections.region.area.BoxProtectionArea;
import dev.booky.cloudprotections.region.area.IProtectionArea;
import dev.booky.cloudprotections.region.area.SphericalProtectionArea;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.bukkit.block.Block;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class ProtectionAreaSerializer
implements TypeSerializer<IProtectionArea> {
    public static final ProtectionAreaSerializer INSTANCE = new ProtectionAreaSerializer();

    private ProtectionAreaSerializer() {
    }

    public IProtectionArea deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.virtual()) {
            return null;
        }
        if (node.hasChild(new Object[]{"radius"})) {
            Block centerBlock = Objects.requireNonNull((Block)node.node(new Object[]{"center"}).get(Block.class));
            double radius = node.node(new Object[]{"radius"}).getDouble();
            return new SphericalProtectionArea(centerBlock, radius);
        }
        BlockBBox box = Objects.requireNonNull((BlockBBox)node.get(BlockBBox.class));
        return new BoxProtectionArea(box);
    }

    public void serialize(Type type, @Nullable IProtectionArea obj, ConfigurationNode node) throws SerializationException {
        IProtectionArea iProtectionArea = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SphericalProtectionArea.class, BoxProtectionArea.class}, (Object)iProtectionArea, n)) {
            case -1: {
                node.set(null);
                break;
            }
            case 0: {
                SphericalProtectionArea area = (SphericalProtectionArea)iProtectionArea;
                node.node(new Object[]{"center"}).set((Object)area.getCenterBlock());
                node.node(new Object[]{"radius"}).set((Object)area.getRadius());
                break;
            }
            case 1: {
                BoxProtectionArea area = (BoxProtectionArea)iProtectionArea;
                node.set(BlockBBox.class, (Object)area.getBox());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected area: " + String.valueOf(obj));
            }
        }
    }
}

